/**
 * <copyright>
 * </copyright>
 *
 * $Id: BlockStatementImpl.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Block Statement</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.impl.BlockStatementImpl#isSynchronized <em>Synchronized</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.BlockStatementImpl#getStatements <em>Statements</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.BlockStatementImpl#getSurroundingFunction <em>Surrounding Function</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BlockStatementImpl extends StatementImpl implements BlockStatement {
	/**
	 * The default value of the '{@link #isSynchronized() <em>Synchronized</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSynchronized()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SYNCHRONIZED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isSynchronized() <em>Synchronized</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSynchronized()
	 * @generated
	 * @ordered
	 */
	protected boolean synchronized_ = SYNCHRONIZED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getStatements() <em>Statements</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatements()
	 * @generated
	 * @ordered
	 */
	protected EList<Statement> statements;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BlockStatementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return statementsPackage.Literals.BLOCK_STATEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSynchronized() {
		return synchronized_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSynchronized(boolean newSynchronized) {
		boolean oldSynchronized = synchronized_;
		synchronized_ = newSynchronized;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.BLOCK_STATEMENT__SYNCHRONIZED, oldSynchronized, synchronized_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Statement> getStatements() {
		if (statements == null) {
			statements = new EObjectContainmentWithInverseEList<Statement>(Statement.class, this, statementsPackage.BLOCK_STATEMENT__STATEMENTS, statementsPackage.STATEMENT__BLOCKSTATEMENT);
		}
		return statements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Function getSurroundingFunction() {
		if (eContainerFeatureID() != statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION) return null;
		return (Function)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingFunction(Function newSurroundingFunction, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingFunction, statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingFunction(Function newSurroundingFunction) {
		if (newSurroundingFunction != eInternalContainer() || (eContainerFeatureID() != statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION && newSurroundingFunction != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingFunction))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingFunction != null)
				msgs = ((InternalEObject)newSurroundingFunction).eInverseAdd(this, functionsPackage.FUNCTION__BODY, Function.class, msgs);
			msgs = basicSetSurroundingFunction(newSurroundingFunction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION, newSurroundingFunction, newSurroundingFunction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case statementsPackage.BLOCK_STATEMENT__STATEMENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getStatements()).basicAdd(otherEnd, msgs);
			case statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingFunction((Function)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case statementsPackage.BLOCK_STATEMENT__STATEMENTS:
				return ((InternalEList<?>)getStatements()).basicRemove(otherEnd, msgs);
			case statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION:
				return basicSetSurroundingFunction(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION:
				return eInternalContainer().eInverseRemove(this, functionsPackage.FUNCTION__BODY, Function.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case statementsPackage.BLOCK_STATEMENT__SYNCHRONIZED:
				return isSynchronized();
			case statementsPackage.BLOCK_STATEMENT__STATEMENTS:
				return getStatements();
			case statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION:
				return getSurroundingFunction();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case statementsPackage.BLOCK_STATEMENT__SYNCHRONIZED:
				setSynchronized((Boolean)newValue);
				return;
			case statementsPackage.BLOCK_STATEMENT__STATEMENTS:
				getStatements().clear();
				getStatements().addAll((Collection<? extends Statement>)newValue);
				return;
			case statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION:
				setSurroundingFunction((Function)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case statementsPackage.BLOCK_STATEMENT__SYNCHRONIZED:
				setSynchronized(SYNCHRONIZED_EDEFAULT);
				return;
			case statementsPackage.BLOCK_STATEMENT__STATEMENTS:
				getStatements().clear();
				return;
			case statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION:
				setSurroundingFunction((Function)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case statementsPackage.BLOCK_STATEMENT__SYNCHRONIZED:
				return synchronized_ != SYNCHRONIZED_EDEFAULT;
			case statementsPackage.BLOCK_STATEMENT__STATEMENTS:
				return statements != null && !statements.isEmpty();
			case statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION:
				return getSurroundingFunction() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (synchronized: ");
		result.append(synchronized_);
		result.append(')');
		return result.toString();
	}

} //BlockStatementImpl
