/**
 * <copyright>
 * </copyright>
 *
 * $Id: Statement.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements;

import de.fzi.gast.accesses.BaseAccess;
import org.eclipse.emf.common.util.EList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.core.SourceEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Statement</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The Statement class is the root of the statement hierarchy and represents a statement, which can occur inside a function body. Non-local class declarations, imports and other object-oriented language statements, which cannot occur inside a function body, are not modelled.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.Statement#getAccesses <em>Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getBlockstatement <em>Blockstatement</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getSurroundingStatement <em>Surrounding Statement</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getNumberOfStatements <em>Number Of Statements</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getMaximumNestingLevel <em>Maximum Nesting Level</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getNumberOfComments <em>Number Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getNumberOfEdgesInCFG <em>Number Of Edges In CFG</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getNumberOfNodesInCFG <em>Number Of Nodes In CFG</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getBranch <em>Branch</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Statement#getLoopstatement <em>Loopstatement</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.statements.statementsPackage#getStatement()
 * @model abstract="true"
 * @generated
 */
public interface Statement extends SourceEntity {
	/**
	 * Returns the value of the '<em><b>Blockstatement</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.BlockStatement#getStatements <em>Statements</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Blockstatement</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Blockstatement</em>' container reference.
	 * @see #setBlockstatement(BlockStatement)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_Blockstatement()
	 * @see de.fzi.gast.statements.BlockStatement#getStatements
	 * @model opposite="statements" transient="false" ordered="false"
	 * @generated
	 */
	BlockStatement getBlockstatement();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getBlockstatement <em>Blockstatement</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Blockstatement</em>' container reference.
	 * @see #getBlockstatement()
	 * @generated
	 */
	void setBlockstatement(BlockStatement value);

	/**
	 * Returns the value of the '<em><b>Accesses</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.accesses.BaseAccess}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.accesses.BaseAccess#getParentStatement <em>Parent Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of accesses within this statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Accesses</em>' containment reference list.
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_Accesses()
	 * @see de.fzi.gast.accesses.BaseAccess#getParentStatement
	 * @model opposite="parentStatement" containment="true" ordered="false"
	 * @generated
	 */
	EList<BaseAccess> getAccesses();

	/**
	 * Returns the value of the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the surrounding statement of this statement. If there is no surrounding statement this property is "null".
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Statement</em>' reference.
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_SurroundingStatement()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	Statement getSurroundingStatement();

	/**
	 * Returns the value of the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of statements within this statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Number Of Statements</em>' attribute.
	 * @see #setNumberOfStatements(int)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_NumberOfStatements()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getNumberOfStatements();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getNumberOfStatements <em>Number Of Statements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Number Of Statements</em>' attribute.
	 * @see #getNumberOfStatements()
	 * @generated
	 */
	void setNumberOfStatements(int value);

	/**
	 * Returns the value of the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the maximum nesting level of the control-flow structure within the statement, with respect to the depth of encapsulation of statements. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Maximum Nesting Level</em>' attribute.
	 * @see #setMaximumNestingLevel(int)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_MaximumNestingLevel()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getMaximumNestingLevel();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getMaximumNestingLevel <em>Maximum Nesting Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Maximum Nesting Level</em>' attribute.
	 * @see #getMaximumNestingLevel()
	 * @generated
	 */
	void setMaximumNestingLevel(int value);

	/**
	 * Returns the value of the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of comments attached to this statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Number Of Comments</em>' attribute.
	 * @see #setNumberOfComments(int)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_NumberOfComments()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getNumberOfComments();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getNumberOfComments <em>Number Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Number Of Comments</em>' attribute.
	 * @see #getNumberOfComments()
	 * @generated
	 */
	void setNumberOfComments(int value);

	/**
	 * Returns the value of the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of code lines that belong to this statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Lines Of Code</em>' attribute.
	 * @see #setLinesOfCode(int)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_LinesOfCode()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getLinesOfCode();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getLinesOfCode <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Lines Of Code</em>' attribute.
	 * @see #getLinesOfCode()
	 * @generated
	 */
	void setLinesOfCode(int value);

	/**
	 * Returns the value of the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of edges in the control-flow graph of the statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Number Of Edges In CFG</em>' attribute.
	 * @see #setNumberOfEdgesInCFG(int)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_NumberOfEdgesInCFG()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getNumberOfEdgesInCFG();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getNumberOfEdgesInCFG <em>Number Of Edges In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Number Of Edges In CFG</em>' attribute.
	 * @see #getNumberOfEdgesInCFG()
	 * @generated
	 */
	void setNumberOfEdgesInCFG(int value);

	/**
	 * Returns the value of the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of nodes in the control-flow graph of the statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Number Of Nodes In CFG</em>' attribute.
	 * @see #setNumberOfNodesInCFG(int)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_NumberOfNodesInCFG()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getNumberOfNodesInCFG();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getNumberOfNodesInCFG <em>Number Of Nodes In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Number Of Nodes In CFG</em>' attribute.
	 * @see #getNumberOfNodesInCFG()
	 * @generated
	 */
	void setNumberOfNodesInCFG(int value);

	/**
	 * Returns the value of the '<em><b>Branch</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.Branch#getStatement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Branch</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Branch</em>' container reference.
	 * @see #setBranch(Branch)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_Branch()
	 * @see de.fzi.gast.statements.Branch#getStatement
	 * @model opposite="statement" transient="false" ordered="false"
	 * @generated
	 */
	Branch getBranch();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getBranch <em>Branch</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Branch</em>' container reference.
	 * @see #getBranch()
	 * @generated
	 */
	void setBranch(Branch value);

	/**
	 * Returns the value of the '<em><b>Loopstatement</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.LoopStatement#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Loopstatement</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Loopstatement</em>' container reference.
	 * @see #setLoopstatement(LoopStatement)
	 * @see de.fzi.gast.statements.statementsPackage#getStatement_Loopstatement()
	 * @see de.fzi.gast.statements.LoopStatement#getBody
	 * @model opposite="body" transient="false" ordered="false"
	 * @generated
	 */
	LoopStatement getLoopstatement();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Statement#getLoopstatement <em>Loopstatement</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Loopstatement</em>' container reference.
	 * @see #getLoopstatement()
	 * @generated
	 */
	void setLoopstatement(LoopStatement value);

} // Statement
