/**
 * <copyright>
 * </copyright>
 *
 * $Id: LoopStatementKind.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Loop Statement Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This enumeration represents the kinds of loop statements.
 * <!-- end-model-doc -->
 * @see de.fzi.gast.statements.statementsPackage#getLoopStatementKind()
 * @model
 * @generated
 */
public enum LoopStatementKind implements Enumerator {
	/**
	 * The '<em><b>FOREACH</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FOREACH_VALUE
	 * @generated
	 * @ordered
	 */
	FOREACH(0, "FOREACH", "FOREACH"),

	/**
	 * The '<em><b>WHILE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WHILE_VALUE
	 * @generated
	 * @ordered
	 */
	WHILE(1, "WHILE", "WHILE"),

	/**
	 * The '<em><b>DOWHILE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DOWHILE_VALUE
	 * @generated
	 * @ordered
	 */
	DOWHILE(2, "DOWHILE", "DOWHILE"),

	/**
	 * The '<em><b>FOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FOR_VALUE
	 * @generated
	 * @ordered
	 */
	FOR(3, "FOR", "FOR");

	/**
	 * The '<em><b>FOREACH</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that a loop statement represents a for-each loop.
	 * <!-- end-model-doc -->
	 * @see #FOREACH
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int FOREACH_VALUE = 0;

	/**
	 * The '<em><b>WHILE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that a loop statement represents a while loop.
	 * <!-- end-model-doc -->
	 * @see #WHILE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WHILE_VALUE = 1;

	/**
	 * The '<em><b>DOWHILE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that a loop statement represents a do-while loop.
	 * <!-- end-model-doc -->
	 * @see #DOWHILE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DOWHILE_VALUE = 2;

	/**
	 * The '<em><b>FOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that a loop statement represents a for loop.
	 * <!-- end-model-doc -->
	 * @see #FOR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int FOR_VALUE = 3;

	/**
	 * An array of all the '<em><b>Loop Statement Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final LoopStatementKind[] VALUES_ARRAY =
		new LoopStatementKind[] {
			FOREACH,
			WHILE,
			DOWHILE,
			FOR,
		};

	/**
	 * A public read-only list of all the '<em><b>Loop Statement Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<LoopStatementKind> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Loop Statement Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static LoopStatementKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LoopStatementKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Loop Statement Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static LoopStatementKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LoopStatementKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Loop Statement Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static LoopStatementKind get(int value) {
		switch (value) {
			case FOREACH_VALUE: return FOREACH;
			case WHILE_VALUE: return WHILE;
			case DOWHILE_VALUE: return DOWHILE;
			case FOR_VALUE: return FOR;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private LoopStatementKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //LoopStatementKind
