/**
 * <copyright>
 * </copyright>
 *
 * $Id: LoopStatement.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Loop Statement</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The LoopStatement class models all kinds of looping statements, which can occur in considered object-oriented programming languages, e. g. for, while, do-while or foreach. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.LoopStatement#getKind <em>Kind</em>}</li>
 *   <li>{@link de.fzi.gast.statements.LoopStatement#getBreakConditionExpression <em>Break Condition Expression</em>}</li>
 *   <li>{@link de.fzi.gast.statements.LoopStatement#getInitExpression <em>Init Expression</em>}</li>
 *   <li>{@link de.fzi.gast.statements.LoopStatement#getIncrementExpression <em>Increment Expression</em>}</li>
 *   <li>{@link de.fzi.gast.statements.LoopStatement#getBody <em>Body</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.statements.statementsPackage#getLoopStatement()
 * @model
 * @generated
 */
public interface LoopStatement extends Statement {
	/**
	 * Returns the value of the '<em><b>Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.statements.LoopStatementKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Kind</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Kind</em>' attribute.
	 * @see de.fzi.gast.statements.LoopStatementKind
	 * @see #setKind(LoopStatementKind)
	 * @see de.fzi.gast.statements.statementsPackage#getLoopStatement_Kind()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	LoopStatementKind getKind();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.LoopStatement#getKind <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Kind</em>' attribute.
	 * @see de.fzi.gast.statements.LoopStatementKind
	 * @see #getKind()
	 * @generated
	 */
	void setKind(LoopStatementKind value);

	/**
	 * Returns the value of the '<em><b>Body</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.Statement#getLoopstatement <em>Loopstatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the statement which represents the body of this loop statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Body</em>' containment reference.
	 * @see #setBody(Statement)
	 * @see de.fzi.gast.statements.statementsPackage#getLoopStatement_Body()
	 * @see de.fzi.gast.statements.Statement#getLoopstatement
	 * @model opposite="loopstatement" containment="true" required="true" ordered="false"
	 * @generated
	 */
	Statement getBody();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.LoopStatement#getBody <em>Body</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Body</em>' containment reference.
	 * @see #getBody()
	 * @generated
	 */
	void setBody(Statement value);

	/**
	 * Returns the value of the '<em><b>Break Condition Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the expression which represents the break condition of this loop statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Break Condition Expression</em>' containment reference.
	 * @see #setBreakConditionExpression(GASTExpression)
	 * @see de.fzi.gast.statements.statementsPackage#getLoopStatement_BreakConditionExpression()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	GASTExpression getBreakConditionExpression();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.LoopStatement#getBreakConditionExpression <em>Break Condition Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Break Condition Expression</em>' containment reference.
	 * @see #getBreakConditionExpression()
	 * @generated
	 */
	void setBreakConditionExpression(GASTExpression value);

	/**
	 * Returns the value of the '<em><b>Init Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the initialization expression of the loop. This property is optional.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Init Expression</em>' containment reference.
	 * @see #setInitExpression(GASTExpression)
	 * @see de.fzi.gast.statements.statementsPackage#getLoopStatement_InitExpression()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	GASTExpression getInitExpression();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.LoopStatement#getInitExpression <em>Init Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Init Expression</em>' containment reference.
	 * @see #getInitExpression()
	 * @generated
	 */
	void setInitExpression(GASTExpression value);

	/**
	 * Returns the value of the '<em><b>Increment Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the incrementation expression of the loop. This property is optional.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Increment Expression</em>' containment reference.
	 * @see #setIncrementExpression(GASTExpression)
	 * @see de.fzi.gast.statements.statementsPackage#getLoopStatement_IncrementExpression()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	GASTExpression getIncrementExpression();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.LoopStatement#getIncrementExpression <em>Increment Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Increment Expression</em>' containment reference.
	 * @see #getIncrementExpression()
	 * @generated
	 */
	void setIncrementExpression(GASTExpression value);

} // LoopStatement
