/**
 * <copyright>
 * </copyright>
 *
 * $Id: JumpStatement.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Jump Statement</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class models all kinds of non-conditional jumps. Throwing of exceptions and return-statements are also categorized as non-conditional jumps. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.JumpStatement#getKind <em>Kind</em>}</li>
 *   <li>{@link de.fzi.gast.statements.JumpStatement#getExpression <em>Expression</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.statements.statementsPackage#getJumpStatement()
 * @model
 * @generated
 */
public interface JumpStatement extends Statement {
	/**
	 * Returns the value of the '<em><b>Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.statements.JumpStatementKind}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is a reference to the kind of the jump statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Kind</em>' attribute.
	 * @see de.fzi.gast.statements.JumpStatementKind
	 * @see #setKind(JumpStatementKind)
	 * @see de.fzi.gast.statements.statementsPackage#getJumpStatement_Kind()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	JumpStatementKind getKind();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.JumpStatement#getKind <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Kind</em>' attribute.
	 * @see de.fzi.gast.statements.JumpStatementKind
	 * @see #getKind()
	 * @generated
	 */
	void setKind(JumpStatementKind value);

	/**
	 * Returns the value of the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a expression contained in this JumpStatement, e. g. body of a return statement, such as "a+b" in "return a+b;".
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Expression</em>' containment reference.
	 * @see #setExpression(GASTExpression)
	 * @see de.fzi.gast.statements.statementsPackage#getJumpStatement_Expression()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	GASTExpression getExpression();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.JumpStatement#getExpression <em>Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Expression</em>' containment reference.
	 * @see #getExpression()
	 * @generated
	 */
	void setExpression(GASTExpression value);

} // JumpStatement
