/**
 * <copyright>
 * </copyright>
 *
 * $Id: ExceptionHandler.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Exception Handler</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents handlings of exceptions. A typical exception handling consists of a guarded block, also known as try block, and several catch blocks. An optional finally block can be contained.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.ExceptionHandler#getCatchBlocks <em>Catch Blocks</em>}</li>
 *   <li>{@link de.fzi.gast.statements.ExceptionHandler#getFinallyBlock <em>Finally Block</em>}</li>
 *   <li>{@link de.fzi.gast.statements.ExceptionHandler#getGuardedBlock <em>Guarded Block</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.statements.statementsPackage#getExceptionHandler()
 * @model
 * @generated
 */
public interface ExceptionHandler extends Statement {
	/**
	 * Returns the value of the '<em><b>Catch Blocks</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.statements.CatchBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of the catch blocks of this exception handler.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Catch Blocks</em>' containment reference list.
	 * @see de.fzi.gast.statements.statementsPackage#getExceptionHandler_CatchBlocks()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<CatchBlock> getCatchBlocks();

	/**
	 * Returns the value of the '<em><b>Finally Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the finally block of this exception handler. If there is no finally block then this property will be "null".
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Finally Block</em>' containment reference.
	 * @see #setFinallyBlock(BlockStatement)
	 * @see de.fzi.gast.statements.statementsPackage#getExceptionHandler_FinallyBlock()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	BlockStatement getFinallyBlock();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.ExceptionHandler#getFinallyBlock <em>Finally Block</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Finally Block</em>' containment reference.
	 * @see #getFinallyBlock()
	 * @generated
	 */
	void setFinallyBlock(BlockStatement value);

	/**
	 * Returns the value of the '<em><b>Guarded Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the block statement which is guarded by this exception handler.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Guarded Block</em>' containment reference.
	 * @see #setGuardedBlock(BlockStatement)
	 * @see de.fzi.gast.statements.statementsPackage#getExceptionHandler_GuardedBlock()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	BlockStatement getGuardedBlock();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.ExceptionHandler#getGuardedBlock <em>Guarded Block</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Guarded Block</em>' containment reference.
	 * @see #getGuardedBlock()
	 * @generated
	 */
	void setGuardedBlock(BlockStatement value);

} // ExceptionHandler
