/**
 * <copyright>
 * </copyright>
 *
 * $Id: CatchBlock.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements;

import de.fzi.gast.variables.CatchParameter;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Catch Block</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a catch block. It extends the BlockStatement class and has a catch parameter.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.CatchBlock#getCatchParameter <em>Catch Parameter</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.statements.statementsPackage#getCatchBlock()
 * @model
 * @generated
 */
public interface CatchBlock extends BlockStatement {
	/**
	 * Returns the value of the '<em><b>Catch Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the catch parameter for this catch block.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Catch Parameter</em>' containment reference.
	 * @see #setCatchParameter(CatchParameter)
	 * @see de.fzi.gast.statements.statementsPackage#getCatchBlock_CatchParameter()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	CatchParameter getCatchParameter();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.CatchBlock#getCatchParameter <em>Catch Parameter</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Catch Parameter</em>' containment reference.
	 * @see #getCatchParameter()
	 * @generated
	 */
	void setCatchParameter(CatchParameter value);

} // CatchBlock
