/**
 * <copyright>
 * </copyright>
 *
 * $Id: Branch.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements;

import de.fzi.gast.core.SourceEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Branch</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a branch of a BranchStatement.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.Branch#getConditionExpression <em>Condition Expression</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Branch#getBranchstatement <em>Branchstatement</em>}</li>
 *   <li>{@link de.fzi.gast.statements.Branch#getStatement <em>Statement</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.statements.statementsPackage#getBranch()
 * @model
 * @generated
 */
public interface Branch extends SourceEntity {
	/**
	 * Returns the value of the '<em><b>Condition Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * <p>
	 *     This&nbsp;property&nbsp;represents&nbsp;the&nbsp;condition&nbsp;expression&nbsp;for&nbsp;this&nbsp;branch. Set to
	 *     optional only due to tool support: Expressions are currently not always extracted.
	 * </p>
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Condition Expression</em>' containment reference.
	 * @see #setConditionExpression(GASTExpression)
	 * @see de.fzi.gast.statements.statementsPackage#getBranch_ConditionExpression()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	GASTExpression getConditionExpression();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Branch#getConditionExpression <em>Condition Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Condition Expression</em>' containment reference.
	 * @see #getConditionExpression()
	 * @generated
	 */
	void setConditionExpression(GASTExpression value);

	/**
	 * Returns the value of the '<em><b>Branchstatement</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.BranchStatement#getBranches <em>Branches</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Branchstatement</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Branchstatement</em>' container reference.
	 * @see #setBranchstatement(BranchStatement)
	 * @see de.fzi.gast.statements.statementsPackage#getBranch_Branchstatement()
	 * @see de.fzi.gast.statements.BranchStatement#getBranches
	 * @model opposite="branches" required="true" transient="false" ordered="false"
	 * @generated
	 */
	BranchStatement getBranchstatement();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Branch#getBranchstatement <em>Branchstatement</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Branchstatement</em>' container reference.
	 * @see #getBranchstatement()
	 * @generated
	 */
	void setBranchstatement(BranchStatement value);

	/**
	 * Returns the value of the '<em><b>Statement</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.Statement#getBranch <em>Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the statement which represents the body of this branch.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Statement</em>' containment reference.
	 * @see #setStatement(Statement)
	 * @see de.fzi.gast.statements.statementsPackage#getBranch_Statement()
	 * @see de.fzi.gast.statements.Statement#getBranch
	 * @model opposite="branch" containment="true" required="true" ordered="false"
	 * @generated
	 */
	Statement getStatement();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.Branch#getStatement <em>Statement</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Statement</em>' containment reference.
	 * @see #getStatement()
	 * @generated
	 */
	void setStatement(Statement value);

} // Branch
