/**
 * <copyright>
 * </copyright>
 *
 * $Id: BlockStatement.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.functions.Function;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Block Statement</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The BlockStatement class models a composition statement or a function body. It also represents synchronized blocks.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.BlockStatement#isSynchronized <em>Synchronized</em>}</li>
 *   <li>{@link de.fzi.gast.statements.BlockStatement#getStatements <em>Statements</em>}</li>
 *   <li>{@link de.fzi.gast.statements.BlockStatement#getSurroundingFunction <em>Surrounding Function</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.statements.statementsPackage#getBlockStatement()
 * @model
 * @generated
 */
public interface BlockStatement extends Statement {
	/**
	 * Returns the value of the '<em><b>Synchronized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this block statement represents a synchronized block.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Synchronized</em>' attribute.
	 * @see #setSynchronized(boolean)
	 * @see de.fzi.gast.statements.statementsPackage#getBlockStatement_Synchronized()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isSynchronized();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.BlockStatement#isSynchronized <em>Synchronized</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Synchronized</em>' attribute.
	 * @see #isSynchronized()
	 * @generated
	 */
	void setSynchronized(boolean value);

	/**
	 * Returns the value of the '<em><b>Statements</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.statements.Statement}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.Statement#getBlockstatement <em>Blockstatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is an ordered list of statements inside this block statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Statements</em>' containment reference list.
	 * @see de.fzi.gast.statements.statementsPackage#getBlockStatement_Statements()
	 * @see de.fzi.gast.statements.Statement#getBlockstatement
	 * @model opposite="blockstatement" containment="true" ordered="false"
	 * @generated
	 */
	EList<Statement> getStatements();

	/**
	 * Returns the value of the '<em><b>Surrounding Function</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Function#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If this block statement is a function body this is property is a reference to the function. Otherwise it is "null".
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Function</em>' container reference.
	 * @see #setSurroundingFunction(Function)
	 * @see de.fzi.gast.statements.statementsPackage#getBlockStatement_SurroundingFunction()
	 * @see de.fzi.gast.functions.Function#getBody
	 * @model opposite="body" transient="false" ordered="false"
	 * @generated
	 */
	Function getSurroundingFunction();

	/**
	 * Sets the value of the '{@link de.fzi.gast.statements.BlockStatement#getSurroundingFunction <em>Surrounding Function</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Function</em>' container reference.
	 * @see #getSurroundingFunction()
	 * @generated
	 */
	void setSurroundingFunction(Function value);

} // BlockStatement
