package de.fzi.gast.helpers;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Package;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.core.impl.FileImpl;
import de.fzi.gast.functions.Constructor;
import de.fzi.gast.functions.Destructor;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.functions.Method;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.typesPackage;

/**
 * This class helps to calculate derived attributes within the GAST model.
 * 
 * @author stammel
 *
 */
public class DerivationHelper {
	
	// REMOVED BY STEFFEN
	// DO NOT ADD THEM AGAIN WITHOUT PERMISSION BY STEFFEN
	
//	private static HashMap<EObject, EList<Access>> cachedSubTreeTypeAccesses = new HashMap<EObject, EList<Access>>();
//	private static HashMap<GASTClass, EList<GASTClass>> cachedAllAccessesClasses = new HashMap<GASTClass, EList<GASTClass>>();
//	private static HashMap<Package, EList<Package>> cachedAllAccessedPackages = new HashMap<Package, EList<Package>>();
//
//	private static HashMap<EObjectAndTypeTuple, EList<GASTClass>> cachedAllClasses = new HashMap<EObjectAndTypeTuple, EList<GASTClass>>();	
//	private static HashMap<ModelElement, ModelElement> cachedNearestParentOfTypeGastClass = new HashMap<ModelElement, ModelElement>();

	
	/**
	 * Complex key for cache lookup
	 * @author kelsaka
	 */
	private static class EObjectAndTypeTuple {
		public EObject eObject;
		public int type;
		
		@Override
		public int hashCode() {
			return eObject.hashCode() + type;
		}
	}
	
	/**
	 *
	 * @param element
	 * @param aclass
	 * @return the parent object, null if not found
	 */
	public static ModelElement calculateNearestParentOfType(ModelElement element, java.lang.Class<?> aclass) {
		return calculateNearestParentOfType(element, aclass, null);
	}
	
	/**
	 * 
	 * @param element
	 * @param aclass 
	 * @param breakType Type of parent, which immediately stops searching for the parent.
	 * @return the parent object, null if not found
	 */	
	public static ModelElement calculateNearestParentOfType(ModelElement element, java.lang.Class<?> aclass, java.lang.Class<?> breakType) {

		//use cache if available
//		if(aclass == GASTClass.class && cachedNearestParentOfTypeGastClass.containsKey(element)) { 
//			return cachedNearestParentOfTypeGastClass.get(element);
//		} 
		
		ModelElement returnModelElement;
		if (element.eContainer() != null && element.eContainer() instanceof ModelElement) {

			ModelElement parent = (ModelElement)element.eContainer();
			
			while (parent != null && !aclass.isInstance(parent)) {
				if(breakType != null && breakType.isInstance(parent)) {
					parent = null;
				} else {			
					parent = (ModelElement)parent.eContainer();
				}
			}				
			returnModelElement = parent;
		} else {
			returnModelElement = null;
		}
		
//		//update cache
//		if(aclass == GASTClass.class) {
//			cachedNearestParentOfTypeGastClass.put(element, returnModelElement); 
//		} 
		return returnModelElement;	
	}

	public static EList selectElementsWithFilePosition(
			EList<?> elements, FileImpl fileImpl) {

		EList<Object> result = new BasicInternalEList<Object>(SourceEntity.class);

		if (fileImpl==null)
			return result;

		
		for (Object elem : elements) {
			if (elem instanceof SourceEntity) {
				if ((((SourceEntity)elem).getPosition()!=null)&&(((SourceEntity)elem).getPosition().getSourceFile()==fileImpl)) {
					result.add(elem);
				}
			}
		}
		
		return result;
	}
	
	public static EList<Access> selectAccessesInSubtree(EObject modelElement) {
		// check cache first:
//		if(cachedSubTreeTypeAccesses.containsKey(modelElement)) {
//			return cachedSubTreeTypeAccesses.get(modelElement);
//		}
		
		EList<Access> result = new BasicInternalEList<Access>(Access.class);
		
		for (Iterator<EObject> itr = modelElement.eAllContents(); itr.hasNext(); ) {
			Object element = itr.next();
			
			if (element instanceof Access) {
				if(element!=null){
					result.add((Access) element);					
					
				}
			}
		}
		
		//update cache:
//		cachedSubTreeTypeAccesses.put(modelElement, result); 
		return result;
	}
	/**
	 * 
	 * @param modelElement
	 * @return all accesses recursively found in this Model Element
	 */
	public static EList<Access> getAllAccesses(ModelElement modelElement) {
		EList<Access> result = new BasicInternalEList<Access>(Access.class);

		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(modelElement,true); iter.hasNext();) {
			EObject eObject = (EObject) iter.next();
			if ((eObject != null) && (eObject instanceof Access)){
				result.add((Access) eObject);
			}
		}

		return result;
	}
	
	
//	public static EList<ModelElement> getModelElements(ModelElementRepository modelElementRep) {
//		EList<ModelElement> result = new BasicInternalEList<ModelElement>(ModelElement.class);
//		
//		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(modelElementRep.eResource(), true); iter.hasNext();) {
//			EObject eObject = (EObject) iter.next();
//			result.add((ModelElement)eObject);
//		}
//		return result;
//		
//	}
	

	
	public static int getLinesOfCode(Root root) {
		int LOC = 0;
		for (GASTClass gclass : getAllClasses(root, 0)) {
			LOC += getLinesOfCode(gclass);
		}
		return LOC;
	}


	public static int getLinesOfCode(Package pack) {
		int LOC = 0;
		//according to SISSy implementation
		// Classes
		
		for (GASTClass gastClass : getAllClasses(pack,0)) {
			LOC += getLinesOfCode(gastClass);
		}

		// Global Functions
		EList<GlobalFunction> globalFunctions = pack.getGlobalFunctions();
		for (GlobalFunction globalFunction : globalFunctions) {
			//LOC += globalFunction.getLinesOfCode();
			LOC += globalFunction.getPosition().getEndLine() - globalFunction.getPosition().getStartLine() + 1; 
		}
		return LOC;
	}

	/**
	 * 
	 * @param gastClass
	 * @return
	 */
	public static int getLinesOfCode(GASTClass gastClass){
		int LOC = 0;
		//TODO use SISSy Analyzer to compute LOC of a class
		
		
		for (Method method : gastClass.getMethods()) {
			LOC += method.getPosition().getEndLine() - method.getPosition().getStartLine() + 1; 
		}
		for (Constructor cons : gastClass.getConstructors()) {
			LOC += cons.getPosition().getEndLine() - cons.getPosition().getStartLine() + 1; 
		}
		for (Destructor destruc : gastClass.getDestructors()) {
			LOC += destruc.getPosition().getEndLine() - destruc.getPosition().getStartLine() + 1; 
		}

		
		return LOC;
		
	}

	/**
	 * 
	 * @param place 
	 * @param type<br>
	 *         -typesPackage.GAST_CLASS__INNER<br>
	 *         -typesPackage.GAST_CLASS__LOCAL<br>
	 *         -typesPackage.GAST_CLASS__INTERFACE<br>
	 *         -0 (Normal Class)
	 *  
	 * @return all classes of a certain type (inner, local, normal, interface) recursively found in this modelelement
	 */
	public static EList<GASTClass> getAllClasses(EObject place, int type) {
		// check cache first:
		EObjectAndTypeTuple tuple = new EObjectAndTypeTuple();
		tuple.eObject = place;
		tuple.type = type;
//		if(cachedAllClasses.containsKey(tuple)) {			
//			return cachedAllClasses.get(tuple);
//		}
		
		EList<GASTClass> result = new BasicInternalEList<GASTClass>(GASTClass.class);
		
		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(place,true); iter.hasNext();) {
			EObject eObject = (EObject) iter.next();

			if ((eObject instanceof GASTClass) && (eObject!=null)){
			
				//inner classes
				if (type == typesPackage.GAST_CLASS__INNER) {
					if ( ((GASTClass)eObject).isInner() ){
						result.add((GASTClass) eObject);	
					}
				}
				//local classes
				if (type == typesPackage.GAST_CLASS__LOCAL) {
					if ( ((GASTClass)eObject).isLocal() ){
						result.add((GASTClass) eObject);
					}
				}
				//normal classes
				if (type == 0){
					//if is (NOT an inner c) AND (is NOT an local c) AND (is NOT an interface) then add 
					if( !(((GASTClass)eObject).isLocal()) && !(((GASTClass)eObject).isInner()) && !(((GASTClass)eObject).isInterface()))
					result.add((GASTClass)eObject);
				}
				//interfaces
				if (type == typesPackage.GAST_CLASS__INTERFACE){
					if ( ((GASTClass)eObject).isInterface() ){
						result.add((GASTClass) eObject);
					}
				}
			}
		}
		
		// update cache:
//		cachedAllClasses.put(tuple, result);
		return result;
	}
	
	public static EList<GASTType> getAllTypes(EObject start) {
		EList<GASTType> result = new BasicInternalEList<GASTType>(GASTType.class);
		
		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(start,true); iter.hasNext();) {
			EObject eObject = (EObject) iter.next();

			if ((eObject instanceof GASTType) && (eObject!=null)){
				result.add((GASTType) eObject);	
			}
		}

		return result;
	}
	
	public static boolean isInner(GASTClass gastclass){
		 
		return gastclass.eContainer() instanceof GASTClass ? true : false;
	}

	public static boolean isLocal(GASTClass gastclass) {
		
		return gastclass.eContainer() instanceof Function ? true : false;
		
	}

	public static EList<ModelElement> getAllModelElements(Root root) {
		EList<ModelElement> result = new BasicInternalEList<ModelElement>(ModelElement.class);
		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(root,true); iter.hasNext();) {
			EObject object= iter.next();
			
			if ((object!=null) && (object instanceof ModelElement)) {
				result.add((ModelElement)object);
			} 
			
			
		}
		return result;
	}

	public static EList<GASTClass> getAllAccessedClasses(GASTClass gastclass) {		 
		// check cache first:
//		if(cachedAllAccessesClasses.containsKey(gastclass)) {
//			return cachedAllAccessesClasses.get(gastclass);
//		}
		
		EList<GASTClass> result = new BasicInternalEList<GASTClass>(GASTClass.class);
		for (Access access : gastclass.getAllAccesses()) {
			GASTClass tempClass = access.getAccessedClass();
			
			if(!result.contains(tempClass)){
				if (!(tempClass==null)){
					result.add(tempClass);					
				}
				
			}
		}
//		cachedAllAccessesClasses.put(gastclass, result);
		return result;
	}

	public static EList<Package> getAllAccessedPackages(Package pack) {
		// check cache first:
//		if(cachedAllAccessedPackages.containsKey(pack)) {
//			return cachedAllAccessedPackages.get(pack);
//		}
		
		EList<Package> result = new BasicInternalEList<Package>(Package.class);
		for (Access access : pack.getAllAccesses()) {
			GASTClass gastclass = access.getAccessedClass();
			if(gastclass!=null)
			{
				Package tempPack = access.getAccessedClass().getSurroundingPackage();
				if(tempPack!=null){
					if (!result.contains(tempPack)) {
						result.add(tempPack);
					}
				}
			}
		}
//		cachedAllAccessedPackages.put(pack, result);
		return result;
	}

	public static EList<Statement> getAllStatements(Function function) {
		EList<Statement> result = new BasicInternalEList<Statement>(Statement.class);
		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(function,true); iter.hasNext();) {
			EObject object= iter.next();
			if((object instanceof Statement) && (object!=null)){
				result.add((Statement)object);	
			}
		}
		return result;

	}

	public static int getLinesOfComments(Package pack) {
		int LOComments=0;
		
		for (GASTClass gastclass : pack.getAllNormalClasses()) {
			//LOC += gastclass.getLinesOfComments();
			LOComments += getLinesOfComments(gastclass);
		}
		
		for (GlobalFunction gfunc : pack.getGlobalFunctions()) {
			LOComments += gfunc.getLinesOfComments();
		}
		
		return LOComments;
	}

	public static int getLinesOfComments(Root root) {
		int LOComments = 0;
		for (Package pack : root.getPackages()) {
			LOComments += getLinesOfComments(pack);
		}
		return LOComments;
		
	}
	
	public static int getLinesOfComments(GASTClass gastClass){
		int LOComments = 0;
		//TODO use SISSy Clone Analyzer to compute LOC of a class
		//LOC += gastClass.getPosition().getEndLine() - gastClass.getPosition().getStartLine();
		
		for (Method method : gastClass.getMethods()) {
			LOComments += method.getLinesOfComments(); 
		}
		for (Constructor cons : gastClass.getConstructors()) {
			LOComments += cons.getLinesOfComments(); 
		}
		for (Destructor destruc : gastClass.getDestructors()) {
			LOComments += destruc.getLinesOfComments(); 
		}
		
		return LOComments;
		
	}


	public static GASTClass getClassByQualifiedName(Root root,String name) {
		
		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(root,true); iter.hasNext();) {
			EObject gclass= iter.next();
			if((gclass instanceof GASTClass) && (gclass!=null)){
				if(((Package)gclass).getQualifiedName().equals(name)){
					return (GASTClass)gclass;
				}
			}
		}
		return null;
	}

	public static Package getPackageByQualifiedName(Root root,String qualifiedName) {

		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(root,true); iter.hasNext();) {
			EObject pack= iter.next();
			if((pack instanceof Package) && (pack!=null)){
				if(((Package)pack).getQualifiedName().equals(qualifiedName)){
					return (Package)pack;
				}
			}
		}
		return null;
	}

	public static Package getPackageByName(Root root, String name) {
		for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(root,true); iter.hasNext();) {
			EObject pack= iter.next();
			if((pack instanceof Package) && (pack!=null)){
				if(((Package)pack).getSimpleName().equals(name)){
					return (Package)pack;
				}
			}
		}
		return null;
	}

	public static Statement basicGetSurroundingStatement(Statement statement) {
		
		if (statement.eContainer() instanceof Statement){
			return (Statement)(statement.eContainer());
		}
		return null;
	}

	public static EList<GASTClass> getImplementedInterfacesOfGASTClass(GASTClass gastclass) {
		if (gastclass != null) {
			EList<GASTClass> implementedInterfaces = new BasicEList<GASTClass>();
			
			List<GASTClass> superTypes = gastclass.getSuperTypes();

			EList<GASTClass> nextSuperTypes = new BasicEList<GASTClass>();

			do {
				nextSuperTypes = new BasicEList<GASTClass>();
				
				for (GASTClass superType : superTypes) {
					if (superType.isInterface()) {
						implementedInterfaces.add(superType);
					} else {
						List<GASTClass> nextSuperTypeList = superType.getSuperTypes();
						for (GASTClass nextSuperType : nextSuperTypeList) {
							if (!nextSuperTypes.contains(nextSuperType)) 
								nextSuperTypes.add(nextSuperType);
						}
					}
				}
				
				superTypes = nextSuperTypes;
				
			} while (!nextSuperTypes.isEmpty());
			
			return implementedInterfaces;
		}
		
		return null;
	}

	public static EList<GASTClass> getInheritedAbstractClassesOfGASTClass(GASTClass gastclass) {

		return null;
	}


	// public static <T> EList<T> getAllHelper(){
	//		
	// EList<T> result = new BasicInternalEList<T>(T);
	//
	// for (Iterator<ModelElement> iter = EcoreUtil.getAllContents(root,true);
	// iter.hasNext();) {
	// EObject eObject = (EObject) iter.next();
	// if (eObject instanceof T){
	// result.add((T) eObject);
	// }
	// }
	//
	// return result;
	//		
	// }

}
