/**
 * <copyright>
 * </copyright>
 *
 * $Id: functionsSwitch.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.functions.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.gast.core.GenericEntity;
import de.fzi.gast.core.Identifier;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.NamedModelElement;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.functions.*;
import de.fzi.gast.functions.Constructor;
import de.fzi.gast.functions.Delegate;
import de.fzi.gast.functions.Destructor;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.GenericConstructor;
import de.fzi.gast.functions.GenericFunction;
import de.fzi.gast.functions.GenericMethod;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.functions.Method;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.Member;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.gast.functions.functionsPackage
 * @generated
 */
public class functionsSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static functionsPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public functionsSwitch() {
		if (modelPackage == null) {
			modelPackage = functionsPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case functionsPackage.DELEGATE: {
				Delegate delegate = (Delegate)theEObject;
				T result = caseDelegate(delegate);
				if (result == null) result = caseFunction(delegate);
				if (result == null) result = caseMember(delegate);
				if (result == null) result = caseGASTType(delegate);
				if (result == null) result = caseNamedModelElement(delegate);
				if (result == null) result = caseSourceEntity(delegate);
				if (result == null) result = caseModelElement(delegate);
				if (result == null) result = caseIdentifier(delegate);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case functionsPackage.CONSTRUCTOR: {
				Constructor constructor = (Constructor)theEObject;
				T result = caseConstructor(constructor);
				if (result == null) result = caseFunction(constructor);
				if (result == null) result = caseMember(constructor);
				if (result == null) result = caseNamedModelElement(constructor);
				if (result == null) result = caseSourceEntity(constructor);
				if (result == null) result = caseModelElement(constructor);
				if (result == null) result = caseIdentifier(constructor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case functionsPackage.DESTRUCTOR: {
				Destructor destructor = (Destructor)theEObject;
				T result = caseDestructor(destructor);
				if (result == null) result = caseFunction(destructor);
				if (result == null) result = caseMember(destructor);
				if (result == null) result = caseNamedModelElement(destructor);
				if (result == null) result = caseSourceEntity(destructor);
				if (result == null) result = caseModelElement(destructor);
				if (result == null) result = caseIdentifier(destructor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case functionsPackage.GENERIC_FUNCTION: {
				GenericFunction genericFunction = (GenericFunction)theEObject;
				T result = caseGenericFunction(genericFunction);
				if (result == null) result = caseGlobalFunction(genericFunction);
				if (result == null) result = caseGenericEntity(genericFunction);
				if (result == null) result = caseFunction(genericFunction);
				if (result == null) result = caseNamedModelElement(genericFunction);
				if (result == null) result = caseSourceEntity(genericFunction);
				if (result == null) result = caseModelElement(genericFunction);
				if (result == null) result = caseIdentifier(genericFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case functionsPackage.GLOBAL_FUNCTION: {
				GlobalFunction globalFunction = (GlobalFunction)theEObject;
				T result = caseGlobalFunction(globalFunction);
				if (result == null) result = caseFunction(globalFunction);
				if (result == null) result = caseNamedModelElement(globalFunction);
				if (result == null) result = caseSourceEntity(globalFunction);
				if (result == null) result = caseModelElement(globalFunction);
				if (result == null) result = caseIdentifier(globalFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case functionsPackage.METHOD: {
				Method method = (Method)theEObject;
				T result = caseMethod(method);
				if (result == null) result = caseFunction(method);
				if (result == null) result = caseMember(method);
				if (result == null) result = caseNamedModelElement(method);
				if (result == null) result = caseSourceEntity(method);
				if (result == null) result = caseModelElement(method);
				if (result == null) result = caseIdentifier(method);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case functionsPackage.GENERIC_METHOD: {
				GenericMethod genericMethod = (GenericMethod)theEObject;
				T result = caseGenericMethod(genericMethod);
				if (result == null) result = caseMethod(genericMethod);
				if (result == null) result = caseGenericEntity(genericMethod);
				if (result == null) result = caseFunction(genericMethod);
				if (result == null) result = caseMember(genericMethod);
				if (result == null) result = caseNamedModelElement(genericMethod);
				if (result == null) result = caseSourceEntity(genericMethod);
				if (result == null) result = caseModelElement(genericMethod);
				if (result == null) result = caseIdentifier(genericMethod);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case functionsPackage.GENERIC_CONSTRUCTOR: {
				GenericConstructor genericConstructor = (GenericConstructor)theEObject;
				T result = caseGenericConstructor(genericConstructor);
				if (result == null) result = caseConstructor(genericConstructor);
				if (result == null) result = caseGenericEntity(genericConstructor);
				if (result == null) result = caseFunction(genericConstructor);
				if (result == null) result = caseMember(genericConstructor);
				if (result == null) result = caseNamedModelElement(genericConstructor);
				if (result == null) result = caseSourceEntity(genericConstructor);
				if (result == null) result = caseModelElement(genericConstructor);
				if (result == null) result = caseIdentifier(genericConstructor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case functionsPackage.FUNCTION: {
				Function function = (Function)theEObject;
				T result = caseFunction(function);
				if (result == null) result = caseNamedModelElement(function);
				if (result == null) result = caseSourceEntity(function);
				if (result == null) result = caseModelElement(function);
				if (result == null) result = caseIdentifier(function);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constructor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constructor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstructor(Constructor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunction(Function object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Method</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Method</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMethod(Method object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Destructor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Destructor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDestructor(Destructor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Generic Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Generic Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGenericFunction(GenericFunction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Global Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Global Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGlobalFunction(GlobalFunction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Generic Method</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Generic Method</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGenericMethod(GenericMethod object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Generic Constructor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Generic Constructor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGenericConstructor(GenericConstructor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Delegate</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Delegate</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDelegate(Delegate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelElement(ModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Model Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Model Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedModelElement(NamedModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Source Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Source Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSourceEntity(SourceEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Member</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Member</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMember(Member object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Generic Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Generic Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGenericEntity(GenericEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTType(GASTType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //functionsSwitch
