/**
 * <copyright>
 * </copyright>
 *
 * $Id: FunctionImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.functions.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.DeclarationTypeAccess;
import de.fzi.gast.accesses.ThrowTypeAccess;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.core.Position;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.core.impl.NamedModelElementImpl;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.helpers.DerivationHelper;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsPackage;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.typesPackage;
import de.fzi.gast.variables.CatchParameter;
import de.fzi.gast.variables.FormalParameter;
import de.fzi.gast.variables.LocalVariable;
import de.fzi.gast.variables.variablesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Function</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getPosition <em>Position</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getReturnTypeDeclaration <em>Return Type Declaration</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getFormalParameters <em>Formal Parameters</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getLocalVariables <em>Local Variables</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getAllStatements <em>All Statements</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getThrowTypeAccesses <em>Throw Type Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getAccesses <em>Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getNumberOfStatements <em>Number Of Statements</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getMaximumNestingLevel <em>Maximum Nesting Level</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getLinesOfComments <em>Lines Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getNumberOfEdgesInCFG <em>Number Of Edges In CFG</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getNumberOfNodesInCFG <em>Number Of Nodes In CFG</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#isOperator <em>Operator</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getBody <em>Body</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.FunctionImpl#getLocalClasses <em>Local Classes</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class FunctionImpl extends NamedModelElementImpl implements Function {
	/**
	 * The cached value of the '{@link #getPosition() <em>Position</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPosition()
	 * @generated
	 * @ordered
	 */
	protected Position position;

	/**
	 * The cached value of the '{@link #getReturnTypeDeclaration() <em>Return Type Declaration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReturnTypeDeclaration()
	 * @generated
	 * @ordered
	 */
	protected DeclarationTypeAccess returnTypeDeclaration;

	/**
	 * The cached value of the '{@link #getFormalParameters() <em>Formal Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormalParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<FormalParameter> formalParameters;

	/**
	 * The cached value of the '{@link #getLocalVariables() <em>Local Variables</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<LocalVariable> localVariables;

	/**
	 * The cached value of the '{@link #getThrowTypeAccesses() <em>Throw Type Accesses</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThrowTypeAccesses()
	 * @generated
	 * @ordered
	 */
	protected EList<ThrowTypeAccess> throwTypeAccesses;

	/**
	 * The default value of the '{@link #getNumberOfStatements() <em>Number Of Statements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfStatements()
	 * @generated
	 * @ordered
	 */
	protected static final int NUMBER_OF_STATEMENTS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getNumberOfStatements() <em>Number Of Statements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfStatements()
	 * @generated
	 * @ordered
	 */
	protected int numberOfStatements = NUMBER_OF_STATEMENTS_EDEFAULT;

	/**
	 * The default value of the '{@link #getMaximumNestingLevel() <em>Maximum Nesting Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaximumNestingLevel()
	 * @generated
	 * @ordered
	 */
	protected static final int MAXIMUM_NESTING_LEVEL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaximumNestingLevel() <em>Maximum Nesting Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaximumNestingLevel()
	 * @generated
	 * @ordered
	 */
	protected int maximumNestingLevel = MAXIMUM_NESTING_LEVEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinesOfComments() <em>Lines Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfComments()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_COMMENTS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinesOfComments() <em>Lines Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfComments()
	 * @generated
	 * @ordered
	 */
	protected int linesOfComments = LINES_OF_COMMENTS_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinesOfCode() <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfCode()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_CODE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinesOfCode() <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfCode()
	 * @generated
	 * @ordered
	 */
	protected int linesOfCode = LINES_OF_CODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getNumberOfEdgesInCFG() <em>Number Of Edges In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfEdgesInCFG()
	 * @generated
	 * @ordered
	 */
	protected static final int NUMBER_OF_EDGES_IN_CFG_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getNumberOfEdgesInCFG() <em>Number Of Edges In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfEdgesInCFG()
	 * @generated
	 * @ordered
	 */
	protected int numberOfEdgesInCFG = NUMBER_OF_EDGES_IN_CFG_EDEFAULT;

	/**
	 * The default value of the '{@link #getNumberOfNodesInCFG() <em>Number Of Nodes In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfNodesInCFG()
	 * @generated
	 * @ordered
	 */
	protected static final int NUMBER_OF_NODES_IN_CFG_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getNumberOfNodesInCFG() <em>Number Of Nodes In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfNodesInCFG()
	 * @generated
	 * @ordered
	 */
	protected int numberOfNodesInCFG = NUMBER_OF_NODES_IN_CFG_EDEFAULT;

	/**
	 * The default value of the '{@link #isOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOperator()
	 * @generated
	 * @ordered
	 */
	protected static final boolean OPERATOR_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOperator()
	 * @generated
	 * @ordered
	 */
	protected boolean operator = OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getBody() <em>Body</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBody()
	 * @generated
	 * @ordered
	 */
	protected BlockStatement body;

	/**
	 * The cached value of the '{@link #getLocalClasses() <em>Local Classes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalClasses()
	 * @generated
	 * @ordered
	 */
	protected EList<GASTClass> localClasses;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return functionsPackage.Literals.FUNCTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Position getPosition() {
		return position;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPosition(Position newPosition, NotificationChain msgs) {
		Position oldPosition = position;
		position = newPosition;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__POSITION, oldPosition, newPosition);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPosition(Position newPosition) {
		if (newPosition != position) {
			NotificationChain msgs = null;
			if (position != null)
				msgs = ((InternalEObject)position).eInverseRemove(this, corePackage.POSITION__SOURCEENTITY, Position.class, msgs);
			if (newPosition != null)
				msgs = ((InternalEObject)newPosition).eInverseAdd(this, corePackage.POSITION__SOURCEENTITY, Position.class, msgs);
			msgs = basicSetPosition(newPosition, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__POSITION, newPosition, newPosition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Statement> getAllStatements() {
		return DerivationHelper.getAllStatements(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ThrowTypeAccess> getThrowTypeAccesses() {
		if (throwTypeAccesses == null) {
			throwTypeAccesses = new EObjectResolvingEList<ThrowTypeAccess>(ThrowTypeAccess.class, this, functionsPackage.FUNCTION__THROW_TYPE_ACCESSES);
		}
		return throwTypeAccesses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<FormalParameter> getFormalParameters() {
		if (formalParameters == null) {
			formalParameters = new EObjectContainmentWithInverseEList<FormalParameter>(FormalParameter.class, this, functionsPackage.FUNCTION__FORMAL_PARAMETERS, variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION);
		}
		return formalParameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<LocalVariable> getLocalVariables() {
		if (localVariables == null) {
			localVariables = new EObjectContainmentWithInverseEList<LocalVariable>(LocalVariable.class, this, functionsPackage.FUNCTION__LOCAL_VARIABLES, variablesPackage.LOCAL_VARIABLE__SURROUNDING_FUNCTION);
		}
		return localVariables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeclarationTypeAccess getReturnTypeDeclaration() {
		return returnTypeDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetReturnTypeDeclaration(DeclarationTypeAccess newReturnTypeDeclaration, NotificationChain msgs) {
		DeclarationTypeAccess oldReturnTypeDeclaration = returnTypeDeclaration;
		returnTypeDeclaration = newReturnTypeDeclaration;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION, oldReturnTypeDeclaration, newReturnTypeDeclaration);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReturnTypeDeclaration(DeclarationTypeAccess newReturnTypeDeclaration) {
		if (newReturnTypeDeclaration != returnTypeDeclaration) {
			NotificationChain msgs = null;
			if (returnTypeDeclaration != null)
				msgs = ((InternalEObject)returnTypeDeclaration).eInverseRemove(this, accessesPackage.DECLARATION_TYPE_ACCESS__FUNCTION, DeclarationTypeAccess.class, msgs);
			if (newReturnTypeDeclaration != null)
				msgs = ((InternalEObject)newReturnTypeDeclaration).eInverseAdd(this, accessesPackage.DECLARATION_TYPE_ACCESS__FUNCTION, DeclarationTypeAccess.class, msgs);
			msgs = basicSetReturnTypeDeclaration(newReturnTypeDeclaration, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION, newReturnTypeDeclaration, newReturnTypeDeclaration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Access> getAccesses() {
		
		if (this.getBody() != null) {
		
		EList result = DerivationHelper.selectAccessesInSubtree(this.getBody());
		
		return result; 
		} else {
			return new BasicInternalEList(Access.class);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getNumberOfStatements() {
		return numberOfStatements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberOfStatements(int newNumberOfStatements) {
		int oldNumberOfStatements = numberOfStatements;
		numberOfStatements = newNumberOfStatements;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__NUMBER_OF_STATEMENTS, oldNumberOfStatements, numberOfStatements));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMaximumNestingLevel() {
		return maximumNestingLevel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaximumNestingLevel(int newMaximumNestingLevel) {
		int oldMaximumNestingLevel = maximumNestingLevel;
		maximumNestingLevel = newMaximumNestingLevel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__MAXIMUM_NESTING_LEVEL, oldMaximumNestingLevel, maximumNestingLevel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLinesOfComments() {
		return linesOfComments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLinesOfComments(int newLinesOfComments) {
		int oldLinesOfComments = linesOfComments;
		linesOfComments = newLinesOfComments;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__LINES_OF_COMMENTS, oldLinesOfComments, linesOfComments));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLinesOfCode() {
		return linesOfCode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLinesOfCode(int newLinesOfCode) {
		int oldLinesOfCode = linesOfCode;
		linesOfCode = newLinesOfCode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__LINES_OF_CODE, oldLinesOfCode, linesOfCode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getNumberOfEdgesInCFG() {
		return numberOfEdgesInCFG;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberOfEdgesInCFG(int newNumberOfEdgesInCFG) {
		int oldNumberOfEdgesInCFG = numberOfEdgesInCFG;
		numberOfEdgesInCFG = newNumberOfEdgesInCFG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__NUMBER_OF_EDGES_IN_CFG, oldNumberOfEdgesInCFG, numberOfEdgesInCFG));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getNumberOfNodesInCFG() {
		return numberOfNodesInCFG;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberOfNodesInCFG(int newNumberOfNodesInCFG) {
		int oldNumberOfNodesInCFG = numberOfNodesInCFG;
		numberOfNodesInCFG = newNumberOfNodesInCFG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__NUMBER_OF_NODES_IN_CFG, oldNumberOfNodesInCFG, numberOfNodesInCFG));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperator(boolean newOperator) {
		boolean oldOperator = operator;
		operator = newOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__OPERATOR, oldOperator, operator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BlockStatement getBody() {
		return body;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBody(BlockStatement newBody, NotificationChain msgs) {
		BlockStatement oldBody = body;
		body = newBody;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__BODY, oldBody, newBody);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBody(BlockStatement newBody) {
		if (newBody != body) {
			NotificationChain msgs = null;
			if (body != null)
				msgs = ((InternalEObject)body).eInverseRemove(this, statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION, BlockStatement.class, msgs);
			if (newBody != null)
				msgs = ((InternalEObject)newBody).eInverseAdd(this, statementsPackage.BLOCK_STATEMENT__SURROUNDING_FUNCTION, BlockStatement.class, msgs);
			msgs = basicSetBody(newBody, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.FUNCTION__BODY, newBody, newBody));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GASTClass> getLocalClasses() {
		if (localClasses == null) {
			localClasses = new EObjectContainmentWithInverseEList<GASTClass>(GASTClass.class, this, functionsPackage.FUNCTION__LOCAL_CLASSES, typesPackage.GAST_CLASS__SURROUNDING_FUNCTION);
		}
		return localClasses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case functionsPackage.FUNCTION__POSITION:
				if (position != null)
					msgs = ((InternalEObject)position).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - functionsPackage.FUNCTION__POSITION, null, msgs);
				return basicSetPosition((Position)otherEnd, msgs);
			case functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION:
				if (returnTypeDeclaration != null)
					msgs = ((InternalEObject)returnTypeDeclaration).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION, null, msgs);
				return basicSetReturnTypeDeclaration((DeclarationTypeAccess)otherEnd, msgs);
			case functionsPackage.FUNCTION__FORMAL_PARAMETERS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getFormalParameters()).basicAdd(otherEnd, msgs);
			case functionsPackage.FUNCTION__LOCAL_VARIABLES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getLocalVariables()).basicAdd(otherEnd, msgs);
			case functionsPackage.FUNCTION__BODY:
				if (body != null)
					msgs = ((InternalEObject)body).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - functionsPackage.FUNCTION__BODY, null, msgs);
				return basicSetBody((BlockStatement)otherEnd, msgs);
			case functionsPackage.FUNCTION__LOCAL_CLASSES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getLocalClasses()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case functionsPackage.FUNCTION__POSITION:
				return basicSetPosition(null, msgs);
			case functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION:
				return basicSetReturnTypeDeclaration(null, msgs);
			case functionsPackage.FUNCTION__FORMAL_PARAMETERS:
				return ((InternalEList<?>)getFormalParameters()).basicRemove(otherEnd, msgs);
			case functionsPackage.FUNCTION__LOCAL_VARIABLES:
				return ((InternalEList<?>)getLocalVariables()).basicRemove(otherEnd, msgs);
			case functionsPackage.FUNCTION__BODY:
				return basicSetBody(null, msgs);
			case functionsPackage.FUNCTION__LOCAL_CLASSES:
				return ((InternalEList<?>)getLocalClasses()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case functionsPackage.FUNCTION__POSITION:
				return getPosition();
			case functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION:
				return getReturnTypeDeclaration();
			case functionsPackage.FUNCTION__FORMAL_PARAMETERS:
				return getFormalParameters();
			case functionsPackage.FUNCTION__LOCAL_VARIABLES:
				return getLocalVariables();
			case functionsPackage.FUNCTION__ALL_STATEMENTS:
				return getAllStatements();
			case functionsPackage.FUNCTION__THROW_TYPE_ACCESSES:
				return getThrowTypeAccesses();
			case functionsPackage.FUNCTION__ACCESSES:
				return getAccesses();
			case functionsPackage.FUNCTION__NUMBER_OF_STATEMENTS:
				return getNumberOfStatements();
			case functionsPackage.FUNCTION__MAXIMUM_NESTING_LEVEL:
				return getMaximumNestingLevel();
			case functionsPackage.FUNCTION__LINES_OF_COMMENTS:
				return getLinesOfComments();
			case functionsPackage.FUNCTION__LINES_OF_CODE:
				return getLinesOfCode();
			case functionsPackage.FUNCTION__NUMBER_OF_EDGES_IN_CFG:
				return getNumberOfEdgesInCFG();
			case functionsPackage.FUNCTION__NUMBER_OF_NODES_IN_CFG:
				return getNumberOfNodesInCFG();
			case functionsPackage.FUNCTION__OPERATOR:
				return isOperator();
			case functionsPackage.FUNCTION__BODY:
				return getBody();
			case functionsPackage.FUNCTION__LOCAL_CLASSES:
				return getLocalClasses();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case functionsPackage.FUNCTION__POSITION:
				setPosition((Position)newValue);
				return;
			case functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION:
				setReturnTypeDeclaration((DeclarationTypeAccess)newValue);
				return;
			case functionsPackage.FUNCTION__FORMAL_PARAMETERS:
				getFormalParameters().clear();
				getFormalParameters().addAll((Collection<? extends FormalParameter>)newValue);
				return;
			case functionsPackage.FUNCTION__LOCAL_VARIABLES:
				getLocalVariables().clear();
				getLocalVariables().addAll((Collection<? extends LocalVariable>)newValue);
				return;
			case functionsPackage.FUNCTION__THROW_TYPE_ACCESSES:
				getThrowTypeAccesses().clear();
				getThrowTypeAccesses().addAll((Collection<? extends ThrowTypeAccess>)newValue);
				return;
			case functionsPackage.FUNCTION__NUMBER_OF_STATEMENTS:
				setNumberOfStatements((Integer)newValue);
				return;
			case functionsPackage.FUNCTION__MAXIMUM_NESTING_LEVEL:
				setMaximumNestingLevel((Integer)newValue);
				return;
			case functionsPackage.FUNCTION__LINES_OF_COMMENTS:
				setLinesOfComments((Integer)newValue);
				return;
			case functionsPackage.FUNCTION__LINES_OF_CODE:
				setLinesOfCode((Integer)newValue);
				return;
			case functionsPackage.FUNCTION__NUMBER_OF_EDGES_IN_CFG:
				setNumberOfEdgesInCFG((Integer)newValue);
				return;
			case functionsPackage.FUNCTION__NUMBER_OF_NODES_IN_CFG:
				setNumberOfNodesInCFG((Integer)newValue);
				return;
			case functionsPackage.FUNCTION__OPERATOR:
				setOperator((Boolean)newValue);
				return;
			case functionsPackage.FUNCTION__BODY:
				setBody((BlockStatement)newValue);
				return;
			case functionsPackage.FUNCTION__LOCAL_CLASSES:
				getLocalClasses().clear();
				getLocalClasses().addAll((Collection<? extends GASTClass>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case functionsPackage.FUNCTION__POSITION:
				setPosition((Position)null);
				return;
			case functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION:
				setReturnTypeDeclaration((DeclarationTypeAccess)null);
				return;
			case functionsPackage.FUNCTION__FORMAL_PARAMETERS:
				getFormalParameters().clear();
				return;
			case functionsPackage.FUNCTION__LOCAL_VARIABLES:
				getLocalVariables().clear();
				return;
			case functionsPackage.FUNCTION__THROW_TYPE_ACCESSES:
				getThrowTypeAccesses().clear();
				return;
			case functionsPackage.FUNCTION__NUMBER_OF_STATEMENTS:
				setNumberOfStatements(NUMBER_OF_STATEMENTS_EDEFAULT);
				return;
			case functionsPackage.FUNCTION__MAXIMUM_NESTING_LEVEL:
				setMaximumNestingLevel(MAXIMUM_NESTING_LEVEL_EDEFAULT);
				return;
			case functionsPackage.FUNCTION__LINES_OF_COMMENTS:
				setLinesOfComments(LINES_OF_COMMENTS_EDEFAULT);
				return;
			case functionsPackage.FUNCTION__LINES_OF_CODE:
				setLinesOfCode(LINES_OF_CODE_EDEFAULT);
				return;
			case functionsPackage.FUNCTION__NUMBER_OF_EDGES_IN_CFG:
				setNumberOfEdgesInCFG(NUMBER_OF_EDGES_IN_CFG_EDEFAULT);
				return;
			case functionsPackage.FUNCTION__NUMBER_OF_NODES_IN_CFG:
				setNumberOfNodesInCFG(NUMBER_OF_NODES_IN_CFG_EDEFAULT);
				return;
			case functionsPackage.FUNCTION__OPERATOR:
				setOperator(OPERATOR_EDEFAULT);
				return;
			case functionsPackage.FUNCTION__BODY:
				setBody((BlockStatement)null);
				return;
			case functionsPackage.FUNCTION__LOCAL_CLASSES:
				getLocalClasses().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case functionsPackage.FUNCTION__POSITION:
				return position != null;
			case functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION:
				return returnTypeDeclaration != null;
			case functionsPackage.FUNCTION__FORMAL_PARAMETERS:
				return formalParameters != null && !formalParameters.isEmpty();
			case functionsPackage.FUNCTION__LOCAL_VARIABLES:
				return localVariables != null && !localVariables.isEmpty();
			case functionsPackage.FUNCTION__ALL_STATEMENTS:
				return !getAllStatements().isEmpty();
			case functionsPackage.FUNCTION__THROW_TYPE_ACCESSES:
				return throwTypeAccesses != null && !throwTypeAccesses.isEmpty();
			case functionsPackage.FUNCTION__ACCESSES:
				return !getAccesses().isEmpty();
			case functionsPackage.FUNCTION__NUMBER_OF_STATEMENTS:
				return numberOfStatements != NUMBER_OF_STATEMENTS_EDEFAULT;
			case functionsPackage.FUNCTION__MAXIMUM_NESTING_LEVEL:
				return maximumNestingLevel != MAXIMUM_NESTING_LEVEL_EDEFAULT;
			case functionsPackage.FUNCTION__LINES_OF_COMMENTS:
				return linesOfComments != LINES_OF_COMMENTS_EDEFAULT;
			case functionsPackage.FUNCTION__LINES_OF_CODE:
				return linesOfCode != LINES_OF_CODE_EDEFAULT;
			case functionsPackage.FUNCTION__NUMBER_OF_EDGES_IN_CFG:
				return numberOfEdgesInCFG != NUMBER_OF_EDGES_IN_CFG_EDEFAULT;
			case functionsPackage.FUNCTION__NUMBER_OF_NODES_IN_CFG:
				return numberOfNodesInCFG != NUMBER_OF_NODES_IN_CFG_EDEFAULT;
			case functionsPackage.FUNCTION__OPERATOR:
				return operator != OPERATOR_EDEFAULT;
			case functionsPackage.FUNCTION__BODY:
				return body != null;
			case functionsPackage.FUNCTION__LOCAL_CLASSES:
				return localClasses != null && !localClasses.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == SourceEntity.class) {
			switch (derivedFeatureID) {
				case functionsPackage.FUNCTION__POSITION: return corePackage.SOURCE_ENTITY__POSITION;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == SourceEntity.class) {
			switch (baseFeatureID) {
				case corePackage.SOURCE_ENTITY__POSITION: return functionsPackage.FUNCTION__POSITION;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (numberOfStatements: ");
		result.append(numberOfStatements);
		result.append(", maximumNestingLevel: ");
		result.append(maximumNestingLevel);
		result.append(", linesOfComments: ");
		result.append(linesOfComments);
		result.append(", linesOfCode: ");
		result.append(linesOfCode);
		result.append(", numberOfEdgesInCFG: ");
		result.append(numberOfEdgesInCFG);
		result.append(", numberOfNodesInCFG: ");
		result.append(numberOfNodesInCFG);
		result.append(", operator: ");
		result.append(operator);
		result.append(')');
		return result.toString();
	}

} //FunctionImpl
