/**
 * <copyright>
 * </copyright>
 *
 * $Id: DelegateImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.functions.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.core.corePackage;
import de.fzi.gast.functions.Delegate;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.Member;
import de.fzi.gast.types.TypeParameterClass;
import de.fzi.gast.types.Visibilities;
import de.fzi.gast.types.typesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Delegate</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#getVisibility <em>Visibility</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#getOverriddenMember <em>Overridden Member</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isAbstract <em>Abstract</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isExtern <em>Extern</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isFinal <em>Final</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isInternal <em>Internal</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isIntrospectable <em>Introspectable</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isOverride <em>Override</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isStatic <em>Static</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isTypeParameterClassMember <em>Type Parameter Class Member</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isVirtual <em>Virtual</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#getQualifiedName <em>Qualified Name</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isReferenceType <em>Reference Type</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#isInnerDelegate <em>Inner Delegate</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#getSuperClass <em>Super Class</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#getInvocations <em>Invocations</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#getSurroundingClass <em>Surrounding Class</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.DelegateImpl#getSurroundingPackage <em>Surrounding Package</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DelegateImpl extends FunctionImpl implements Delegate {
	/**
	 * The default value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected static final Visibilities VISIBILITY_EDEFAULT = Visibilities.VISIBILITYSTRICTPROTECTED;

	/**
	 * The cached value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected Visibilities visibility = VISIBILITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOverriddenMember() <em>Overridden Member</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverriddenMember()
	 * @generated
	 * @ordered
	 */
	protected Member overriddenMember;

	/**
	 * The default value of the '{@link #isAbstract() <em>Abstract</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAbstract()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ABSTRACT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAbstract() <em>Abstract</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAbstract()
	 * @generated
	 * @ordered
	 */
	protected boolean abstract_ = ABSTRACT_EDEFAULT;

	/**
	 * The default value of the '{@link #isExtern() <em>Extern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExtern()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EXTERN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isExtern() <em>Extern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExtern()
	 * @generated
	 * @ordered
	 */
	protected boolean extern = EXTERN_EDEFAULT;

	/**
	 * The default value of the '{@link #isFinal() <em>Final</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFinal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FINAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFinal() <em>Final</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFinal()
	 * @generated
	 * @ordered
	 */
	protected boolean final_ = FINAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isInternal() <em>Internal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInternal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INTERNAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInternal() <em>Internal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInternal()
	 * @generated
	 * @ordered
	 */
	protected boolean internal = INTERNAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isIntrospectable() <em>Introspectable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIntrospectable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INTROSPECTABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIntrospectable() <em>Introspectable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIntrospectable()
	 * @generated
	 * @ordered
	 */
	protected boolean introspectable = INTROSPECTABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isOverride() <em>Override</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOverride()
	 * @generated
	 * @ordered
	 */
	protected static final boolean OVERRIDE_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isStatic() <em>Static</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isStatic()
	 * @generated
	 * @ordered
	 */
	protected static final boolean STATIC_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isStatic() <em>Static</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isStatic()
	 * @generated
	 * @ordered
	 */
	protected boolean static_ = STATIC_EDEFAULT;

	/**
	 * The default value of the '{@link #isTypeParameterClassMember() <em>Type Parameter Class Member</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isTypeParameterClassMember()
	 * @generated
	 * @ordered
	 */
	protected static final boolean TYPE_PARAMETER_CLASS_MEMBER_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isVirtual() <em>Virtual</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVirtual()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VIRTUAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isVirtual() <em>Virtual</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVirtual()
	 * @generated
	 * @ordered
	 */
	protected boolean virtual = VIRTUAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getQualifiedName() <em>Qualified Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQualifiedName()
	 * @generated
	 * @ordered
	 */
	protected static final String QUALIFIED_NAME_EDEFAULT = null;

	/**
	 * The default value of the '{@link #isReferenceType() <em>Reference Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReferenceType()
	 * @generated
	 * @ordered
	 */
	protected static final boolean REFERENCE_TYPE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isReferenceType() <em>Reference Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReferenceType()
	 * @generated
	 * @ordered
	 */
	protected boolean referenceType = REFERENCE_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #isInnerDelegate() <em>Inner Delegate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInnerDelegate()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INNER_DELEGATE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInnerDelegate() <em>Inner Delegate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInnerDelegate()
	 * @generated
	 * @ordered
	 */
	protected boolean innerDelegate = INNER_DELEGATE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSuperClass() <em>Super Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSuperClass()
	 * @generated
	 * @ordered
	 */
	protected GASTClass superClass;

	/**
	 * The cached value of the '{@link #getInvocations() <em>Invocations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvocations()
	 * @generated
	 * @ordered
	 */
	protected EList<Function> invocations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DelegateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return functionsPackage.Literals.DELEGATE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Visibilities getVisibility() {
		return visibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVisibility(Visibilities newVisibility) {
		Visibilities oldVisibility = visibility;
		visibility = newVisibility == null ? VISIBILITY_EDEFAULT : newVisibility;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__VISIBILITY, oldVisibility, visibility));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Member getOverriddenMember() {
		if (overriddenMember != null && overriddenMember.eIsProxy()) {
			InternalEObject oldOverriddenMember = (InternalEObject)overriddenMember;
			overriddenMember = (Member)eResolveProxy(oldOverriddenMember);
			if (overriddenMember != oldOverriddenMember) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, functionsPackage.DELEGATE__OVERRIDDEN_MEMBER, oldOverriddenMember, overriddenMember));
			}
		}
		return overriddenMember;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Member basicGetOverriddenMember() {
		return overriddenMember;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOverriddenMember(Member newOverriddenMember) {
		Member oldOverriddenMember = overriddenMember;
		overriddenMember = newOverriddenMember;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__OVERRIDDEN_MEMBER, oldOverriddenMember, overriddenMember));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAbstract() {
		return abstract_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAbstract(boolean newAbstract) {
		boolean oldAbstract = abstract_;
		abstract_ = newAbstract;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__ABSTRACT, oldAbstract, abstract_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isExtern() {
		return extern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExtern(boolean newExtern) {
		boolean oldExtern = extern;
		extern = newExtern;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__EXTERN, oldExtern, extern));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFinal() {
		return final_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFinal(boolean newFinal) {
		boolean oldFinal = final_;
		final_ = newFinal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__FINAL, oldFinal, final_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInternal() {
		return internal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInternal(boolean newInternal) {
		boolean oldInternal = internal;
		internal = newInternal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__INTERNAL, oldInternal, internal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIntrospectable() {
		return introspectable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIntrospectable(boolean newIntrospectable) {
		boolean oldIntrospectable = introspectable;
		introspectable = newIntrospectable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__INTROSPECTABLE, oldIntrospectable, introspectable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isOverride() {
		return getOverriddenMember() != null;	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetOverride() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isStatic() {
		return static_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatic(boolean newStatic) {
		boolean oldStatic = static_;
		static_ = newStatic;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__STATIC, oldStatic, static_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isTypeParameterClassMember() {
		if (getSurroundingClass() == null)
			return false;
		
		return (getSurroundingClass() instanceof TypeParameterClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetTypeParameterClassMember() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isVirtual() {
		return virtual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVirtual(boolean newVirtual) {
		boolean oldVirtual = virtual;
		virtual = newVirtual;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__VIRTUAL, oldVirtual, virtual));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getQualifiedName() {
		String prefix = "";
		GASTClass cls = getSurroundingClass();
		if (cls != null)
			prefix = cls.getQualifiedName() + "$";
		else
			if (getSurroundingPackage() != null)
				prefix = getSurroundingPackage().getQualifiedName() + ".";
		return prefix + getSimpleName();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetQualifiedName() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isReferenceType() {
		return referenceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReferenceType(boolean newReferenceType) {
		boolean oldReferenceType = referenceType;
		referenceType = newReferenceType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__REFERENCE_TYPE, oldReferenceType, referenceType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInnerDelegate() {
		return innerDelegate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInnerDelegate(boolean newInnerDelegate) {
		boolean oldInnerDelegate = innerDelegate;
		innerDelegate = newInnerDelegate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__INNER_DELEGATE, oldInnerDelegate, innerDelegate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass getSuperClass() {
		if (superClass != null && superClass.eIsProxy()) {
			InternalEObject oldSuperClass = (InternalEObject)superClass;
			superClass = (GASTClass)eResolveProxy(oldSuperClass);
			if (superClass != oldSuperClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, functionsPackage.DELEGATE__SUPER_CLASS, oldSuperClass, superClass));
			}
		}
		return superClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass basicGetSuperClass() {
		return superClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSuperClass(GASTClass newSuperClass) {
		GASTClass oldSuperClass = superClass;
		superClass = newSuperClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__SUPER_CLASS, oldSuperClass, superClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Function> getInvocations() {
		if (invocations == null) {
			invocations = new EObjectResolvingEList<Function>(Function.class, this, functionsPackage.DELEGATE__INVOCATIONS);
		}
		return invocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass getSurroundingClass() {
		if (eContainerFeatureID() != functionsPackage.DELEGATE__SURROUNDING_CLASS) return null;
		return (GASTClass)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingClass(GASTClass newSurroundingClass, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingClass, functionsPackage.DELEGATE__SURROUNDING_CLASS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingClass(GASTClass newSurroundingClass) {
		if (newSurroundingClass != eInternalContainer() || (eContainerFeatureID() != functionsPackage.DELEGATE__SURROUNDING_CLASS && newSurroundingClass != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingClass))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingClass != null)
				msgs = ((InternalEObject)newSurroundingClass).eInverseAdd(this, typesPackage.GAST_CLASS__INNER_DELEGATES, GASTClass.class, msgs);
			msgs = basicSetSurroundingClass(newSurroundingClass, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__SURROUNDING_CLASS, newSurroundingClass, newSurroundingClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public de.fzi.gast.core.Package getSurroundingPackage() {
		if (eContainerFeatureID() != functionsPackage.DELEGATE__SURROUNDING_PACKAGE) return null;
		return (de.fzi.gast.core.Package)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingPackage(de.fzi.gast.core.Package newSurroundingPackage, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingPackage, functionsPackage.DELEGATE__SURROUNDING_PACKAGE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingPackage(de.fzi.gast.core.Package newSurroundingPackage) {
		if (newSurroundingPackage != eInternalContainer() || (eContainerFeatureID() != functionsPackage.DELEGATE__SURROUNDING_PACKAGE && newSurroundingPackage != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingPackage))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingPackage != null)
				msgs = ((InternalEObject)newSurroundingPackage).eInverseAdd(this, corePackage.PACKAGE__DELEGATES, de.fzi.gast.core.Package.class, msgs);
			msgs = basicSetSurroundingPackage(newSurroundingPackage, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.DELEGATE__SURROUNDING_PACKAGE, newSurroundingPackage, newSurroundingPackage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case functionsPackage.DELEGATE__SURROUNDING_CLASS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingClass((GASTClass)otherEnd, msgs);
			case functionsPackage.DELEGATE__SURROUNDING_PACKAGE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingPackage((de.fzi.gast.core.Package)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case functionsPackage.DELEGATE__SURROUNDING_CLASS:
				return basicSetSurroundingClass(null, msgs);
			case functionsPackage.DELEGATE__SURROUNDING_PACKAGE:
				return basicSetSurroundingPackage(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case functionsPackage.DELEGATE__SURROUNDING_CLASS:
				return eInternalContainer().eInverseRemove(this, typesPackage.GAST_CLASS__INNER_DELEGATES, GASTClass.class, msgs);
			case functionsPackage.DELEGATE__SURROUNDING_PACKAGE:
				return eInternalContainer().eInverseRemove(this, corePackage.PACKAGE__DELEGATES, de.fzi.gast.core.Package.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case functionsPackage.DELEGATE__VISIBILITY:
				return getVisibility();
			case functionsPackage.DELEGATE__OVERRIDDEN_MEMBER:
				if (resolve) return getOverriddenMember();
				return basicGetOverriddenMember();
			case functionsPackage.DELEGATE__ABSTRACT:
				return isAbstract();
			case functionsPackage.DELEGATE__EXTERN:
				return isExtern();
			case functionsPackage.DELEGATE__FINAL:
				return isFinal();
			case functionsPackage.DELEGATE__INTERNAL:
				return isInternal();
			case functionsPackage.DELEGATE__INTROSPECTABLE:
				return isIntrospectable();
			case functionsPackage.DELEGATE__OVERRIDE:
				return isOverride();
			case functionsPackage.DELEGATE__STATIC:
				return isStatic();
			case functionsPackage.DELEGATE__TYPE_PARAMETER_CLASS_MEMBER:
				return isTypeParameterClassMember();
			case functionsPackage.DELEGATE__VIRTUAL:
				return isVirtual();
			case functionsPackage.DELEGATE__QUALIFIED_NAME:
				return getQualifiedName();
			case functionsPackage.DELEGATE__REFERENCE_TYPE:
				return isReferenceType();
			case functionsPackage.DELEGATE__INNER_DELEGATE:
				return isInnerDelegate();
			case functionsPackage.DELEGATE__SUPER_CLASS:
				if (resolve) return getSuperClass();
				return basicGetSuperClass();
			case functionsPackage.DELEGATE__INVOCATIONS:
				return getInvocations();
			case functionsPackage.DELEGATE__SURROUNDING_CLASS:
				return getSurroundingClass();
			case functionsPackage.DELEGATE__SURROUNDING_PACKAGE:
				return getSurroundingPackage();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case functionsPackage.DELEGATE__VISIBILITY:
				setVisibility((Visibilities)newValue);
				return;
			case functionsPackage.DELEGATE__OVERRIDDEN_MEMBER:
				setOverriddenMember((Member)newValue);
				return;
			case functionsPackage.DELEGATE__ABSTRACT:
				setAbstract((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__EXTERN:
				setExtern((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__FINAL:
				setFinal((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__INTERNAL:
				setInternal((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__INTROSPECTABLE:
				setIntrospectable((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__STATIC:
				setStatic((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__VIRTUAL:
				setVirtual((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__REFERENCE_TYPE:
				setReferenceType((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__INNER_DELEGATE:
				setInnerDelegate((Boolean)newValue);
				return;
			case functionsPackage.DELEGATE__SUPER_CLASS:
				setSuperClass((GASTClass)newValue);
				return;
			case functionsPackage.DELEGATE__INVOCATIONS:
				getInvocations().clear();
				getInvocations().addAll((Collection<? extends Function>)newValue);
				return;
			case functionsPackage.DELEGATE__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)newValue);
				return;
			case functionsPackage.DELEGATE__SURROUNDING_PACKAGE:
				setSurroundingPackage((de.fzi.gast.core.Package)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case functionsPackage.DELEGATE__VISIBILITY:
				setVisibility(VISIBILITY_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__OVERRIDDEN_MEMBER:
				setOverriddenMember((Member)null);
				return;
			case functionsPackage.DELEGATE__ABSTRACT:
				setAbstract(ABSTRACT_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__EXTERN:
				setExtern(EXTERN_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__FINAL:
				setFinal(FINAL_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__INTERNAL:
				setInternal(INTERNAL_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__INTROSPECTABLE:
				setIntrospectable(INTROSPECTABLE_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__STATIC:
				setStatic(STATIC_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__VIRTUAL:
				setVirtual(VIRTUAL_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__REFERENCE_TYPE:
				setReferenceType(REFERENCE_TYPE_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__INNER_DELEGATE:
				setInnerDelegate(INNER_DELEGATE_EDEFAULT);
				return;
			case functionsPackage.DELEGATE__SUPER_CLASS:
				setSuperClass((GASTClass)null);
				return;
			case functionsPackage.DELEGATE__INVOCATIONS:
				getInvocations().clear();
				return;
			case functionsPackage.DELEGATE__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)null);
				return;
			case functionsPackage.DELEGATE__SURROUNDING_PACKAGE:
				setSurroundingPackage((de.fzi.gast.core.Package)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case functionsPackage.DELEGATE__VISIBILITY:
				return visibility != VISIBILITY_EDEFAULT;
			case functionsPackage.DELEGATE__OVERRIDDEN_MEMBER:
				return overriddenMember != null;
			case functionsPackage.DELEGATE__ABSTRACT:
				return abstract_ != ABSTRACT_EDEFAULT;
			case functionsPackage.DELEGATE__EXTERN:
				return extern != EXTERN_EDEFAULT;
			case functionsPackage.DELEGATE__FINAL:
				return final_ != FINAL_EDEFAULT;
			case functionsPackage.DELEGATE__INTERNAL:
				return internal != INTERNAL_EDEFAULT;
			case functionsPackage.DELEGATE__INTROSPECTABLE:
				return introspectable != INTROSPECTABLE_EDEFAULT;
			case functionsPackage.DELEGATE__OVERRIDE:
				return isOverride() != OVERRIDE_EDEFAULT;
			case functionsPackage.DELEGATE__STATIC:
				return static_ != STATIC_EDEFAULT;
			case functionsPackage.DELEGATE__TYPE_PARAMETER_CLASS_MEMBER:
				return isTypeParameterClassMember() != TYPE_PARAMETER_CLASS_MEMBER_EDEFAULT;
			case functionsPackage.DELEGATE__VIRTUAL:
				return virtual != VIRTUAL_EDEFAULT;
			case functionsPackage.DELEGATE__QUALIFIED_NAME:
				return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
			case functionsPackage.DELEGATE__REFERENCE_TYPE:
				return referenceType != REFERENCE_TYPE_EDEFAULT;
			case functionsPackage.DELEGATE__INNER_DELEGATE:
				return innerDelegate != INNER_DELEGATE_EDEFAULT;
			case functionsPackage.DELEGATE__SUPER_CLASS:
				return superClass != null;
			case functionsPackage.DELEGATE__INVOCATIONS:
				return invocations != null && !invocations.isEmpty();
			case functionsPackage.DELEGATE__SURROUNDING_CLASS:
				return getSurroundingClass() != null;
			case functionsPackage.DELEGATE__SURROUNDING_PACKAGE:
				return getSurroundingPackage() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Member.class) {
			switch (derivedFeatureID) {
				case functionsPackage.DELEGATE__VISIBILITY: return typesPackage.MEMBER__VISIBILITY;
				case functionsPackage.DELEGATE__OVERRIDDEN_MEMBER: return typesPackage.MEMBER__OVERRIDDEN_MEMBER;
				case functionsPackage.DELEGATE__ABSTRACT: return typesPackage.MEMBER__ABSTRACT;
				case functionsPackage.DELEGATE__EXTERN: return typesPackage.MEMBER__EXTERN;
				case functionsPackage.DELEGATE__FINAL: return typesPackage.MEMBER__FINAL;
				case functionsPackage.DELEGATE__INTERNAL: return typesPackage.MEMBER__INTERNAL;
				case functionsPackage.DELEGATE__INTROSPECTABLE: return typesPackage.MEMBER__INTROSPECTABLE;
				case functionsPackage.DELEGATE__OVERRIDE: return typesPackage.MEMBER__OVERRIDE;
				case functionsPackage.DELEGATE__STATIC: return typesPackage.MEMBER__STATIC;
				case functionsPackage.DELEGATE__TYPE_PARAMETER_CLASS_MEMBER: return typesPackage.MEMBER__TYPE_PARAMETER_CLASS_MEMBER;
				case functionsPackage.DELEGATE__VIRTUAL: return typesPackage.MEMBER__VIRTUAL;
				default: return -1;
			}
		}
		if (baseClass == GASTType.class) {
			switch (derivedFeatureID) {
				case functionsPackage.DELEGATE__QUALIFIED_NAME: return typesPackage.GAST_TYPE__QUALIFIED_NAME;
				case functionsPackage.DELEGATE__REFERENCE_TYPE: return typesPackage.GAST_TYPE__REFERENCE_TYPE;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Member.class) {
			switch (baseFeatureID) {
				case typesPackage.MEMBER__VISIBILITY: return functionsPackage.DELEGATE__VISIBILITY;
				case typesPackage.MEMBER__OVERRIDDEN_MEMBER: return functionsPackage.DELEGATE__OVERRIDDEN_MEMBER;
				case typesPackage.MEMBER__ABSTRACT: return functionsPackage.DELEGATE__ABSTRACT;
				case typesPackage.MEMBER__EXTERN: return functionsPackage.DELEGATE__EXTERN;
				case typesPackage.MEMBER__FINAL: return functionsPackage.DELEGATE__FINAL;
				case typesPackage.MEMBER__INTERNAL: return functionsPackage.DELEGATE__INTERNAL;
				case typesPackage.MEMBER__INTROSPECTABLE: return functionsPackage.DELEGATE__INTROSPECTABLE;
				case typesPackage.MEMBER__OVERRIDE: return functionsPackage.DELEGATE__OVERRIDE;
				case typesPackage.MEMBER__STATIC: return functionsPackage.DELEGATE__STATIC;
				case typesPackage.MEMBER__TYPE_PARAMETER_CLASS_MEMBER: return functionsPackage.DELEGATE__TYPE_PARAMETER_CLASS_MEMBER;
				case typesPackage.MEMBER__VIRTUAL: return functionsPackage.DELEGATE__VIRTUAL;
				default: return -1;
			}
		}
		if (baseClass == GASTType.class) {
			switch (baseFeatureID) {
				case typesPackage.GAST_TYPE__QUALIFIED_NAME: return functionsPackage.DELEGATE__QUALIFIED_NAME;
				case typesPackage.GAST_TYPE__REFERENCE_TYPE: return functionsPackage.DELEGATE__REFERENCE_TYPE;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (visibility: ");
		result.append(visibility);
		result.append(", abstract: ");
		result.append(abstract_);
		result.append(", extern: ");
		result.append(extern);
		result.append(", final: ");
		result.append(final_);
		result.append(", internal: ");
		result.append(internal);
		result.append(", introspectable: ");
		result.append(introspectable);
		result.append(", static: ");
		result.append(static_);
		result.append(", virtual: ");
		result.append(virtual);
		result.append(", referenceType: ");
		result.append(referenceType);
		result.append(", innerDelegate: ");
		result.append(innerDelegate);
		result.append(')');
		return result.toString();
	}

} //DelegateImpl
