/**
 * <copyright>
 * </copyright>
 *
 * $Id: ConstructorImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.functions.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.functions.Constructor;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Member;
import de.fzi.gast.types.TypeParameterClass;
import de.fzi.gast.types.Visibilities;
import de.fzi.gast.types.typesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Constructor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#getVisibility <em>Visibility</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#getOverriddenMember <em>Overridden Member</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isAbstract <em>Abstract</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isExtern <em>Extern</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isFinal <em>Final</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isInternal <em>Internal</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isIntrospectable <em>Introspectable</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isOverride <em>Override</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isStatic <em>Static</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isTypeParameterClassMember <em>Type Parameter Class Member</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isVirtual <em>Virtual</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#isInitializer <em>Initializer</em>}</li>
 *   <li>{@link de.fzi.gast.functions.impl.ConstructorImpl#getSurroundingClass <em>Surrounding Class</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConstructorImpl extends FunctionImpl implements Constructor {
	/**
	 * The default value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected static final Visibilities VISIBILITY_EDEFAULT = Visibilities.VISIBILITYSTRICTPROTECTED;

	/**
	 * The cached value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected Visibilities visibility = VISIBILITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOverriddenMember() <em>Overridden Member</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverriddenMember()
	 * @generated
	 * @ordered
	 */
	protected Member overriddenMember;

	/**
	 * The default value of the '{@link #isAbstract() <em>Abstract</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAbstract()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ABSTRACT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAbstract() <em>Abstract</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAbstract()
	 * @generated
	 * @ordered
	 */
	protected boolean abstract_ = ABSTRACT_EDEFAULT;

	/**
	 * The default value of the '{@link #isExtern() <em>Extern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExtern()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EXTERN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isExtern() <em>Extern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExtern()
	 * @generated
	 * @ordered
	 */
	protected boolean extern = EXTERN_EDEFAULT;

	/**
	 * The default value of the '{@link #isFinal() <em>Final</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFinal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FINAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFinal() <em>Final</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFinal()
	 * @generated
	 * @ordered
	 */
	protected boolean final_ = FINAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isInternal() <em>Internal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInternal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INTERNAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInternal() <em>Internal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInternal()
	 * @generated
	 * @ordered
	 */
	protected boolean internal = INTERNAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isIntrospectable() <em>Introspectable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIntrospectable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INTROSPECTABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIntrospectable() <em>Introspectable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIntrospectable()
	 * @generated
	 * @ordered
	 */
	protected boolean introspectable = INTROSPECTABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isOverride() <em>Override</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOverride()
	 * @generated
	 * @ordered
	 */
	protected static final boolean OVERRIDE_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isStatic() <em>Static</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isStatic()
	 * @generated
	 * @ordered
	 */
	protected static final boolean STATIC_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isStatic() <em>Static</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isStatic()
	 * @generated
	 * @ordered
	 */
	protected boolean static_ = STATIC_EDEFAULT;

	/**
	 * The default value of the '{@link #isTypeParameterClassMember() <em>Type Parameter Class Member</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isTypeParameterClassMember()
	 * @generated
	 * @ordered
	 */
	protected static final boolean TYPE_PARAMETER_CLASS_MEMBER_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isVirtual() <em>Virtual</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVirtual()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VIRTUAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isVirtual() <em>Virtual</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVirtual()
	 * @generated
	 * @ordered
	 */
	protected boolean virtual = VIRTUAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isInitializer() <em>Initializer</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInitializer()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INITIALIZER_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInitializer() <em>Initializer</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInitializer()
	 * @generated
	 * @ordered
	 */
	protected boolean initializer = INITIALIZER_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstructorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return functionsPackage.Literals.CONSTRUCTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Visibilities getVisibility() {
		return visibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVisibility(Visibilities newVisibility) {
		Visibilities oldVisibility = visibility;
		visibility = newVisibility == null ? VISIBILITY_EDEFAULT : newVisibility;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__VISIBILITY, oldVisibility, visibility));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Member getOverriddenMember() {
		if (overriddenMember != null && overriddenMember.eIsProxy()) {
			InternalEObject oldOverriddenMember = (InternalEObject)overriddenMember;
			overriddenMember = (Member)eResolveProxy(oldOverriddenMember);
			if (overriddenMember != oldOverriddenMember) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, functionsPackage.CONSTRUCTOR__OVERRIDDEN_MEMBER, oldOverriddenMember, overriddenMember));
			}
		}
		return overriddenMember;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Member basicGetOverriddenMember() {
		return overriddenMember;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOverriddenMember(Member newOverriddenMember) {
		Member oldOverriddenMember = overriddenMember;
		overriddenMember = newOverriddenMember;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__OVERRIDDEN_MEMBER, oldOverriddenMember, overriddenMember));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAbstract() {
		return abstract_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAbstract(boolean newAbstract) {
		boolean oldAbstract = abstract_;
		abstract_ = newAbstract;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__ABSTRACT, oldAbstract, abstract_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isExtern() {
		return extern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExtern(boolean newExtern) {
		boolean oldExtern = extern;
		extern = newExtern;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__EXTERN, oldExtern, extern));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFinal() {
		return final_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFinal(boolean newFinal) {
		boolean oldFinal = final_;
		final_ = newFinal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__FINAL, oldFinal, final_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInternal() {
		return internal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInternal(boolean newInternal) {
		boolean oldInternal = internal;
		internal = newInternal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__INTERNAL, oldInternal, internal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIntrospectable() {
		return introspectable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIntrospectable(boolean newIntrospectable) {
		boolean oldIntrospectable = introspectable;
		introspectable = newIntrospectable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__INTROSPECTABLE, oldIntrospectable, introspectable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isOverride() {
		return getOverriddenMember() != null;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetOverride() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isStatic() {
		return static_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatic(boolean newStatic) {
		boolean oldStatic = static_;
		static_ = newStatic;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__STATIC, oldStatic, static_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isTypeParameterClassMember() {
		if (getSurroundingClass() == null)
			return false;
		
		return (getSurroundingClass() instanceof TypeParameterClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetTypeParameterClassMember() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isVirtual() {
		return virtual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVirtual(boolean newVirtual) {
		boolean oldVirtual = virtual;
		virtual = newVirtual;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__VIRTUAL, oldVirtual, virtual));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInitializer() {
		return initializer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInitializer(boolean newInitializer) {
		boolean oldInitializer = initializer;
		initializer = newInitializer;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__INITIALIZER, oldInitializer, initializer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass getSurroundingClass() {
		if (eContainerFeatureID() != functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS) return null;
		return (GASTClass)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingClass(GASTClass newSurroundingClass, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingClass, functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingClass(GASTClass newSurroundingClass) {
		if (newSurroundingClass != eInternalContainer() || (eContainerFeatureID() != functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS && newSurroundingClass != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingClass))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingClass != null)
				msgs = ((InternalEObject)newSurroundingClass).eInverseAdd(this, typesPackage.GAST_CLASS__CONSTRUCTORS, GASTClass.class, msgs);
			msgs = basicSetSurroundingClass(newSurroundingClass, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS, newSurroundingClass, newSurroundingClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingClass((GASTClass)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS:
				return basicSetSurroundingClass(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS:
				return eInternalContainer().eInverseRemove(this, typesPackage.GAST_CLASS__CONSTRUCTORS, GASTClass.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case functionsPackage.CONSTRUCTOR__VISIBILITY:
				return getVisibility();
			case functionsPackage.CONSTRUCTOR__OVERRIDDEN_MEMBER:
				if (resolve) return getOverriddenMember();
				return basicGetOverriddenMember();
			case functionsPackage.CONSTRUCTOR__ABSTRACT:
				return isAbstract();
			case functionsPackage.CONSTRUCTOR__EXTERN:
				return isExtern();
			case functionsPackage.CONSTRUCTOR__FINAL:
				return isFinal();
			case functionsPackage.CONSTRUCTOR__INTERNAL:
				return isInternal();
			case functionsPackage.CONSTRUCTOR__INTROSPECTABLE:
				return isIntrospectable();
			case functionsPackage.CONSTRUCTOR__OVERRIDE:
				return isOverride();
			case functionsPackage.CONSTRUCTOR__STATIC:
				return isStatic();
			case functionsPackage.CONSTRUCTOR__TYPE_PARAMETER_CLASS_MEMBER:
				return isTypeParameterClassMember();
			case functionsPackage.CONSTRUCTOR__VIRTUAL:
				return isVirtual();
			case functionsPackage.CONSTRUCTOR__INITIALIZER:
				return isInitializer();
			case functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS:
				return getSurroundingClass();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case functionsPackage.CONSTRUCTOR__VISIBILITY:
				setVisibility((Visibilities)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__OVERRIDDEN_MEMBER:
				setOverriddenMember((Member)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__ABSTRACT:
				setAbstract((Boolean)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__EXTERN:
				setExtern((Boolean)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__FINAL:
				setFinal((Boolean)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__INTERNAL:
				setInternal((Boolean)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__INTROSPECTABLE:
				setIntrospectable((Boolean)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__STATIC:
				setStatic((Boolean)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__VIRTUAL:
				setVirtual((Boolean)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__INITIALIZER:
				setInitializer((Boolean)newValue);
				return;
			case functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case functionsPackage.CONSTRUCTOR__VISIBILITY:
				setVisibility(VISIBILITY_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__OVERRIDDEN_MEMBER:
				setOverriddenMember((Member)null);
				return;
			case functionsPackage.CONSTRUCTOR__ABSTRACT:
				setAbstract(ABSTRACT_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__EXTERN:
				setExtern(EXTERN_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__FINAL:
				setFinal(FINAL_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__INTERNAL:
				setInternal(INTERNAL_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__INTROSPECTABLE:
				setIntrospectable(INTROSPECTABLE_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__STATIC:
				setStatic(STATIC_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__VIRTUAL:
				setVirtual(VIRTUAL_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__INITIALIZER:
				setInitializer(INITIALIZER_EDEFAULT);
				return;
			case functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case functionsPackage.CONSTRUCTOR__VISIBILITY:
				return visibility != VISIBILITY_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__OVERRIDDEN_MEMBER:
				return overriddenMember != null;
			case functionsPackage.CONSTRUCTOR__ABSTRACT:
				return abstract_ != ABSTRACT_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__EXTERN:
				return extern != EXTERN_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__FINAL:
				return final_ != FINAL_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__INTERNAL:
				return internal != INTERNAL_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__INTROSPECTABLE:
				return introspectable != INTROSPECTABLE_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__OVERRIDE:
				return isOverride() != OVERRIDE_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__STATIC:
				return static_ != STATIC_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__TYPE_PARAMETER_CLASS_MEMBER:
				return isTypeParameterClassMember() != TYPE_PARAMETER_CLASS_MEMBER_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__VIRTUAL:
				return virtual != VIRTUAL_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__INITIALIZER:
				return initializer != INITIALIZER_EDEFAULT;
			case functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS:
				return getSurroundingClass() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Member.class) {
			switch (derivedFeatureID) {
				case functionsPackage.CONSTRUCTOR__VISIBILITY: return typesPackage.MEMBER__VISIBILITY;
				case functionsPackage.CONSTRUCTOR__OVERRIDDEN_MEMBER: return typesPackage.MEMBER__OVERRIDDEN_MEMBER;
				case functionsPackage.CONSTRUCTOR__ABSTRACT: return typesPackage.MEMBER__ABSTRACT;
				case functionsPackage.CONSTRUCTOR__EXTERN: return typesPackage.MEMBER__EXTERN;
				case functionsPackage.CONSTRUCTOR__FINAL: return typesPackage.MEMBER__FINAL;
				case functionsPackage.CONSTRUCTOR__INTERNAL: return typesPackage.MEMBER__INTERNAL;
				case functionsPackage.CONSTRUCTOR__INTROSPECTABLE: return typesPackage.MEMBER__INTROSPECTABLE;
				case functionsPackage.CONSTRUCTOR__OVERRIDE: return typesPackage.MEMBER__OVERRIDE;
				case functionsPackage.CONSTRUCTOR__STATIC: return typesPackage.MEMBER__STATIC;
				case functionsPackage.CONSTRUCTOR__TYPE_PARAMETER_CLASS_MEMBER: return typesPackage.MEMBER__TYPE_PARAMETER_CLASS_MEMBER;
				case functionsPackage.CONSTRUCTOR__VIRTUAL: return typesPackage.MEMBER__VIRTUAL;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Member.class) {
			switch (baseFeatureID) {
				case typesPackage.MEMBER__VISIBILITY: return functionsPackage.CONSTRUCTOR__VISIBILITY;
				case typesPackage.MEMBER__OVERRIDDEN_MEMBER: return functionsPackage.CONSTRUCTOR__OVERRIDDEN_MEMBER;
				case typesPackage.MEMBER__ABSTRACT: return functionsPackage.CONSTRUCTOR__ABSTRACT;
				case typesPackage.MEMBER__EXTERN: return functionsPackage.CONSTRUCTOR__EXTERN;
				case typesPackage.MEMBER__FINAL: return functionsPackage.CONSTRUCTOR__FINAL;
				case typesPackage.MEMBER__INTERNAL: return functionsPackage.CONSTRUCTOR__INTERNAL;
				case typesPackage.MEMBER__INTROSPECTABLE: return functionsPackage.CONSTRUCTOR__INTROSPECTABLE;
				case typesPackage.MEMBER__OVERRIDE: return functionsPackage.CONSTRUCTOR__OVERRIDE;
				case typesPackage.MEMBER__STATIC: return functionsPackage.CONSTRUCTOR__STATIC;
				case typesPackage.MEMBER__TYPE_PARAMETER_CLASS_MEMBER: return functionsPackage.CONSTRUCTOR__TYPE_PARAMETER_CLASS_MEMBER;
				case typesPackage.MEMBER__VIRTUAL: return functionsPackage.CONSTRUCTOR__VIRTUAL;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (visibility: ");
		result.append(visibility);
		result.append(", abstract: ");
		result.append(abstract_);
		result.append(", extern: ");
		result.append(extern);
		result.append(", final: ");
		result.append(final_);
		result.append(", internal: ");
		result.append(internal);
		result.append(", introspectable: ");
		result.append(introspectable);
		result.append(", static: ");
		result.append(static_);
		result.append(", virtual: ");
		result.append(virtual);
		result.append(", initializer: ");
		result.append(initializer);
		result.append(')');
		return result.toString();
	}

} //ConstructorImpl
