/**
 * <copyright>
 * </copyright>
 *
 * $Id: functionsPackage.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.functions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.gast.core.corePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This package contains all classes and interfaces which represent the function hierarchy. 
 * <!-- end-model-doc -->
 * @see de.fzi.gast.functions.functionsFactory
 * @model kind="package"
 * @generated
 */
public interface functionsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "functions";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.fzi.de/gast/functions";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "functions";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	functionsPackage eINSTANCE = de.fzi.gast.functions.impl.functionsPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.FunctionImpl <em>Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.FunctionImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getFunction()
	 * @generated
	 */
	int FUNCTION = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__ID = corePackage.NAMED_MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__ANNOTATIONS = corePackage.NAMED_MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__STATUS = corePackage.NAMED_MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__SISSY_ID = corePackage.NAMED_MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__SIMPLE_NAME = corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__POSITION = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__RETURN_TYPE_DECLARATION = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__FORMAL_PARAMETERS = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__LOCAL_VARIABLES = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__ALL_STATEMENTS = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__THROW_TYPE_ACCESSES = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__ACCESSES = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__NUMBER_OF_STATEMENTS = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__MAXIMUM_NESTING_LEVEL = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__LINES_OF_COMMENTS = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__LINES_OF_CODE = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__NUMBER_OF_EDGES_IN_CFG = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__NUMBER_OF_NODES_IN_CFG = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__OPERATOR = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__BODY = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__LOCAL_CLASSES = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The number of structural features of the '<em>Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_FEATURE_COUNT = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.ConstructorImpl <em>Constructor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.ConstructorImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getConstructor()
	 * @generated
	 */
	int CONSTRUCTOR = 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.MethodImpl <em>Method</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.MethodImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getMethod()
	 * @generated
	 */
	int METHOD = 5;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.DestructorImpl <em>Destructor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.DestructorImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getDestructor()
	 * @generated
	 */
	int DESTRUCTOR = 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.GlobalFunctionImpl <em>Global Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.GlobalFunctionImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGlobalFunction()
	 * @generated
	 */
	int GLOBAL_FUNCTION = 4;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.GenericFunctionImpl <em>Generic Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.GenericFunctionImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGenericFunction()
	 * @generated
	 */
	int GENERIC_FUNCTION = 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.GenericMethodImpl <em>Generic Method</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.GenericMethodImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGenericMethod()
	 * @generated
	 */
	int GENERIC_METHOD = 6;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.GenericConstructorImpl <em>Generic Constructor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.GenericConstructorImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGenericConstructor()
	 * @generated
	 */
	int GENERIC_CONSTRUCTOR = 7;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.impl.DelegateImpl <em>Delegate</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.impl.DelegateImpl
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getDelegate()
	 * @generated
	 */
	int DELEGATE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__ID = FUNCTION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__ANNOTATIONS = FUNCTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__STATUS = FUNCTION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__SISSY_ID = FUNCTION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__SIMPLE_NAME = FUNCTION__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__POSITION = FUNCTION__POSITION;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__RETURN_TYPE_DECLARATION = FUNCTION__RETURN_TYPE_DECLARATION;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__FORMAL_PARAMETERS = FUNCTION__FORMAL_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__LOCAL_VARIABLES = FUNCTION__LOCAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__ALL_STATEMENTS = FUNCTION__ALL_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__THROW_TYPE_ACCESSES = FUNCTION__THROW_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__ACCESSES = FUNCTION__ACCESSES;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__NUMBER_OF_STATEMENTS = FUNCTION__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__MAXIMUM_NESTING_LEVEL = FUNCTION__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__LINES_OF_COMMENTS = FUNCTION__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__LINES_OF_CODE = FUNCTION__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__NUMBER_OF_EDGES_IN_CFG = FUNCTION__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__NUMBER_OF_NODES_IN_CFG = FUNCTION__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__OPERATOR = FUNCTION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__BODY = FUNCTION__BODY;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__LOCAL_CLASSES = FUNCTION__LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__VISIBILITY = FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__OVERRIDDEN_MEMBER = FUNCTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__ABSTRACT = FUNCTION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__EXTERN = FUNCTION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__FINAL = FUNCTION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__INTERNAL = FUNCTION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__INTROSPECTABLE = FUNCTION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__OVERRIDE = FUNCTION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__STATIC = FUNCTION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__TYPE_PARAMETER_CLASS_MEMBER = FUNCTION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__VIRTUAL = FUNCTION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__QUALIFIED_NAME = FUNCTION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__REFERENCE_TYPE = FUNCTION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Inner Delegate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__INNER_DELEGATE = FUNCTION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Super Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__SUPER_CLASS = FUNCTION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Invocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__INVOCATIONS = FUNCTION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__SURROUNDING_CLASS = FUNCTION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE__SURROUNDING_PACKAGE = FUNCTION_FEATURE_COUNT + 17;

	/**
	 * The number of structural features of the '<em>Delegate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_FEATURE_COUNT = FUNCTION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__ID = FUNCTION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__ANNOTATIONS = FUNCTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__STATUS = FUNCTION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__SISSY_ID = FUNCTION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__SIMPLE_NAME = FUNCTION__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__POSITION = FUNCTION__POSITION;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__RETURN_TYPE_DECLARATION = FUNCTION__RETURN_TYPE_DECLARATION;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__FORMAL_PARAMETERS = FUNCTION__FORMAL_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__LOCAL_VARIABLES = FUNCTION__LOCAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__ALL_STATEMENTS = FUNCTION__ALL_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__THROW_TYPE_ACCESSES = FUNCTION__THROW_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__ACCESSES = FUNCTION__ACCESSES;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__NUMBER_OF_STATEMENTS = FUNCTION__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__MAXIMUM_NESTING_LEVEL = FUNCTION__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__LINES_OF_COMMENTS = FUNCTION__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__LINES_OF_CODE = FUNCTION__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__NUMBER_OF_EDGES_IN_CFG = FUNCTION__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__NUMBER_OF_NODES_IN_CFG = FUNCTION__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__OPERATOR = FUNCTION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__BODY = FUNCTION__BODY;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__LOCAL_CLASSES = FUNCTION__LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__VISIBILITY = FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__OVERRIDDEN_MEMBER = FUNCTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__ABSTRACT = FUNCTION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__EXTERN = FUNCTION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__FINAL = FUNCTION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__INTERNAL = FUNCTION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__INTROSPECTABLE = FUNCTION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__OVERRIDE = FUNCTION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__STATIC = FUNCTION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__TYPE_PARAMETER_CLASS_MEMBER = FUNCTION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__VIRTUAL = FUNCTION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Initializer</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__INITIALIZER = FUNCTION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR__SURROUNDING_CLASS = FUNCTION_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>Constructor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR_FEATURE_COUNT = FUNCTION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__ID = FUNCTION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__ANNOTATIONS = FUNCTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__STATUS = FUNCTION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__SISSY_ID = FUNCTION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__SIMPLE_NAME = FUNCTION__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__POSITION = FUNCTION__POSITION;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__RETURN_TYPE_DECLARATION = FUNCTION__RETURN_TYPE_DECLARATION;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__FORMAL_PARAMETERS = FUNCTION__FORMAL_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__LOCAL_VARIABLES = FUNCTION__LOCAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__ALL_STATEMENTS = FUNCTION__ALL_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__THROW_TYPE_ACCESSES = FUNCTION__THROW_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__ACCESSES = FUNCTION__ACCESSES;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__NUMBER_OF_STATEMENTS = FUNCTION__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__MAXIMUM_NESTING_LEVEL = FUNCTION__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__LINES_OF_COMMENTS = FUNCTION__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__LINES_OF_CODE = FUNCTION__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__NUMBER_OF_EDGES_IN_CFG = FUNCTION__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__NUMBER_OF_NODES_IN_CFG = FUNCTION__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__OPERATOR = FUNCTION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__BODY = FUNCTION__BODY;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__LOCAL_CLASSES = FUNCTION__LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__VISIBILITY = FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__OVERRIDDEN_MEMBER = FUNCTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__ABSTRACT = FUNCTION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__EXTERN = FUNCTION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__FINAL = FUNCTION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__INTERNAL = FUNCTION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__INTROSPECTABLE = FUNCTION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__OVERRIDE = FUNCTION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__STATIC = FUNCTION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__TYPE_PARAMETER_CLASS_MEMBER = FUNCTION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__VIRTUAL = FUNCTION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR__SURROUNDING_CLASS = FUNCTION_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Destructor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESTRUCTOR_FEATURE_COUNT = FUNCTION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__ID = FUNCTION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__ANNOTATIONS = FUNCTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__STATUS = FUNCTION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__SISSY_ID = FUNCTION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__SIMPLE_NAME = FUNCTION__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__POSITION = FUNCTION__POSITION;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__RETURN_TYPE_DECLARATION = FUNCTION__RETURN_TYPE_DECLARATION;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__FORMAL_PARAMETERS = FUNCTION__FORMAL_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__LOCAL_VARIABLES = FUNCTION__LOCAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__ALL_STATEMENTS = FUNCTION__ALL_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__THROW_TYPE_ACCESSES = FUNCTION__THROW_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__ACCESSES = FUNCTION__ACCESSES;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__NUMBER_OF_STATEMENTS = FUNCTION__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__MAXIMUM_NESTING_LEVEL = FUNCTION__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__LINES_OF_COMMENTS = FUNCTION__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__LINES_OF_CODE = FUNCTION__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__NUMBER_OF_EDGES_IN_CFG = FUNCTION__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__NUMBER_OF_NODES_IN_CFG = FUNCTION__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__OPERATOR = FUNCTION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__BODY = FUNCTION__BODY;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__LOCAL_CLASSES = FUNCTION__LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__SURROUNDING_PACKAGE = FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION__KIND = FUNCTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Global Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_FUNCTION_FEATURE_COUNT = FUNCTION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__ID = GLOBAL_FUNCTION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__ANNOTATIONS = GLOBAL_FUNCTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__STATUS = GLOBAL_FUNCTION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__SISSY_ID = GLOBAL_FUNCTION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__SIMPLE_NAME = GLOBAL_FUNCTION__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__POSITION = GLOBAL_FUNCTION__POSITION;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__RETURN_TYPE_DECLARATION = GLOBAL_FUNCTION__RETURN_TYPE_DECLARATION;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__FORMAL_PARAMETERS = GLOBAL_FUNCTION__FORMAL_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__LOCAL_VARIABLES = GLOBAL_FUNCTION__LOCAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__ALL_STATEMENTS = GLOBAL_FUNCTION__ALL_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__THROW_TYPE_ACCESSES = GLOBAL_FUNCTION__THROW_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__ACCESSES = GLOBAL_FUNCTION__ACCESSES;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__NUMBER_OF_STATEMENTS = GLOBAL_FUNCTION__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__MAXIMUM_NESTING_LEVEL = GLOBAL_FUNCTION__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__LINES_OF_COMMENTS = GLOBAL_FUNCTION__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__LINES_OF_CODE = GLOBAL_FUNCTION__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__NUMBER_OF_EDGES_IN_CFG = GLOBAL_FUNCTION__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__NUMBER_OF_NODES_IN_CFG = GLOBAL_FUNCTION__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__OPERATOR = GLOBAL_FUNCTION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__BODY = GLOBAL_FUNCTION__BODY;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__LOCAL_CLASSES = GLOBAL_FUNCTION__LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__SURROUNDING_PACKAGE = GLOBAL_FUNCTION__SURROUNDING_PACKAGE;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__KIND = GLOBAL_FUNCTION__KIND;

	/**
	 * The feature id for the '<em><b>Type Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION__TYPE_PARAMETERS = GLOBAL_FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Generic Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_FUNCTION_FEATURE_COUNT = GLOBAL_FUNCTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__ID = FUNCTION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__ANNOTATIONS = FUNCTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__STATUS = FUNCTION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__SISSY_ID = FUNCTION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__SIMPLE_NAME = FUNCTION__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__POSITION = FUNCTION__POSITION;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__RETURN_TYPE_DECLARATION = FUNCTION__RETURN_TYPE_DECLARATION;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__FORMAL_PARAMETERS = FUNCTION__FORMAL_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__LOCAL_VARIABLES = FUNCTION__LOCAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__ALL_STATEMENTS = FUNCTION__ALL_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__THROW_TYPE_ACCESSES = FUNCTION__THROW_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__ACCESSES = FUNCTION__ACCESSES;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__NUMBER_OF_STATEMENTS = FUNCTION__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__MAXIMUM_NESTING_LEVEL = FUNCTION__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__LINES_OF_COMMENTS = FUNCTION__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__LINES_OF_CODE = FUNCTION__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__NUMBER_OF_EDGES_IN_CFG = FUNCTION__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__NUMBER_OF_NODES_IN_CFG = FUNCTION__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__OPERATOR = FUNCTION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__BODY = FUNCTION__BODY;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__LOCAL_CLASSES = FUNCTION__LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__VISIBILITY = FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__OVERRIDDEN_MEMBER = FUNCTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__ABSTRACT = FUNCTION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__EXTERN = FUNCTION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__FINAL = FUNCTION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__INTERNAL = FUNCTION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__INTROSPECTABLE = FUNCTION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__OVERRIDE = FUNCTION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__STATIC = FUNCTION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__TYPE_PARAMETER_CLASS_MEMBER = FUNCTION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__VIRTUAL = FUNCTION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Property Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__PROPERTY_METHOD = FUNCTION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Surrounding Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__SURROUNDING_PROPERTY = FUNCTION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD__SURROUNDING_CLASS = FUNCTION_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>Method</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_FEATURE_COUNT = FUNCTION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__ID = METHOD__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__ANNOTATIONS = METHOD__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__STATUS = METHOD__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__SISSY_ID = METHOD__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__SIMPLE_NAME = METHOD__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__POSITION = METHOD__POSITION;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__RETURN_TYPE_DECLARATION = METHOD__RETURN_TYPE_DECLARATION;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__FORMAL_PARAMETERS = METHOD__FORMAL_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__LOCAL_VARIABLES = METHOD__LOCAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__ALL_STATEMENTS = METHOD__ALL_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__THROW_TYPE_ACCESSES = METHOD__THROW_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__ACCESSES = METHOD__ACCESSES;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__NUMBER_OF_STATEMENTS = METHOD__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__MAXIMUM_NESTING_LEVEL = METHOD__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__LINES_OF_COMMENTS = METHOD__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__LINES_OF_CODE = METHOD__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__NUMBER_OF_EDGES_IN_CFG = METHOD__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__NUMBER_OF_NODES_IN_CFG = METHOD__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__OPERATOR = METHOD__OPERATOR;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__BODY = METHOD__BODY;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__LOCAL_CLASSES = METHOD__LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__VISIBILITY = METHOD__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__OVERRIDDEN_MEMBER = METHOD__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__ABSTRACT = METHOD__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__EXTERN = METHOD__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__FINAL = METHOD__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__INTERNAL = METHOD__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__INTROSPECTABLE = METHOD__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__OVERRIDE = METHOD__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__STATIC = METHOD__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__TYPE_PARAMETER_CLASS_MEMBER = METHOD__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__VIRTUAL = METHOD__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Property Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__PROPERTY_METHOD = METHOD__PROPERTY_METHOD;

	/**
	 * The feature id for the '<em><b>Surrounding Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__SURROUNDING_PROPERTY = METHOD__SURROUNDING_PROPERTY;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__SURROUNDING_CLASS = METHOD__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Type Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD__TYPE_PARAMETERS = METHOD_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Generic Method</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_METHOD_FEATURE_COUNT = METHOD_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__ID = CONSTRUCTOR__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__ANNOTATIONS = CONSTRUCTOR__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__STATUS = CONSTRUCTOR__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__SISSY_ID = CONSTRUCTOR__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__SIMPLE_NAME = CONSTRUCTOR__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__POSITION = CONSTRUCTOR__POSITION;

	/**
	 * The feature id for the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__RETURN_TYPE_DECLARATION = CONSTRUCTOR__RETURN_TYPE_DECLARATION;

	/**
	 * The feature id for the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__FORMAL_PARAMETERS = CONSTRUCTOR__FORMAL_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Local Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__LOCAL_VARIABLES = CONSTRUCTOR__LOCAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>All Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__ALL_STATEMENTS = CONSTRUCTOR__ALL_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__THROW_TYPE_ACCESSES = CONSTRUCTOR__THROW_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__ACCESSES = CONSTRUCTOR__ACCESSES;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__NUMBER_OF_STATEMENTS = CONSTRUCTOR__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__MAXIMUM_NESTING_LEVEL = CONSTRUCTOR__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__LINES_OF_COMMENTS = CONSTRUCTOR__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__LINES_OF_CODE = CONSTRUCTOR__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__NUMBER_OF_EDGES_IN_CFG = CONSTRUCTOR__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__NUMBER_OF_NODES_IN_CFG = CONSTRUCTOR__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__OPERATOR = CONSTRUCTOR__OPERATOR;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__BODY = CONSTRUCTOR__BODY;

	/**
	 * The feature id for the '<em><b>Local Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__LOCAL_CLASSES = CONSTRUCTOR__LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__VISIBILITY = CONSTRUCTOR__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__OVERRIDDEN_MEMBER = CONSTRUCTOR__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__ABSTRACT = CONSTRUCTOR__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__EXTERN = CONSTRUCTOR__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__FINAL = CONSTRUCTOR__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__INTERNAL = CONSTRUCTOR__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__INTROSPECTABLE = CONSTRUCTOR__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__OVERRIDE = CONSTRUCTOR__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__STATIC = CONSTRUCTOR__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__TYPE_PARAMETER_CLASS_MEMBER = CONSTRUCTOR__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__VIRTUAL = CONSTRUCTOR__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Initializer</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__INITIALIZER = CONSTRUCTOR__INITIALIZER;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__SURROUNDING_CLASS = CONSTRUCTOR__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Type Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR__TYPE_PARAMETERS = CONSTRUCTOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Generic Constructor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CONSTRUCTOR_FEATURE_COUNT = CONSTRUCTOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.functions.GlobalFunctionKind <em>Global Function Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.functions.GlobalFunctionKind
	 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGlobalFunctionKind()
	 * @generated
	 */
	int GLOBAL_FUNCTION_KIND = 9;


	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.Constructor <em>Constructor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constructor</em>'.
	 * @see de.fzi.gast.functions.Constructor
	 * @generated
	 */
	EClass getConstructor();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Constructor#isInitializer <em>Initializer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Initializer</em>'.
	 * @see de.fzi.gast.functions.Constructor#isInitializer()
	 * @see #getConstructor()
	 * @generated
	 */
	EAttribute getConstructor_Initializer();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.functions.Constructor#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Class</em>'.
	 * @see de.fzi.gast.functions.Constructor#getSurroundingClass()
	 * @see #getConstructor()
	 * @generated
	 */
	EReference getConstructor_SurroundingClass();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.Function <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function</em>'.
	 * @see de.fzi.gast.functions.Function
	 * @generated
	 */
	EClass getFunction();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.functions.Function#getAllStatements <em>All Statements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Statements</em>'.
	 * @see de.fzi.gast.functions.Function#getAllStatements()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_AllStatements();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.functions.Function#getThrowTypeAccesses <em>Throw Type Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Throw Type Accesses</em>'.
	 * @see de.fzi.gast.functions.Function#getThrowTypeAccesses()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_ThrowTypeAccesses();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.functions.Function#getFormalParameters <em>Formal Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Formal Parameters</em>'.
	 * @see de.fzi.gast.functions.Function#getFormalParameters()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_FormalParameters();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.functions.Function#getLocalVariables <em>Local Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Local Variables</em>'.
	 * @see de.fzi.gast.functions.Function#getLocalVariables()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_LocalVariables();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.functions.Function#getReturnTypeDeclaration <em>Return Type Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Return Type Declaration</em>'.
	 * @see de.fzi.gast.functions.Function#getReturnTypeDeclaration()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_ReturnTypeDeclaration();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.functions.Function#getAccesses <em>Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Accesses</em>'.
	 * @see de.fzi.gast.functions.Function#getAccesses()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Accesses();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Function#getNumberOfStatements <em>Number Of Statements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Number Of Statements</em>'.
	 * @see de.fzi.gast.functions.Function#getNumberOfStatements()
	 * @see #getFunction()
	 * @generated
	 */
	EAttribute getFunction_NumberOfStatements();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Function#getMaximumNestingLevel <em>Maximum Nesting Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Maximum Nesting Level</em>'.
	 * @see de.fzi.gast.functions.Function#getMaximumNestingLevel()
	 * @see #getFunction()
	 * @generated
	 */
	EAttribute getFunction_MaximumNestingLevel();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Function#getLinesOfComments <em>Lines Of Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Comments</em>'.
	 * @see de.fzi.gast.functions.Function#getLinesOfComments()
	 * @see #getFunction()
	 * @generated
	 */
	EAttribute getFunction_LinesOfComments();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Function#getLinesOfCode <em>Lines Of Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Code</em>'.
	 * @see de.fzi.gast.functions.Function#getLinesOfCode()
	 * @see #getFunction()
	 * @generated
	 */
	EAttribute getFunction_LinesOfCode();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Function#getNumberOfEdgesInCFG <em>Number Of Edges In CFG</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Number Of Edges In CFG</em>'.
	 * @see de.fzi.gast.functions.Function#getNumberOfEdgesInCFG()
	 * @see #getFunction()
	 * @generated
	 */
	EAttribute getFunction_NumberOfEdgesInCFG();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Function#getNumberOfNodesInCFG <em>Number Of Nodes In CFG</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Number Of Nodes In CFG</em>'.
	 * @see de.fzi.gast.functions.Function#getNumberOfNodesInCFG()
	 * @see #getFunction()
	 * @generated
	 */
	EAttribute getFunction_NumberOfNodesInCFG();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Function#isOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see de.fzi.gast.functions.Function#isOperator()
	 * @see #getFunction()
	 * @generated
	 */
	EAttribute getFunction_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.functions.Function#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Body</em>'.
	 * @see de.fzi.gast.functions.Function#getBody()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Body();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.functions.Function#getLocalClasses <em>Local Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Local Classes</em>'.
	 * @see de.fzi.gast.functions.Function#getLocalClasses()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_LocalClasses();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.Method <em>Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Method</em>'.
	 * @see de.fzi.gast.functions.Method
	 * @generated
	 */
	EClass getMethod();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Method#isPropertyMethod <em>Property Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Property Method</em>'.
	 * @see de.fzi.gast.functions.Method#isPropertyMethod()
	 * @see #getMethod()
	 * @generated
	 */
	EAttribute getMethod_PropertyMethod();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.functions.Method#getSurroundingProperty <em>Surrounding Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Surrounding Property</em>'.
	 * @see de.fzi.gast.functions.Method#getSurroundingProperty()
	 * @see #getMethod()
	 * @generated
	 */
	EReference getMethod_SurroundingProperty();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.functions.Method#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Class</em>'.
	 * @see de.fzi.gast.functions.Method#getSurroundingClass()
	 * @see #getMethod()
	 * @generated
	 */
	EReference getMethod_SurroundingClass();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.Destructor <em>Destructor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Destructor</em>'.
	 * @see de.fzi.gast.functions.Destructor
	 * @generated
	 */
	EClass getDestructor();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.functions.Destructor#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Class</em>'.
	 * @see de.fzi.gast.functions.Destructor#getSurroundingClass()
	 * @see #getDestructor()
	 * @generated
	 */
	EReference getDestructor_SurroundingClass();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.GenericFunction <em>Generic Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generic Function</em>'.
	 * @see de.fzi.gast.functions.GenericFunction
	 * @generated
	 */
	EClass getGenericFunction();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.GlobalFunction <em>Global Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Global Function</em>'.
	 * @see de.fzi.gast.functions.GlobalFunction
	 * @generated
	 */
	EClass getGlobalFunction();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.functions.GlobalFunction#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Package</em>'.
	 * @see de.fzi.gast.functions.GlobalFunction#getSurroundingPackage()
	 * @see #getGlobalFunction()
	 * @generated
	 */
	EReference getGlobalFunction_SurroundingPackage();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.GlobalFunction#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see de.fzi.gast.functions.GlobalFunction#getKind()
	 * @see #getGlobalFunction()
	 * @generated
	 */
	EAttribute getGlobalFunction_Kind();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.GenericMethod <em>Generic Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generic Method</em>'.
	 * @see de.fzi.gast.functions.GenericMethod
	 * @generated
	 */
	EClass getGenericMethod();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.GenericConstructor <em>Generic Constructor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generic Constructor</em>'.
	 * @see de.fzi.gast.functions.GenericConstructor
	 * @generated
	 */
	EClass getGenericConstructor();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.functions.Delegate <em>Delegate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Delegate</em>'.
	 * @see de.fzi.gast.functions.Delegate
	 * @generated
	 */
	EClass getDelegate();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.functions.Delegate#isInnerDelegate <em>Inner Delegate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inner Delegate</em>'.
	 * @see de.fzi.gast.functions.Delegate#isInnerDelegate()
	 * @see #getDelegate()
	 * @generated
	 */
	EAttribute getDelegate_InnerDelegate();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.functions.Delegate#getSuperClass <em>Super Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Super Class</em>'.
	 * @see de.fzi.gast.functions.Delegate#getSuperClass()
	 * @see #getDelegate()
	 * @generated
	 */
	EReference getDelegate_SuperClass();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.functions.Delegate#getInvocations <em>Invocations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Invocations</em>'.
	 * @see de.fzi.gast.functions.Delegate#getInvocations()
	 * @see #getDelegate()
	 * @generated
	 */
	EReference getDelegate_Invocations();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.functions.Delegate#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Class</em>'.
	 * @see de.fzi.gast.functions.Delegate#getSurroundingClass()
	 * @see #getDelegate()
	 * @generated
	 */
	EReference getDelegate_SurroundingClass();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.functions.Delegate#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Package</em>'.
	 * @see de.fzi.gast.functions.Delegate#getSurroundingPackage()
	 * @see #getDelegate()
	 * @generated
	 */
	EReference getDelegate_SurroundingPackage();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.functions.GlobalFunctionKind <em>Global Function Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Global Function Kind</em>'.
	 * @see de.fzi.gast.functions.GlobalFunctionKind
	 * @generated
	 */
	EEnum getGlobalFunctionKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	functionsFactory getfunctionsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.ConstructorImpl <em>Constructor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.ConstructorImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getConstructor()
		 * @generated
		 */
		EClass CONSTRUCTOR = eINSTANCE.getConstructor();

		/**
		 * The meta object literal for the '<em><b>Initializer</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONSTRUCTOR__INITIALIZER = eINSTANCE.getConstructor_Initializer();

		/**
		 * The meta object literal for the '<em><b>Surrounding Class</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONSTRUCTOR__SURROUNDING_CLASS = eINSTANCE.getConstructor_SurroundingClass();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.FunctionImpl <em>Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.FunctionImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getFunction()
		 * @generated
		 */
		EClass FUNCTION = eINSTANCE.getFunction();

		/**
		 * The meta object literal for the '<em><b>All Statements</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__ALL_STATEMENTS = eINSTANCE.getFunction_AllStatements();

		/**
		 * The meta object literal for the '<em><b>Throw Type Accesses</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__THROW_TYPE_ACCESSES = eINSTANCE.getFunction_ThrowTypeAccesses();

		/**
		 * The meta object literal for the '<em><b>Formal Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__FORMAL_PARAMETERS = eINSTANCE.getFunction_FormalParameters();

		/**
		 * The meta object literal for the '<em><b>Local Variables</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__LOCAL_VARIABLES = eINSTANCE.getFunction_LocalVariables();

		/**
		 * The meta object literal for the '<em><b>Return Type Declaration</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__RETURN_TYPE_DECLARATION = eINSTANCE.getFunction_ReturnTypeDeclaration();

		/**
		 * The meta object literal for the '<em><b>Accesses</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__ACCESSES = eINSTANCE.getFunction_Accesses();

		/**
		 * The meta object literal for the '<em><b>Number Of Statements</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION__NUMBER_OF_STATEMENTS = eINSTANCE.getFunction_NumberOfStatements();

		/**
		 * The meta object literal for the '<em><b>Maximum Nesting Level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION__MAXIMUM_NESTING_LEVEL = eINSTANCE.getFunction_MaximumNestingLevel();

		/**
		 * The meta object literal for the '<em><b>Lines Of Comments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION__LINES_OF_COMMENTS = eINSTANCE.getFunction_LinesOfComments();

		/**
		 * The meta object literal for the '<em><b>Lines Of Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION__LINES_OF_CODE = eINSTANCE.getFunction_LinesOfCode();

		/**
		 * The meta object literal for the '<em><b>Number Of Edges In CFG</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION__NUMBER_OF_EDGES_IN_CFG = eINSTANCE.getFunction_NumberOfEdgesInCFG();

		/**
		 * The meta object literal for the '<em><b>Number Of Nodes In CFG</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION__NUMBER_OF_NODES_IN_CFG = eINSTANCE.getFunction_NumberOfNodesInCFG();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION__OPERATOR = eINSTANCE.getFunction_Operator();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__BODY = eINSTANCE.getFunction_Body();

		/**
		 * The meta object literal for the '<em><b>Local Classes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__LOCAL_CLASSES = eINSTANCE.getFunction_LocalClasses();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.MethodImpl <em>Method</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.MethodImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getMethod()
		 * @generated
		 */
		EClass METHOD = eINSTANCE.getMethod();

		/**
		 * The meta object literal for the '<em><b>Property Method</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute METHOD__PROPERTY_METHOD = eINSTANCE.getMethod_PropertyMethod();

		/**
		 * The meta object literal for the '<em><b>Surrounding Property</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference METHOD__SURROUNDING_PROPERTY = eINSTANCE.getMethod_SurroundingProperty();

		/**
		 * The meta object literal for the '<em><b>Surrounding Class</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference METHOD__SURROUNDING_CLASS = eINSTANCE.getMethod_SurroundingClass();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.DestructorImpl <em>Destructor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.DestructorImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getDestructor()
		 * @generated
		 */
		EClass DESTRUCTOR = eINSTANCE.getDestructor();

		/**
		 * The meta object literal for the '<em><b>Surrounding Class</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DESTRUCTOR__SURROUNDING_CLASS = eINSTANCE.getDestructor_SurroundingClass();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.GenericFunctionImpl <em>Generic Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.GenericFunctionImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGenericFunction()
		 * @generated
		 */
		EClass GENERIC_FUNCTION = eINSTANCE.getGenericFunction();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.GlobalFunctionImpl <em>Global Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.GlobalFunctionImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGlobalFunction()
		 * @generated
		 */
		EClass GLOBAL_FUNCTION = eINSTANCE.getGlobalFunction();

		/**
		 * The meta object literal for the '<em><b>Surrounding Package</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GLOBAL_FUNCTION__SURROUNDING_PACKAGE = eINSTANCE.getGlobalFunction_SurroundingPackage();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GLOBAL_FUNCTION__KIND = eINSTANCE.getGlobalFunction_Kind();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.GenericMethodImpl <em>Generic Method</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.GenericMethodImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGenericMethod()
		 * @generated
		 */
		EClass GENERIC_METHOD = eINSTANCE.getGenericMethod();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.GenericConstructorImpl <em>Generic Constructor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.GenericConstructorImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGenericConstructor()
		 * @generated
		 */
		EClass GENERIC_CONSTRUCTOR = eINSTANCE.getGenericConstructor();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.impl.DelegateImpl <em>Delegate</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.impl.DelegateImpl
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getDelegate()
		 * @generated
		 */
		EClass DELEGATE = eINSTANCE.getDelegate();

		/**
		 * The meta object literal for the '<em><b>Inner Delegate</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DELEGATE__INNER_DELEGATE = eINSTANCE.getDelegate_InnerDelegate();

		/**
		 * The meta object literal for the '<em><b>Super Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE__SUPER_CLASS = eINSTANCE.getDelegate_SuperClass();

		/**
		 * The meta object literal for the '<em><b>Invocations</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE__INVOCATIONS = eINSTANCE.getDelegate_Invocations();

		/**
		 * The meta object literal for the '<em><b>Surrounding Class</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE__SURROUNDING_CLASS = eINSTANCE.getDelegate_SurroundingClass();

		/**
		 * The meta object literal for the '<em><b>Surrounding Package</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE__SURROUNDING_PACKAGE = eINSTANCE.getDelegate_SurroundingPackage();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.functions.GlobalFunctionKind <em>Global Function Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.functions.GlobalFunctionKind
		 * @see de.fzi.gast.functions.impl.functionsPackageImpl#getGlobalFunctionKind()
		 * @generated
		 */
		EEnum GLOBAL_FUNCTION_KIND = eINSTANCE.getGlobalFunctionKind();

	}

} //functionsPackage
