/**
 * <copyright>
 * </copyright>
 *
 * $Id: Method.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.functions;

import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Member;
import de.fzi.gast.variables.Property;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Method</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a methods of a class. Constructors and destructors are modelled explicitly.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.Method#isPropertyMethod <em>Property Method</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Method#getSurroundingProperty <em>Surrounding Property</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Method#getSurroundingClass <em>Surrounding Class</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.functions.functionsPackage#getMethod()
 * @model
 * @generated
 */
public interface Method extends Function, Member {
	/**
	 * Returns the value of the '<em><b>Property Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this method represents a property accessor method.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Property Method</em>' attribute.
	 * @see de.fzi.gast.functions.functionsPackage#getMethod_PropertyMethod()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	boolean isPropertyMethod();

	/**
	 * Returns the value of the '<em><b>Surrounding Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If this method is a property method this property represents a reference to the property. Otherwise it is "null".
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Property</em>' reference.
	 * @see #setSurroundingProperty(Property)
	 * @see de.fzi.gast.functions.functionsPackage#getMethod_SurroundingProperty()
	 * @model ordered="false"
	 * @generated
	 */
	Property getSurroundingProperty();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Method#getSurroundingProperty <em>Surrounding Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Property</em>' reference.
	 * @see #getSurroundingProperty()
	 * @generated
	 */
	void setSurroundingProperty(Property value);

	/**
	 * Returns the value of the '<em><b>Surrounding Class</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getMethods <em>Methods</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the class which contains this method.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Class</em>' container reference.
	 * @see #setSurroundingClass(GASTClass)
	 * @see de.fzi.gast.functions.functionsPackage#getMethod_SurroundingClass()
	 * @see de.fzi.gast.types.GASTClass#getMethods
	 * @model opposite="methods" required="true" transient="false" ordered="false"
	 * @generated
	 */
	GASTClass getSurroundingClass();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Method#getSurroundingClass <em>Surrounding Class</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Class</em>' container reference.
	 * @see #getSurroundingClass()
	 * @generated
	 */
	void setSurroundingClass(GASTClass value);

} // Method
