/**
 * <copyright>
 * </copyright>
 *
 * $Id: GlobalFunctionKind.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Global Function Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This enumeration contains literals which describe the kinds of global functions.
 * <!-- end-model-doc -->
 * @see de.fzi.gast.functions.functionsPackage#getGlobalFunctionKind()
 * @model
 * @generated
 */
public enum GlobalFunctionKind implements Enumerator {
	/**
	 * The '<em><b>NORMAL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NORMAL_VALUE
	 * @generated
	 * @ordered
	 */
	NORMAL(50, "NORMAL", "NORMAL"),

	/**
	 * The '<em><b>UNITINITIALIZER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNITINITIALIZER_VALUE
	 * @generated
	 * @ordered
	 */
	UNITINITIALIZER(58, "UNITINITIALIZER", "UNITINITIALIZER"),

	/**
	 * The '<em><b>UNITFINALIZER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNITFINALIZER_VALUE
	 * @generated
	 * @ordered
	 */
	UNITFINALIZER(59, "UNITFINALIZER", "UNITFINALIZER");

	/**
	 * The '<em><b>NORMAL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Shows that it is a normal global function.
	 * <!-- end-model-doc -->
	 * @see #NORMAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NORMAL_VALUE = 50;

	/**
	 * The '<em><b>UNITINITIALIZER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Shows that a global function serves as unit initializer.
	 * <!-- end-model-doc -->
	 * @see #UNITINITIALIZER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int UNITINITIALIZER_VALUE = 58;

	/**
	 * The '<em><b>UNITFINALIZER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Shows that a global function serves as unit finalizer.
	 * <!-- end-model-doc -->
	 * @see #UNITFINALIZER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int UNITFINALIZER_VALUE = 59;

	/**
	 * An array of all the '<em><b>Global Function Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final GlobalFunctionKind[] VALUES_ARRAY =
		new GlobalFunctionKind[] {
			NORMAL,
			UNITINITIALIZER,
			UNITFINALIZER,
		};

	/**
	 * A public read-only list of all the '<em><b>Global Function Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<GlobalFunctionKind> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Global Function Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static GlobalFunctionKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			GlobalFunctionKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Global Function Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static GlobalFunctionKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			GlobalFunctionKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Global Function Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static GlobalFunctionKind get(int value) {
		switch (value) {
			case NORMAL_VALUE: return NORMAL;
			case UNITINITIALIZER_VALUE: return UNITINITIALIZER;
			case UNITFINALIZER_VALUE: return UNITFINALIZER;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private GlobalFunctionKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //GlobalFunctionKind
