/**
 * <copyright>
 * </copyright>
 *
 * $Id: GlobalFunction.java,v 1.5 2008/12/05 15:44:36 stammel Exp $
 */
package de.fzi.gast.functions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Global Function</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class models a global function. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.GlobalFunction#getSurroundingPackage <em>Surrounding Package</em>}</li>
 *   <li>{@link de.fzi.gast.functions.GlobalFunction#getKind <em>Kind</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.functions.functionsPackage#getGlobalFunction()
 * @model
 * @generated
 */
public interface GlobalFunction extends Function {
	/**
	 * Returns the value of the '<em><b>Surrounding Package</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Package#getGlobalFunctions <em>Global Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the package which contains this global function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Package</em>' container reference.
	 * @see #setSurroundingPackage(de.fzi.gast.core.Package)
	 * @see de.fzi.gast.functions.functionsPackage#getGlobalFunction_SurroundingPackage()
	 * @see de.fzi.gast.core.Package#getGlobalFunctions
	 * @model opposite="globalFunctions" required="true" transient="false" ordered="false"
	 * @generated
	 */
	de.fzi.gast.core.Package getSurroundingPackage();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.GlobalFunction#getSurroundingPackage <em>Surrounding Package</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Package</em>' container reference.
	 * @see #getSurroundingPackage()
	 * @generated
	 */
	void setSurroundingPackage(de.fzi.gast.core.Package value);

	/**
	 * Returns the value of the '<em><b>Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.functions.GlobalFunctionKind}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the kind of the global function. It can have the following values: "NORMAL" for a normal global function, "UNITINITIALIZER" for a global function which serves as unit initializer, "UNITFINALIZER" for a global function which serves as unit finalizer.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Kind</em>' attribute.
	 * @see de.fzi.gast.functions.GlobalFunctionKind
	 * @see #setKind(GlobalFunctionKind)
	 * @see de.fzi.gast.functions.functionsPackage#getGlobalFunction_Kind()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	GlobalFunctionKind getKind();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.GlobalFunction#getKind <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Kind</em>' attribute.
	 * @see de.fzi.gast.functions.GlobalFunctionKind
	 * @see #getKind()
	 * @generated
	 */
	void setKind(GlobalFunctionKind value);

} // GlobalFunction
