/**
 * <copyright>
 * </copyright>
 *
 * $Id: Function.java,v 1.5 2008/12/05 15:44:36 stammel Exp $
 */
package de.fzi.gast.functions;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.DeclarationTypeAccess;
import de.fzi.gast.accesses.ThrowTypeAccess;
import de.fzi.gast.core.NamedModelElement;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.variables.CatchParameter;
import de.fzi.gast.variables.FormalParameter;
import de.fzi.gast.variables.LocalVariable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Function</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This is the common supertype for any kind of function. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.Function#getReturnTypeDeclaration <em>Return Type Declaration</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getFormalParameters <em>Formal Parameters</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getLocalVariables <em>Local Variables</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getAllStatements <em>All Statements</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getThrowTypeAccesses <em>Throw Type Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getAccesses <em>Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getNumberOfStatements <em>Number Of Statements</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getMaximumNestingLevel <em>Maximum Nesting Level</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getLinesOfComments <em>Lines Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getNumberOfEdgesInCFG <em>Number Of Edges In CFG</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getNumberOfNodesInCFG <em>Number Of Nodes In CFG</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#isOperator <em>Operator</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getBody <em>Body</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Function#getLocalClasses <em>Local Classes</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.functions.functionsPackage#getFunction()
 * @model abstract="true"
 * @generated
 */
public interface Function extends NamedModelElement, SourceEntity {
	/**
	 * Returns the value of the '<em><b>All Statements</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.statements.Statement}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Statements</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Statements</em>' reference list.
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_AllStatements()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	EList<Statement> getAllStatements();

	/**
	 * Returns the value of the '<em><b>Throw Type Accesses</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.accesses.ThrowTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of ThrowTypeAccesses of this function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Throw Type Accesses</em>' reference list.
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_ThrowTypeAccesses()
	 * @model ordered="false"
	 * @generated
	 */
	EList<ThrowTypeAccess> getThrowTypeAccesses();

	/**
	 * Returns the value of the '<em><b>Formal Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.variables.FormalParameter}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.variables.FormalParameter#getSurroundingFunction <em>Surrounding Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of the formal parameters of the function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Formal Parameters</em>' containment reference list.
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_FormalParameters()
	 * @see de.fzi.gast.variables.FormalParameter#getSurroundingFunction
	 * @model opposite="surroundingFunction" containment="true" ordered="false"
	 * @generated
	 */
	EList<FormalParameter> getFormalParameters();

	/**
	 * Returns the value of the '<em><b>Local Variables</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.variables.LocalVariable}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.variables.LocalVariable#getSurroundingFunction <em>Surrounding Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of local variables declared within this function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Local Variables</em>' containment reference list.
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_LocalVariables()
	 * @see de.fzi.gast.variables.LocalVariable#getSurroundingFunction
	 * @model opposite="surroundingFunction" containment="true" ordered="false"
	 * @generated
	 */
	EList<LocalVariable> getLocalVariables();

	/**
	 * Returns the value of the '<em><b>Return Type Declaration</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.accesses.DeclarationTypeAccess#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a TypeAccess which points to the declared return type of the function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Return Type Declaration</em>' containment reference.
	 * @see #setReturnTypeDeclaration(DeclarationTypeAccess)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_ReturnTypeDeclaration()
	 * @see de.fzi.gast.accesses.DeclarationTypeAccess#getFunction
	 * @model opposite="function" containment="true" ordered="false"
	 * @generated
	 */
	DeclarationTypeAccess getReturnTypeDeclaration();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#getReturnTypeDeclaration <em>Return Type Declaration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Return Type Declaration</em>' containment reference.
	 * @see #getReturnTypeDeclaration()
	 * @generated
	 */
	void setReturnTypeDeclaration(DeclarationTypeAccess value);

	/**
	 * Returns the value of the '<em><b>Accesses</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.accesses.Access}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all accesses, which are contained within this function, inclusive ThrowTypeAccesses and return type declarations. It is derived from the statements within the function body and from the signature.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Accesses</em>' reference list.
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_Accesses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	EList<Access> getAccesses();

	/**
	 * Returns the value of the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of statements within this function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Number Of Statements</em>' attribute.
	 * @see #setNumberOfStatements(int)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_NumberOfStatements()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getNumberOfStatements();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#getNumberOfStatements <em>Number Of Statements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Number Of Statements</em>' attribute.
	 * @see #getNumberOfStatements()
	 * @generated
	 */
	void setNumberOfStatements(int value);

	/**
	 * Returns the value of the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the maximum nesting level of the control-flow structure within the function body, with respect to the depth of encapsulation of statements. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Maximum Nesting Level</em>' attribute.
	 * @see #setMaximumNestingLevel(int)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_MaximumNestingLevel()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getMaximumNestingLevel();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#getMaximumNestingLevel <em>Maximum Nesting Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Maximum Nesting Level</em>' attribute.
	 * @see #getMaximumNestingLevel()
	 * @generated
	 */
	void setMaximumNestingLevel(int value);

	/**
	 * Returns the value of the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of comment lines in this function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Lines Of Comments</em>' attribute.
	 * @see #setLinesOfComments(int)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_LinesOfComments()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getLinesOfComments();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#getLinesOfComments <em>Lines Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Lines Of Comments</em>' attribute.
	 * @see #getLinesOfComments()
	 * @generated
	 */
	void setLinesOfComments(int value);

	/**
	 * Returns the value of the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of code lines in this function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Lines Of Code</em>' attribute.
	 * @see #setLinesOfCode(int)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_LinesOfCode()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getLinesOfCode();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#getLinesOfCode <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Lines Of Code</em>' attribute.
	 * @see #getLinesOfCode()
	 * @generated
	 */
	void setLinesOfCode(int value);

	/**
	 * Returns the value of the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of edges in the control-flow graph of the function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Number Of Edges In CFG</em>' attribute.
	 * @see #setNumberOfEdgesInCFG(int)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_NumberOfEdgesInCFG()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getNumberOfEdgesInCFG();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#getNumberOfEdgesInCFG <em>Number Of Edges In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Number Of Edges In CFG</em>' attribute.
	 * @see #getNumberOfEdgesInCFG()
	 * @generated
	 */
	void setNumberOfEdgesInCFG(int value);

	/**
	 * Returns the value of the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of nodes in the control-flow graph of the function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Number Of Nodes In CFG</em>' attribute.
	 * @see #setNumberOfNodesInCFG(int)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_NumberOfNodesInCFG()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getNumberOfNodesInCFG();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#getNumberOfNodesInCFG <em>Number Of Nodes In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Number Of Nodes In CFG</em>' attribute.
	 * @see #getNumberOfNodesInCFG()
	 * @generated
	 */
	void setNumberOfNodesInCFG(int value);

	/**
	 * Returns the value of the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if the function is an operator. Operators are modelled as functions and their usage is modelled as FunctionAccess.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Operator</em>' attribute.
	 * @see #setOperator(boolean)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_Operator()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isOperator();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#isOperator <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operator</em>' attribute.
	 * @see #isOperator()
	 * @generated
	 */
	void setOperator(boolean value);

	/**
	 * Returns the value of the '<em><b>Body</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.BlockStatement#getSurroundingFunction <em>Surrounding Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the BlockStatement which contains the function body. This property can be empty in case of an abstract function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Body</em>' containment reference.
	 * @see #setBody(BlockStatement)
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_Body()
	 * @see de.fzi.gast.statements.BlockStatement#getSurroundingFunction
	 * @model opposite="surroundingFunction" containment="true" ordered="false"
	 * @generated
	 */
	BlockStatement getBody();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Function#getBody <em>Body</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Body</em>' containment reference.
	 * @see #getBody()
	 * @generated
	 */
	void setBody(BlockStatement value);

	/**
	 * Returns the value of the '<em><b>Local Classes</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getSurroundingFunction <em>Surrounding Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of local classes which are declared within this function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Local Classes</em>' containment reference list.
	 * @see de.fzi.gast.functions.functionsPackage#getFunction_LocalClasses()
	 * @see de.fzi.gast.types.GASTClass#getSurroundingFunction
	 * @model opposite="surroundingFunction" containment="true" ordered="false"
	 * @generated
	 */
	EList<GASTClass> getLocalClasses();

} // Function
