/**
 * <copyright>
 * </copyright>
 *
 * $Id: Destructor.java,v 1.5 2008/12/05 15:44:36 stammel Exp $
 */
package de.fzi.gast.functions;

import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Member;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Destructor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a destructor, which is called when an instance of its class is being deleted.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.Destructor#getSurroundingClass <em>Surrounding Class</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.functions.functionsPackage#getDestructor()
 * @model
 * @generated
 */
public interface Destructor extends Function, Member {
	/**
	 * Returns the value of the '<em><b>Surrounding Class</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getDestructors <em>Destructors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the class which this destructor belongs to.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Class</em>' container reference.
	 * @see #setSurroundingClass(GASTClass)
	 * @see de.fzi.gast.functions.functionsPackage#getDestructor_SurroundingClass()
	 * @see de.fzi.gast.types.GASTClass#getDestructors
	 * @model opposite="destructors" required="true" transient="false" ordered="false"
	 * @generated
	 */
	GASTClass getSurroundingClass();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Destructor#getSurroundingClass <em>Surrounding Class</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Class</em>' container reference.
	 * @see #getSurroundingClass()
	 * @generated
	 */
	void setSurroundingClass(GASTClass value);

} // Destructor
