/**
 * <copyright>
 * </copyright>
 *
 * $Id: Delegate.java,v 1.5 2008/12/05 15:44:36 stammel Exp $
 */
package de.fzi.gast.functions;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.Member;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Delegate</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a delegate which is a method to encapsulate one or more function pointers. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.Delegate#isInnerDelegate <em>Inner Delegate</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Delegate#getSuperClass <em>Super Class</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Delegate#getInvocations <em>Invocations</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Delegate#getSurroundingClass <em>Surrounding Class</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Delegate#getSurroundingPackage <em>Surrounding Package</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.functions.functionsPackage#getDelegate()
 * @model
 * @generated
 */
public interface Delegate extends Function, Member, GASTType {
	/**
	 * Returns the value of the '<em><b>Inner Delegate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this delegate is an inner class, which means that it is declared in the context of another class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inner Delegate</em>' attribute.
	 * @see #setInnerDelegate(boolean)
	 * @see de.fzi.gast.functions.functionsPackage#getDelegate_InnerDelegate()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isInnerDelegate();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Delegate#isInnerDelegate <em>Inner Delegate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inner Delegate</em>' attribute.
	 * @see #isInnerDelegate()
	 * @generated
	 */
	void setInnerDelegate(boolean value);

	/**
	 * Returns the value of the '<em><b>Super Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the common, direct super class of all delegates. This is the System.Delegate class, which is a part of the Common Language Infrastructure (CLI), Base Class Library (BCL).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Super Class</em>' reference.
	 * @see #setSuperClass(GASTClass)
	 * @see de.fzi.gast.functions.functionsPackage#getDelegate_SuperClass()
	 * @model ordered="false"
	 * @generated
	 */
	GASTClass getSuperClass();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Delegate#getSuperClass <em>Super Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Super Class</em>' reference.
	 * @see #getSuperClass()
	 * @generated
	 */
	void setSuperClass(GASTClass value);

	/**
	 * Returns the value of the '<em><b>Invocations</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.Function}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all functions which are called when this delegate is called.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Invocations</em>' reference list.
	 * @see de.fzi.gast.functions.functionsPackage#getDelegate_Invocations()
	 * @model ordered="false"
	 * @generated
	 */
	EList<Function> getInvocations();

	/**
	 * Returns the value of the '<em><b>Surrounding Class</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getInnerDelegates <em>Inner Delegates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the surrounding class of this delegate in the case of an inner delegate. Otherwise it is "null".
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Class</em>' container reference.
	 * @see #setSurroundingClass(GASTClass)
	 * @see de.fzi.gast.functions.functionsPackage#getDelegate_SurroundingClass()
	 * @see de.fzi.gast.types.GASTClass#getInnerDelegates
	 * @model opposite="innerDelegates" required="true" transient="false" ordered="false"
	 * @generated
	 */
	GASTClass getSurroundingClass();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Delegate#getSurroundingClass <em>Surrounding Class</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Class</em>' container reference.
	 * @see #getSurroundingClass()
	 * @generated
	 */
	void setSurroundingClass(GASTClass value);

	/**
	 * Returns the value of the '<em><b>Surrounding Package</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Package#getDelegates <em>Delegates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the package in which this delegate is contained.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Package</em>' container reference.
	 * @see #setSurroundingPackage(de.fzi.gast.core.Package)
	 * @see de.fzi.gast.functions.functionsPackage#getDelegate_SurroundingPackage()
	 * @see de.fzi.gast.core.Package#getDelegates
	 * @model opposite="delegates" required="true" transient="false" ordered="false"
	 * @generated
	 */
	de.fzi.gast.core.Package getSurroundingPackage();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Delegate#getSurroundingPackage <em>Surrounding Package</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Package</em>' container reference.
	 * @see #getSurroundingPackage()
	 * @generated
	 */
	void setSurroundingPackage(de.fzi.gast.core.Package value);

} // Delegate
