/**
 * <copyright>
 * </copyright>
 *
 * $Id: Constructor.java,v 1.5 2008/12/05 15:44:36 stammel Exp $
 */
package de.fzi.gast.functions;

import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Member;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Constructor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a constructor of class. A constructor is a function which is called during the instantiation of a class.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.functions.Constructor#isInitializer <em>Initializer</em>}</li>
 *   <li>{@link de.fzi.gast.functions.Constructor#getSurroundingClass <em>Surrounding Class</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.functions.functionsPackage#getConstructor()
 * @model
 * @generated
 */
public interface Constructor extends Function, Member {
	/**
	 * Returns the value of the '<em><b>Initializer</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this method represents an initializer.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Initializer</em>' attribute.
	 * @see #setInitializer(boolean)
	 * @see de.fzi.gast.functions.functionsPackage#getConstructor_Initializer()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isInitializer();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Constructor#isInitializer <em>Initializer</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Initializer</em>' attribute.
	 * @see #isInitializer()
	 * @generated
	 */
	void setInitializer(boolean value);

	/**
	 * Returns the value of the '<em><b>Surrounding Class</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getConstructors <em>Constructors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the class which this constructor belongs to.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Class</em>' container reference.
	 * @see #setSurroundingClass(GASTClass)
	 * @see de.fzi.gast.functions.functionsPackage#getConstructor_SurroundingClass()
	 * @see de.fzi.gast.types.GASTClass#getConstructors
	 * @model opposite="constructors" required="true" transient="false" ordered="false"
	 * @generated
	 */
	GASTClass getSurroundingClass();

	/**
	 * Sets the value of the '{@link de.fzi.gast.functions.Constructor#getSurroundingClass <em>Surrounding Class</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Class</em>' container reference.
	 * @see #getSurroundingClass()
	 * @generated
	 */
	void setSurroundingClass(GASTClass value);

} // Constructor
