/**
 * <copyright>
 * </copyright>
 *
 * $Id: coreValidator.java,v 1.5 2008/12/05 15:44:36 stammel Exp $
 */
package de.fzi.gast.core.util;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

import de.fzi.gast.core.Directory;
import de.fzi.gast.core.File;
import de.fzi.gast.core.GenericEntity;
import de.fzi.gast.core.Identifier;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.NamedModelElement;
import de.fzi.gast.core.PackageAlias;
import de.fzi.gast.core.Position;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.core.Status;
import de.fzi.gast.core.corePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see de.fzi.gast.core.corePackage
 * @generated
 */
public class coreValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final coreValidator INSTANCE = new coreValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "de.fzi.gast.core";

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Either Assembly File Or Source File Set' of 'Position'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int POSITION__EITHER_ASSEMBLY_FILE_OR_SOURCE_FILE_SET = 1;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Id Has To Be Unique' of 'Identifier'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int IDENTIFIER__ID_HAS_TO_BE_UNIQUE = 2;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 2;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public coreValidator() {
		super();
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return corePackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case corePackage.POSITION:
				return validatePosition((Position)value, diagnostics, context);
			case corePackage.FILE:
				return validateFile((File)value, diagnostics, context);
			case corePackage.MODEL_ELEMENT:
				return validateModelElement((ModelElement)value, diagnostics, context);
			case corePackage.IDENTIFIER:
				return validateIdentifier((Identifier)value, diagnostics, context);
			case corePackage.NAMED_MODEL_ELEMENT:
				return validateNamedModelElement((NamedModelElement)value, diagnostics, context);
			case corePackage.PACKAGE:
				return validatePackage((de.fzi.gast.core.Package)value, diagnostics, context);
			case corePackage.GENERIC_ENTITY:
				return validateGenericEntity((GenericEntity)value, diagnostics, context);
			case corePackage.ROOT:
				return validateRoot((Root)value, diagnostics, context);
			case corePackage.DIRECTORY:
				return validateDirectory((Directory)value, diagnostics, context);
			case corePackage.PACKAGE_ALIAS:
				return validatePackageAlias((PackageAlias)value, diagnostics, context);
			case corePackage.SOURCE_ENTITY:
				return validateSourceEntity((SourceEntity)value, diagnostics, context);
			case corePackage.STATUS:
				return validateStatus((Status)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePosition(Position position, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(position, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(position, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(position, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(position, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(position, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(position, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(position, diagnostics, context);
		if (result || diagnostics != null) result &= validatePosition_EitherAssemblyFileOrSourceFileSet(position, diagnostics, context);
		return result;
	}

	/**
	 * Validates the EitherAssemblyFileOrSourceFileSet constraint of '<em>Position</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePosition_EitherAssemblyFileOrSourceFileSet(Position position, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return position.EitherAssemblyFileOrSourceFileSet(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFile(File file, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(file, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(file, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(file, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(file, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(file, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(file, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(file, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(file, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateModelElement(ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(modelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(modelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(modelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(modelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(modelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(modelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(modelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(modelElement, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateIdentifier(Identifier identifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(identifier, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(identifier, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(identifier, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(identifier, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(identifier, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(identifier, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(identifier, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(identifier, diagnostics, context);
		return result;
	}

	/**
	 * Validates the idHasToBeUnique constraint of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateIdentifier_idHasToBeUnique(Identifier identifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return identifier.idHasToBeUnique(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateNamedModelElement(NamedModelElement namedModelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(namedModelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(namedModelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(namedModelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(namedModelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(namedModelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(namedModelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(namedModelElement, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(namedModelElement, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePackage(de.fzi.gast.core.Package package_, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(package_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(package_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(package_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(package_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(package_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(package_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(package_, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(package_, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateGenericEntity(GenericEntity genericEntity, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(genericEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(genericEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(genericEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(genericEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(genericEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(genericEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(genericEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(genericEntity, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateRoot(Root root, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(root, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(root, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(root, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(root, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(root, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(root, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(root, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(root, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDirectory(Directory directory, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(directory, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(directory, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(directory, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(directory, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(directory, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(directory, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(directory, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(directory, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePackageAlias(PackageAlias packageAlias, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(packageAlias, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(packageAlias, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(packageAlias, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(packageAlias, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(packageAlias, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(packageAlias, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(packageAlias, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(packageAlias, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSourceEntity(SourceEntity sourceEntity, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(sourceEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(sourceEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(sourceEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(sourceEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(sourceEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(sourceEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(sourceEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validateIdentifier_idHasToBeUnique(sourceEntity, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateStatus(Status status, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //coreValidator
