/**
 * <copyright>
 * </copyright>
 *
 * $Id: RootImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.core.impl;


import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.annotations.Clone;
import de.fzi.gast.annotations.StructuralAbstraction;
import de.fzi.gast.annotations.annotationsPackage;
import de.fzi.gast.core.Directory;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.helpers.DerivationHelper;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.typesPackage;
import de.fzi.gast.variables.GlobalVariable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Root</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getAllAccesses <em>All Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getAllInnerClasses <em>All Inner Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getAllInterfaces <em>All Interfaces</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getAllLocalClasses <em>All Local Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getAllNormalClasses <em>All Normal Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getAllModelElements <em>All Model Elements</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getLinesOfComments <em>Lines Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getGlobalFunctions <em>Global Functions</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getGlobalVariables <em>Global Variables</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getClones <em>Clones</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getStructuralAbstractions <em>Structural Abstractions</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getTypes <em>Types</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getDanglingModelElements <em>Dangling Model Elements</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getDirectories <em>Directories</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.RootImpl#getPackages <em>Packages</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RootImpl extends ModelElementImpl implements Root {
	/**
	 * The default value of the '{@link #getLinesOfComments() <em>Lines Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfComments()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_COMMENTS_EDEFAULT = 0;

	/**
	 * The default value of the '{@link #getLinesOfCode() <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfCode()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_CODE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getGlobalFunctions() <em>Global Functions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGlobalFunctions()
	 * @generated
	 * @ordered
	 */
	protected EList<GlobalFunction> globalFunctions;

	/**
	 * The cached value of the '{@link #getGlobalVariables() <em>Global Variables</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGlobalVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<GlobalVariable> globalVariables;

	/**
	 * The cached value of the '{@link #getClones() <em>Clones</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClones()
	 * @generated
	 * @ordered
	 */
	protected EList<Clone> clones;

	/**
	 * The cached value of the '{@link #getStructuralAbstractions() <em>Structural Abstractions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStructuralAbstractions()
	 * @generated
	 * @ordered
	 */
	protected EList<StructuralAbstraction> structuralAbstractions;

	/**
	 * The cached value of the '{@link #getTypes() <em>Types</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<GASTType> types;

	/**
	 * The cached value of the '{@link #getDanglingModelElements() <em>Dangling Model Elements</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDanglingModelElements()
	 * @generated
	 * @ordered
	 */
	protected EList<ModelElement> danglingModelElements;

	/**
	 * The cached value of the '{@link #getDirectories() <em>Directories</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDirectories()
	 * @generated
	 * @ordered
	 */
	protected EList<Directory> directories;

	/**
	 * The cached value of the '{@link #getPackages() <em>Packages</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPackages()
	 * @generated
	 * @ordered
	 */
	protected EList<de.fzi.gast.core.Package> packages;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RootImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return corePackage.Literals.ROOT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Access> getAllAccesses() {
		return DerivationHelper.getAllAccesses(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllInnerClasses() {
		return DerivationHelper.getAllClasses(this,typesPackage.GAST_CLASS__INNER_CLASSES);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllInterfaces() {
		return DerivationHelper.getAllClasses(this, typesPackage.GAST_CLASS__INTERFACE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllLocalClasses() {
		return DerivationHelper.getAllClasses(this,typesPackage.GAST_CLASS__LOCAL );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllNormalClasses() {
		return DerivationHelper.getAllClasses(this,0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<ModelElement> getAllModelElements() {
		return DerivationHelper.getAllModelElements(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */ 
	public int getLinesOfComments() {
		return DerivationHelper.getLinesOfComments(this);
	}

		
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setLinesOfComments(int newLinesOfComments) {

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void unsetLinesOfComments() {

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetLinesOfComments() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getLinesOfCode() {
		return DerivationHelper.getLinesOfCode(this);
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setLinesOfCode(int newLinesOfCode) {

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void unsetLinesOfCode() {

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetLinesOfCode() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GlobalFunction> getGlobalFunctions() {
		if (globalFunctions == null) {
			globalFunctions = new EObjectContainmentEList<GlobalFunction>(GlobalFunction.class, this, corePackage.ROOT__GLOBAL_FUNCTIONS);
		}
		return globalFunctions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GlobalVariable> getGlobalVariables() {
		if (globalVariables == null) {
			globalVariables = new EObjectContainmentEList<GlobalVariable>(GlobalVariable.class, this, corePackage.ROOT__GLOBAL_VARIABLES);
		}
		return globalVariables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Clone> getClones() {
		if (clones == null) {
			clones = new EObjectContainmentWithInverseEList<Clone>(Clone.class, this, corePackage.ROOT__CLONES, annotationsPackage.CLONE__ROOT);
		}
		return clones;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<StructuralAbstraction> getStructuralAbstractions() {
		if (structuralAbstractions == null) {
			structuralAbstractions = new EObjectContainmentEList<StructuralAbstraction>(StructuralAbstraction.class, this, corePackage.ROOT__STRUCTURAL_ABSTRACTIONS);
		}
		return structuralAbstractions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GASTType> getTypes() {
		if (types == null) {
			types = new EObjectContainmentEList<GASTType>(GASTType.class, this, corePackage.ROOT__TYPES);
		}
		return types;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ModelElement> getDanglingModelElements() {
		if (danglingModelElements == null) {
			danglingModelElements = new EObjectContainmentEList<ModelElement>(ModelElement.class, this, corePackage.ROOT__DANGLING_MODEL_ELEMENTS);
		}
		return danglingModelElements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Directory> getDirectories() {
		if (directories == null) {
			directories = new EObjectContainmentWithInverseEList<Directory>(Directory.class, this, corePackage.ROOT__DIRECTORIES, corePackage.DIRECTORY__ROOT);
		}
		return directories;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<de.fzi.gast.core.Package> getPackages() {
		if (packages == null) {
			packages = new EObjectContainmentWithInverseEList<de.fzi.gast.core.Package>(de.fzi.gast.core.Package.class, this, corePackage.ROOT__PACKAGES, corePackage.PACKAGE__ROOT);
		}
		return packages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GASTClass getClassByQualifiedName(String name) {
		return DerivationHelper.getClassByQualifiedName(this,name);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public de.fzi.gast.core.Package getPackageByQualifiedName(String qualifiedname) {
		return DerivationHelper.getPackageByQualifiedName(this,qualifiedname);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public de.fzi.gast.core.Package getPackageByName(String name) {

		return DerivationHelper.getPackageByName(this,name);
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.ROOT__CLONES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getClones()).basicAdd(otherEnd, msgs);
			case corePackage.ROOT__DIRECTORIES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDirectories()).basicAdd(otherEnd, msgs);
			case corePackage.ROOT__PACKAGES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getPackages()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.ROOT__GLOBAL_FUNCTIONS:
				return ((InternalEList<?>)getGlobalFunctions()).basicRemove(otherEnd, msgs);
			case corePackage.ROOT__GLOBAL_VARIABLES:
				return ((InternalEList<?>)getGlobalVariables()).basicRemove(otherEnd, msgs);
			case corePackage.ROOT__CLONES:
				return ((InternalEList<?>)getClones()).basicRemove(otherEnd, msgs);
			case corePackage.ROOT__STRUCTURAL_ABSTRACTIONS:
				return ((InternalEList<?>)getStructuralAbstractions()).basicRemove(otherEnd, msgs);
			case corePackage.ROOT__TYPES:
				return ((InternalEList<?>)getTypes()).basicRemove(otherEnd, msgs);
			case corePackage.ROOT__DANGLING_MODEL_ELEMENTS:
				return ((InternalEList<?>)getDanglingModelElements()).basicRemove(otherEnd, msgs);
			case corePackage.ROOT__DIRECTORIES:
				return ((InternalEList<?>)getDirectories()).basicRemove(otherEnd, msgs);
			case corePackage.ROOT__PACKAGES:
				return ((InternalEList<?>)getPackages()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case corePackage.ROOT__ALL_ACCESSES:
				return getAllAccesses();
			case corePackage.ROOT__ALL_INNER_CLASSES:
				return getAllInnerClasses();
			case corePackage.ROOT__ALL_INTERFACES:
				return getAllInterfaces();
			case corePackage.ROOT__ALL_LOCAL_CLASSES:
				return getAllLocalClasses();
			case corePackage.ROOT__ALL_NORMAL_CLASSES:
				return getAllNormalClasses();
			case corePackage.ROOT__ALL_MODEL_ELEMENTS:
				return getAllModelElements();
			case corePackage.ROOT__LINES_OF_COMMENTS:
				return getLinesOfComments();
			case corePackage.ROOT__LINES_OF_CODE:
				return getLinesOfCode();
			case corePackage.ROOT__GLOBAL_FUNCTIONS:
				return getGlobalFunctions();
			case corePackage.ROOT__GLOBAL_VARIABLES:
				return getGlobalVariables();
			case corePackage.ROOT__CLONES:
				return getClones();
			case corePackage.ROOT__STRUCTURAL_ABSTRACTIONS:
				return getStructuralAbstractions();
			case corePackage.ROOT__TYPES:
				return getTypes();
			case corePackage.ROOT__DANGLING_MODEL_ELEMENTS:
				return getDanglingModelElements();
			case corePackage.ROOT__DIRECTORIES:
				return getDirectories();
			case corePackage.ROOT__PACKAGES:
				return getPackages();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case corePackage.ROOT__GLOBAL_FUNCTIONS:
				getGlobalFunctions().clear();
				getGlobalFunctions().addAll((Collection<? extends GlobalFunction>)newValue);
				return;
			case corePackage.ROOT__GLOBAL_VARIABLES:
				getGlobalVariables().clear();
				getGlobalVariables().addAll((Collection<? extends GlobalVariable>)newValue);
				return;
			case corePackage.ROOT__CLONES:
				getClones().clear();
				getClones().addAll((Collection<? extends Clone>)newValue);
				return;
			case corePackage.ROOT__STRUCTURAL_ABSTRACTIONS:
				getStructuralAbstractions().clear();
				getStructuralAbstractions().addAll((Collection<? extends StructuralAbstraction>)newValue);
				return;
			case corePackage.ROOT__TYPES:
				getTypes().clear();
				getTypes().addAll((Collection<? extends GASTType>)newValue);
				return;
			case corePackage.ROOT__DANGLING_MODEL_ELEMENTS:
				getDanglingModelElements().clear();
				getDanglingModelElements().addAll((Collection<? extends ModelElement>)newValue);
				return;
			case corePackage.ROOT__DIRECTORIES:
				getDirectories().clear();
				getDirectories().addAll((Collection<? extends Directory>)newValue);
				return;
			case corePackage.ROOT__PACKAGES:
				getPackages().clear();
				getPackages().addAll((Collection<? extends de.fzi.gast.core.Package>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case corePackage.ROOT__GLOBAL_FUNCTIONS:
				getGlobalFunctions().clear();
				return;
			case corePackage.ROOT__GLOBAL_VARIABLES:
				getGlobalVariables().clear();
				return;
			case corePackage.ROOT__CLONES:
				getClones().clear();
				return;
			case corePackage.ROOT__STRUCTURAL_ABSTRACTIONS:
				getStructuralAbstractions().clear();
				return;
			case corePackage.ROOT__TYPES:
				getTypes().clear();
				return;
			case corePackage.ROOT__DANGLING_MODEL_ELEMENTS:
				getDanglingModelElements().clear();
				return;
			case corePackage.ROOT__DIRECTORIES:
				getDirectories().clear();
				return;
			case corePackage.ROOT__PACKAGES:
				getPackages().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case corePackage.ROOT__ALL_ACCESSES:
				return !getAllAccesses().isEmpty();
			case corePackage.ROOT__ALL_INNER_CLASSES:
				return !getAllInnerClasses().isEmpty();
			case corePackage.ROOT__ALL_INTERFACES:
				return !getAllInterfaces().isEmpty();
			case corePackage.ROOT__ALL_LOCAL_CLASSES:
				return !getAllLocalClasses().isEmpty();
			case corePackage.ROOT__ALL_NORMAL_CLASSES:
				return !getAllNormalClasses().isEmpty();
			case corePackage.ROOT__ALL_MODEL_ELEMENTS:
				return !getAllModelElements().isEmpty();
			case corePackage.ROOT__LINES_OF_COMMENTS:
				return getLinesOfComments() != LINES_OF_COMMENTS_EDEFAULT;
			case corePackage.ROOT__LINES_OF_CODE:
				return getLinesOfCode() != LINES_OF_CODE_EDEFAULT;
			case corePackage.ROOT__GLOBAL_FUNCTIONS:
				return globalFunctions != null && !globalFunctions.isEmpty();
			case corePackage.ROOT__GLOBAL_VARIABLES:
				return globalVariables != null && !globalVariables.isEmpty();
			case corePackage.ROOT__CLONES:
				return clones != null && !clones.isEmpty();
			case corePackage.ROOT__STRUCTURAL_ABSTRACTIONS:
				return structuralAbstractions != null && !structuralAbstractions.isEmpty();
			case corePackage.ROOT__TYPES:
				return types != null && !types.isEmpty();
			case corePackage.ROOT__DANGLING_MODEL_ELEMENTS:
				return danglingModelElements != null && !danglingModelElements.isEmpty();
			case corePackage.ROOT__DIRECTORIES:
				return directories != null && !directories.isEmpty();
			case corePackage.ROOT__PACKAGES:
				return packages != null && !packages.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //RootImpl
