/**
 * <copyright>
 * </copyright>
 *
 * $Id: PositionImpl.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.core.impl;

import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.core.File;
import de.fzi.gast.core.Position;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.core.util.coreValidator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Position</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.core.impl.PositionImpl#getEndColumn <em>End Column</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PositionImpl#getStartColumn <em>Start Column</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PositionImpl#getEndLine <em>End Line</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PositionImpl#getStartLine <em>Start Line</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PositionImpl#getSourceFile <em>Source File</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PositionImpl#getAssembly <em>Assembly</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PositionImpl#getSourceentity <em>Sourceentity</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PositionImpl extends EObjectImpl implements Position {
	/**
	 * The default value of the '{@link #getEndColumn() <em>End Column</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndColumn()
	 * @generated
	 * @ordered
	 */
	protected static final int END_COLUMN_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getEndColumn() <em>End Column</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndColumn()
	 * @generated
	 * @ordered
	 */
	protected int endColumn = END_COLUMN_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartColumn() <em>Start Column</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartColumn()
	 * @generated
	 * @ordered
	 */
	protected static final int START_COLUMN_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getStartColumn() <em>Start Column</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartColumn()
	 * @generated
	 * @ordered
	 */
	protected int startColumn = START_COLUMN_EDEFAULT;

	/**
	 * The default value of the '{@link #getEndLine() <em>End Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndLine()
	 * @generated
	 * @ordered
	 */
	protected static final int END_LINE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getEndLine() <em>End Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndLine()
	 * @generated
	 * @ordered
	 */
	protected int endLine = END_LINE_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartLine() <em>Start Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartLine()
	 * @generated
	 * @ordered
	 */
	protected static final int START_LINE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getStartLine() <em>Start Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartLine()
	 * @generated
	 * @ordered
	 */
	protected int startLine = START_LINE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSourceFile() <em>Source File</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceFile()
	 * @generated
	 * @ordered
	 */
	protected File sourceFile;

	/**
	 * The cached value of the '{@link #getAssembly() <em>Assembly</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssembly()
	 * @generated
	 * @ordered
	 */
	protected File assembly;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PositionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return corePackage.Literals.POSITION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getEndColumn() {
		return endColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEndColumn(int newEndColumn) {
		int oldEndColumn = endColumn;
		endColumn = newEndColumn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.POSITION__END_COLUMN, oldEndColumn, endColumn));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getStartColumn() {
		return startColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartColumn(int newStartColumn) {
		int oldStartColumn = startColumn;
		startColumn = newStartColumn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.POSITION__START_COLUMN, oldStartColumn, startColumn));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getEndLine() {
		return endLine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEndLine(int newEndLine) {
		int oldEndLine = endLine;
		endLine = newEndLine;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.POSITION__END_LINE, oldEndLine, endLine));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getStartLine() {
		return startLine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartLine(int newStartLine) {
		int oldStartLine = startLine;
		startLine = newStartLine;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.POSITION__START_LINE, oldStartLine, startLine));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public File getSourceFile() {
		if (sourceFile != null && sourceFile.eIsProxy()) {
			InternalEObject oldSourceFile = (InternalEObject)sourceFile;
			sourceFile = (File)eResolveProxy(oldSourceFile);
			if (sourceFile != oldSourceFile) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, corePackage.POSITION__SOURCE_FILE, oldSourceFile, sourceFile));
			}
		}
		return sourceFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public File basicGetSourceFile() {
		return sourceFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceFile(File newSourceFile) {
		File oldSourceFile = sourceFile;
		sourceFile = newSourceFile;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.POSITION__SOURCE_FILE, oldSourceFile, sourceFile));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public File getAssembly() {
		if (assembly != null && assembly.eIsProxy()) {
			InternalEObject oldAssembly = (InternalEObject)assembly;
			assembly = (File)eResolveProxy(oldAssembly);
			if (assembly != oldAssembly) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, corePackage.POSITION__ASSEMBLY, oldAssembly, assembly));
			}
		}
		return assembly;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public File basicGetAssembly() {
		return assembly;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAssembly(File newAssembly) {
		File oldAssembly = assembly;
		assembly = newAssembly;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.POSITION__ASSEMBLY, oldAssembly, assembly));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SourceEntity getSourceentity() {
		if (eContainerFeatureID() != corePackage.POSITION__SOURCEENTITY) return null;
		return (SourceEntity)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSourceentity(SourceEntity newSourceentity, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSourceentity, corePackage.POSITION__SOURCEENTITY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceentity(SourceEntity newSourceentity) {
		if (newSourceentity != eInternalContainer() || (eContainerFeatureID() != corePackage.POSITION__SOURCEENTITY && newSourceentity != null)) {
			if (EcoreUtil.isAncestor(this, newSourceentity))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSourceentity != null)
				msgs = ((InternalEObject)newSourceentity).eInverseAdd(this, corePackage.SOURCE_ENTITY__POSITION, SourceEntity.class, msgs);
			msgs = basicSetSourceentity(newSourceentity, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.POSITION__SOURCEENTITY, newSourceentity, newSourceentity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean EitherAssemblyFileOrSourceFileSet(DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO: implement this method
		// -> specify the condition that violates the invariant
		// -> verify the details of the diagnostic, including severity and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 coreValidator.DIAGNOSTIC_SOURCE,
						 coreValidator.POSITION__EITHER_ASSEMBLY_FILE_OR_SOURCE_FILE_SET,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "EitherAssemblyFileOrSourceFileSet", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.POSITION__SOURCEENTITY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSourceentity((SourceEntity)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.POSITION__SOURCEENTITY:
				return basicSetSourceentity(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case corePackage.POSITION__SOURCEENTITY:
				return eInternalContainer().eInverseRemove(this, corePackage.SOURCE_ENTITY__POSITION, SourceEntity.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case corePackage.POSITION__END_COLUMN:
				return getEndColumn();
			case corePackage.POSITION__START_COLUMN:
				return getStartColumn();
			case corePackage.POSITION__END_LINE:
				return getEndLine();
			case corePackage.POSITION__START_LINE:
				return getStartLine();
			case corePackage.POSITION__SOURCE_FILE:
				if (resolve) return getSourceFile();
				return basicGetSourceFile();
			case corePackage.POSITION__ASSEMBLY:
				if (resolve) return getAssembly();
				return basicGetAssembly();
			case corePackage.POSITION__SOURCEENTITY:
				return getSourceentity();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case corePackage.POSITION__END_COLUMN:
				setEndColumn((Integer)newValue);
				return;
			case corePackage.POSITION__START_COLUMN:
				setStartColumn((Integer)newValue);
				return;
			case corePackage.POSITION__END_LINE:
				setEndLine((Integer)newValue);
				return;
			case corePackage.POSITION__START_LINE:
				setStartLine((Integer)newValue);
				return;
			case corePackage.POSITION__SOURCE_FILE:
				setSourceFile((File)newValue);
				return;
			case corePackage.POSITION__ASSEMBLY:
				setAssembly((File)newValue);
				return;
			case corePackage.POSITION__SOURCEENTITY:
				setSourceentity((SourceEntity)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case corePackage.POSITION__END_COLUMN:
				setEndColumn(END_COLUMN_EDEFAULT);
				return;
			case corePackage.POSITION__START_COLUMN:
				setStartColumn(START_COLUMN_EDEFAULT);
				return;
			case corePackage.POSITION__END_LINE:
				setEndLine(END_LINE_EDEFAULT);
				return;
			case corePackage.POSITION__START_LINE:
				setStartLine(START_LINE_EDEFAULT);
				return;
			case corePackage.POSITION__SOURCE_FILE:
				setSourceFile((File)null);
				return;
			case corePackage.POSITION__ASSEMBLY:
				setAssembly((File)null);
				return;
			case corePackage.POSITION__SOURCEENTITY:
				setSourceentity((SourceEntity)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case corePackage.POSITION__END_COLUMN:
				return endColumn != END_COLUMN_EDEFAULT;
			case corePackage.POSITION__START_COLUMN:
				return startColumn != START_COLUMN_EDEFAULT;
			case corePackage.POSITION__END_LINE:
				return endLine != END_LINE_EDEFAULT;
			case corePackage.POSITION__START_LINE:
				return startLine != START_LINE_EDEFAULT;
			case corePackage.POSITION__SOURCE_FILE:
				return sourceFile != null;
			case corePackage.POSITION__ASSEMBLY:
				return assembly != null;
			case corePackage.POSITION__SOURCEENTITY:
				return getSourceentity() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (endColumn: ");
		result.append(endColumn);
		result.append(", startColumn: ");
		result.append(startColumn);
		result.append(", endLine: ");
		result.append(endLine);
		result.append(", startLine: ");
		result.append(startLine);
		result.append(')');
		return result.toString();
	}

} //PositionImpl
