/**
 * <copyright>
 * </copyright>
 *
 * $Id: PackageImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.core.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.functions.Delegate;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.helpers.DerivationHelper;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.TypeAlias;
import de.fzi.gast.types.typesPackage;
import de.fzi.gast.variables.GlobalVariable;
import de.fzi.gast.variables.variablesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Package</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getAllLocalClasses <em>All Local Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getAllInnerClasses <em>All Inner Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getAllNormalClasses <em>All Normal Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getAllInterfaces <em>All Interfaces</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getAllAccesses <em>All Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getDelegates <em>Delegates</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getGlobalFunctions <em>Global Functions</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getGlobalVariables <em>Global Variables</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getLinesOfComments <em>Lines Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getQualifiedName <em>Qualified Name</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getClasses <em>Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getSubPackages <em>Sub Packages</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getSurroundingPackage <em>Surrounding Package</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getRoot <em>Root</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getAllAccessedPackages <em>All Accessed Packages</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.PackageImpl#getTypeAliases <em>Type Aliases</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PackageImpl extends NamedModelElementImpl implements de.fzi.gast.core.Package {
	
	/**
	 * caching
	 * @generated NOT
	 */	
	private String cachedQualifiedName; 
	
	/**
	 * The cached value of the '{@link #getDelegates() <em>Delegates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDelegates()
	 * @generated
	 * @ordered
	 */
	protected EList<Delegate> delegates;

	/**
	 * The cached value of the '{@link #getGlobalFunctions() <em>Global Functions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGlobalFunctions()
	 * @generated
	 * @ordered
	 */
	protected EList<GlobalFunction> globalFunctions;

	/**
	 * The cached value of the '{@link #getGlobalVariables() <em>Global Variables</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGlobalVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<GlobalVariable> globalVariables;

	/**
	 * The default value of the '{@link #getLinesOfComments() <em>Lines Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfComments()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_COMMENTS_EDEFAULT = 0;

	/**
	 * The default value of the '{@link #getLinesOfCode() <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfCode()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_CODE_EDEFAULT = 0;

	/**
	 * The default value of the '{@link #getQualifiedName() <em>Qualified Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQualifiedName()
	 * @generated
	 * @ordered
	 */
	protected static final String QUALIFIED_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getClasses() <em>Classes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClasses()
	 * @generated
	 * @ordered
	 */
	protected EList<GASTClass> classes;

	/**
	 * The cached value of the '{@link #getSubPackages() <em>Sub Packages</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubPackages()
	 * @generated
	 * @ordered
	 */
	protected EList<de.fzi.gast.core.Package> subPackages;

	/**
	 * The cached value of the '{@link #getTypeAliases() <em>Type Aliases</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeAliases()
	 * @generated
	 * @ordered
	 */
	protected EList<TypeAlias> typeAliases;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return corePackage.Literals.PACKAGE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllLocalClasses() {
		return DerivationHelper.getAllClasses(this,typesPackage.GAST_CLASS__LOCAL );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllInnerClasses() {
		return DerivationHelper.getAllClasses(this, typesPackage.GAST_CLASS__INNER_CLASSES );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllNormalClasses() {
		return DerivationHelper.getAllClasses(this,0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllInterfaces() {
		return DerivationHelper.getAllClasses(this, typesPackage.GAST_CLASS__INTERFACE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Access> getAllAccesses() {
		return DerivationHelper.getAllAccesses(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getLinesOfComments() {
		return DerivationHelper.getLinesOfComments(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setLinesOfComments(int newLinesOfComments) {

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void unsetLinesOfComments() {

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetLinesOfComments() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getLinesOfCode() {
		return DerivationHelper.getLinesOfCode(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setLinesOfCode(int newLinesOfCode) {
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void unsetLinesOfCode() {
	
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetLinesOfCode() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getQualifiedName() {
		String qualifiedName;
		if(cachedQualifiedName == null) {
			if (getSurroundingPackage()!=null) {
				qualifiedName = getSurroundingPackage().getQualifiedName()+"."+this.getSimpleName();
			} else {
				qualifiedName = this.getSimpleName();
			}
			this.cachedQualifiedName = qualifiedName;
		} else {
			qualifiedName = cachedQualifiedName;
		}
		return qualifiedName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetQualifiedName() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Delegate> getDelegates() {
		if (delegates == null) {
			delegates = new EObjectContainmentWithInverseEList<Delegate>(Delegate.class, this, corePackage.PACKAGE__DELEGATES, functionsPackage.DELEGATE__SURROUNDING_PACKAGE);
		}
		return delegates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GlobalVariable> getGlobalVariables() {
		if (globalVariables == null) {
			globalVariables = new EObjectContainmentWithInverseEList<GlobalVariable>(GlobalVariable.class, this, corePackage.PACKAGE__GLOBAL_VARIABLES, variablesPackage.GLOBAL_VARIABLE__SURROUNDING_PACKAGE);
		}
		return globalVariables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GlobalFunction> getGlobalFunctions() {
		if (globalFunctions == null) {
			globalFunctions = new EObjectContainmentWithInverseEList<GlobalFunction>(GlobalFunction.class, this, corePackage.PACKAGE__GLOBAL_FUNCTIONS, functionsPackage.GLOBAL_FUNCTION__SURROUNDING_PACKAGE);
		}
		return globalFunctions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GASTClass> getClasses() {
		if (classes == null) {
			classes = new EObjectContainmentWithInverseEList<GASTClass>(GASTClass.class, this, corePackage.PACKAGE__CLASSES, typesPackage.GAST_CLASS__SURROUNDING_PACKAGE);
		}
		return classes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<de.fzi.gast.core.Package> getSubPackages() {
		if (subPackages == null) {
			subPackages = new EObjectContainmentWithInverseEList<de.fzi.gast.core.Package>(de.fzi.gast.core.Package.class, this, corePackage.PACKAGE__SUB_PACKAGES, corePackage.PACKAGE__SURROUNDING_PACKAGE);
		}
		return subPackages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public de.fzi.gast.core.Package getSurroundingPackage() {
		if (eContainerFeatureID() != corePackage.PACKAGE__SURROUNDING_PACKAGE) return null;
		return (de.fzi.gast.core.Package)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingPackage(de.fzi.gast.core.Package newSurroundingPackage, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingPackage, corePackage.PACKAGE__SURROUNDING_PACKAGE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingPackage(de.fzi.gast.core.Package newSurroundingPackage) {
		if (newSurroundingPackage != eInternalContainer() || (eContainerFeatureID() != corePackage.PACKAGE__SURROUNDING_PACKAGE && newSurroundingPackage != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingPackage))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingPackage != null)
				msgs = ((InternalEObject)newSurroundingPackage).eInverseAdd(this, corePackage.PACKAGE__SUB_PACKAGES, de.fzi.gast.core.Package.class, msgs);
			msgs = basicSetSurroundingPackage(newSurroundingPackage, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.PACKAGE__SURROUNDING_PACKAGE, newSurroundingPackage, newSurroundingPackage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Root getRoot() {
		if (eContainerFeatureID() != corePackage.PACKAGE__ROOT) return null;
		return (Root)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRoot(Root newRoot, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newRoot, corePackage.PACKAGE__ROOT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRoot(Root newRoot) {
		if (newRoot != eInternalContainer() || (eContainerFeatureID() != corePackage.PACKAGE__ROOT && newRoot != null)) {
			if (EcoreUtil.isAncestor(this, newRoot))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newRoot != null)
				msgs = ((InternalEObject)newRoot).eInverseAdd(this, corePackage.ROOT__PACKAGES, Root.class, msgs);
			msgs = basicSetRoot(newRoot, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.PACKAGE__ROOT, newRoot, newRoot));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<de.fzi.gast.core.Package> getAllAccessedPackages() {
		return DerivationHelper.getAllAccessedPackages(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TypeAlias> getTypeAliases() {
		if (typeAliases == null) {
			typeAliases = new EObjectContainmentWithInverseEList<TypeAlias>(TypeAlias.class, this, corePackage.PACKAGE__TYPE_ALIASES, typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE);
		}
		return typeAliases;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.PACKAGE__DELEGATES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDelegates()).basicAdd(otherEnd, msgs);
			case corePackage.PACKAGE__GLOBAL_FUNCTIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getGlobalFunctions()).basicAdd(otherEnd, msgs);
			case corePackage.PACKAGE__GLOBAL_VARIABLES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getGlobalVariables()).basicAdd(otherEnd, msgs);
			case corePackage.PACKAGE__CLASSES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getClasses()).basicAdd(otherEnd, msgs);
			case corePackage.PACKAGE__SUB_PACKAGES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSubPackages()).basicAdd(otherEnd, msgs);
			case corePackage.PACKAGE__SURROUNDING_PACKAGE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingPackage((de.fzi.gast.core.Package)otherEnd, msgs);
			case corePackage.PACKAGE__ROOT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetRoot((Root)otherEnd, msgs);
			case corePackage.PACKAGE__TYPE_ALIASES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getTypeAliases()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.PACKAGE__DELEGATES:
				return ((InternalEList<?>)getDelegates()).basicRemove(otherEnd, msgs);
			case corePackage.PACKAGE__GLOBAL_FUNCTIONS:
				return ((InternalEList<?>)getGlobalFunctions()).basicRemove(otherEnd, msgs);
			case corePackage.PACKAGE__GLOBAL_VARIABLES:
				return ((InternalEList<?>)getGlobalVariables()).basicRemove(otherEnd, msgs);
			case corePackage.PACKAGE__CLASSES:
				return ((InternalEList<?>)getClasses()).basicRemove(otherEnd, msgs);
			case corePackage.PACKAGE__SUB_PACKAGES:
				return ((InternalEList<?>)getSubPackages()).basicRemove(otherEnd, msgs);
			case corePackage.PACKAGE__SURROUNDING_PACKAGE:
				return basicSetSurroundingPackage(null, msgs);
			case corePackage.PACKAGE__ROOT:
				return basicSetRoot(null, msgs);
			case corePackage.PACKAGE__TYPE_ALIASES:
				return ((InternalEList<?>)getTypeAliases()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case corePackage.PACKAGE__SURROUNDING_PACKAGE:
				return eInternalContainer().eInverseRemove(this, corePackage.PACKAGE__SUB_PACKAGES, de.fzi.gast.core.Package.class, msgs);
			case corePackage.PACKAGE__ROOT:
				return eInternalContainer().eInverseRemove(this, corePackage.ROOT__PACKAGES, Root.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case corePackage.PACKAGE__ALL_LOCAL_CLASSES:
				return getAllLocalClasses();
			case corePackage.PACKAGE__ALL_INNER_CLASSES:
				return getAllInnerClasses();
			case corePackage.PACKAGE__ALL_NORMAL_CLASSES:
				return getAllNormalClasses();
			case corePackage.PACKAGE__ALL_INTERFACES:
				return getAllInterfaces();
			case corePackage.PACKAGE__ALL_ACCESSES:
				return getAllAccesses();
			case corePackage.PACKAGE__DELEGATES:
				return getDelegates();
			case corePackage.PACKAGE__GLOBAL_FUNCTIONS:
				return getGlobalFunctions();
			case corePackage.PACKAGE__GLOBAL_VARIABLES:
				return getGlobalVariables();
			case corePackage.PACKAGE__LINES_OF_COMMENTS:
				return getLinesOfComments();
			case corePackage.PACKAGE__LINES_OF_CODE:
				return getLinesOfCode();
			case corePackage.PACKAGE__QUALIFIED_NAME:
				return getQualifiedName();
			case corePackage.PACKAGE__CLASSES:
				return getClasses();
			case corePackage.PACKAGE__SUB_PACKAGES:
				return getSubPackages();
			case corePackage.PACKAGE__SURROUNDING_PACKAGE:
				return getSurroundingPackage();
			case corePackage.PACKAGE__ROOT:
				return getRoot();
			case corePackage.PACKAGE__ALL_ACCESSED_PACKAGES:
				return getAllAccessedPackages();
			case corePackage.PACKAGE__TYPE_ALIASES:
				return getTypeAliases();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case corePackage.PACKAGE__DELEGATES:
				getDelegates().clear();
				getDelegates().addAll((Collection<? extends Delegate>)newValue);
				return;
			case corePackage.PACKAGE__GLOBAL_FUNCTIONS:
				getGlobalFunctions().clear();
				getGlobalFunctions().addAll((Collection<? extends GlobalFunction>)newValue);
				return;
			case corePackage.PACKAGE__GLOBAL_VARIABLES:
				getGlobalVariables().clear();
				getGlobalVariables().addAll((Collection<? extends GlobalVariable>)newValue);
				return;
			case corePackage.PACKAGE__CLASSES:
				getClasses().clear();
				getClasses().addAll((Collection<? extends GASTClass>)newValue);
				return;
			case corePackage.PACKAGE__SUB_PACKAGES:
				getSubPackages().clear();
				getSubPackages().addAll((Collection<? extends de.fzi.gast.core.Package>)newValue);
				return;
			case corePackage.PACKAGE__SURROUNDING_PACKAGE:
				setSurroundingPackage((de.fzi.gast.core.Package)newValue);
				return;
			case corePackage.PACKAGE__ROOT:
				setRoot((Root)newValue);
				return;
			case corePackage.PACKAGE__TYPE_ALIASES:
				getTypeAliases().clear();
				getTypeAliases().addAll((Collection<? extends TypeAlias>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case corePackage.PACKAGE__DELEGATES:
				getDelegates().clear();
				return;
			case corePackage.PACKAGE__GLOBAL_FUNCTIONS:
				getGlobalFunctions().clear();
				return;
			case corePackage.PACKAGE__GLOBAL_VARIABLES:
				getGlobalVariables().clear();
				return;
			case corePackage.PACKAGE__CLASSES:
				getClasses().clear();
				return;
			case corePackage.PACKAGE__SUB_PACKAGES:
				getSubPackages().clear();
				return;
			case corePackage.PACKAGE__SURROUNDING_PACKAGE:
				setSurroundingPackage((de.fzi.gast.core.Package)null);
				return;
			case corePackage.PACKAGE__ROOT:
				setRoot((Root)null);
				return;
			case corePackage.PACKAGE__TYPE_ALIASES:
				getTypeAliases().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case corePackage.PACKAGE__ALL_LOCAL_CLASSES:
				return !getAllLocalClasses().isEmpty();
			case corePackage.PACKAGE__ALL_INNER_CLASSES:
				return !getAllInnerClasses().isEmpty();
			case corePackage.PACKAGE__ALL_NORMAL_CLASSES:
				return !getAllNormalClasses().isEmpty();
			case corePackage.PACKAGE__ALL_INTERFACES:
				return !getAllInterfaces().isEmpty();
			case corePackage.PACKAGE__ALL_ACCESSES:
				return !getAllAccesses().isEmpty();
			case corePackage.PACKAGE__DELEGATES:
				return delegates != null && !delegates.isEmpty();
			case corePackage.PACKAGE__GLOBAL_FUNCTIONS:
				return globalFunctions != null && !globalFunctions.isEmpty();
			case corePackage.PACKAGE__GLOBAL_VARIABLES:
				return globalVariables != null && !globalVariables.isEmpty();
			case corePackage.PACKAGE__LINES_OF_COMMENTS:
				return getLinesOfComments() != LINES_OF_COMMENTS_EDEFAULT;
			case corePackage.PACKAGE__LINES_OF_CODE:
				return getLinesOfCode() != LINES_OF_CODE_EDEFAULT;
			case corePackage.PACKAGE__QUALIFIED_NAME:
				return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
			case corePackage.PACKAGE__CLASSES:
				return classes != null && !classes.isEmpty();
			case corePackage.PACKAGE__SUB_PACKAGES:
				return subPackages != null && !subPackages.isEmpty();
			case corePackage.PACKAGE__SURROUNDING_PACKAGE:
				return getSurroundingPackage() != null;
			case corePackage.PACKAGE__ROOT:
				return getRoot() != null;
			case corePackage.PACKAGE__ALL_ACCESSED_PACKAGES:
				return !getAllAccessedPackages().isEmpty();
			case corePackage.PACKAGE__TYPE_ALIASES:
				return typeAliases != null && !typeAliases.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //PackageImpl
