/**
 * <copyright>
 * </copyright>
 *
 * $Id: ModelElementImpl.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.core.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.annotations.ModelAnnotation;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Status;
import de.fzi.gast.core.corePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Model Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.core.impl.ModelElementImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.ModelElementImpl#getStatus <em>Status</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.ModelElementImpl#getSissyId <em>Sissy Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class ModelElementImpl extends IdentifierImpl implements ModelElement {
	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<ModelAnnotation> annotations;

	/**
	 * The default value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected static final Status STATUS_EDEFAULT = Status.NORMAL;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected Status status = STATUS_EDEFAULT;

	/**
	 * The default value of the '{@link #getSissyId() <em>Sissy Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSissyId()
	 * @generated
	 * @ordered
	 */
	protected static final int SISSY_ID_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getSissyId() <em>Sissy Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSissyId()
	 * @generated
	 * @ordered
	 */
	protected int sissyId = SISSY_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelElementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return corePackage.Literals.MODEL_ELEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ModelAnnotation> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<ModelAnnotation>(ModelAnnotation.class, this, corePackage.MODEL_ELEMENT__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Status getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatus(Status newStatus) {
		Status oldStatus = status;
		status = newStatus == null ? STATUS_EDEFAULT : newStatus;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.MODEL_ELEMENT__STATUS, oldStatus, status));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getSissyId() {
		return sissyId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSissyId(int newSissyId) {
		int oldSissyId = sissyId;
		sissyId = newSissyId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.MODEL_ELEMENT__SISSY_ID, oldSissyId, sissyId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.MODEL_ELEMENT__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case corePackage.MODEL_ELEMENT__ANNOTATIONS:
				return getAnnotations();
			case corePackage.MODEL_ELEMENT__STATUS:
				return getStatus();
			case corePackage.MODEL_ELEMENT__SISSY_ID:
				return getSissyId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case corePackage.MODEL_ELEMENT__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends ModelAnnotation>)newValue);
				return;
			case corePackage.MODEL_ELEMENT__STATUS:
				setStatus((Status)newValue);
				return;
			case corePackage.MODEL_ELEMENT__SISSY_ID:
				setSissyId((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case corePackage.MODEL_ELEMENT__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case corePackage.MODEL_ELEMENT__STATUS:
				setStatus(STATUS_EDEFAULT);
				return;
			case corePackage.MODEL_ELEMENT__SISSY_ID:
				setSissyId(SISSY_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case corePackage.MODEL_ELEMENT__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case corePackage.MODEL_ELEMENT__STATUS:
				return status != STATUS_EDEFAULT;
			case corePackage.MODEL_ELEMENT__SISSY_ID:
				return sissyId != SISSY_ID_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (status: ");
		result.append(status);
		result.append(", sissyId: ");
		result.append(sissyId);
		result.append(')');
		return result.toString();
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int hashCode() {
		return this.sissyId;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean equals(Object obj) {
		if (obj instanceof ModelElementImpl) {
			return this.sissyId == ((ModelElementImpl)obj).sissyId;
		}
		
		return false;
	}

} //ModelElementImpl
