/**
 * <copyright>
 * </copyright>
 *
 * $Id: FileImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.core.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.core.Directory;
import de.fzi.gast.core.File;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.helpers.DerivationHelper;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.variables.GlobalVariable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>File</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getDirectory <em>Directory</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getRoot <em>Root</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#isSourceFile <em>Source File</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#isAssemblyFile <em>Assembly File</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getImportedTypes <em>Imported Types</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getTypes <em>Types</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getGlobalVariables <em>Global Variables</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getGlobalFunctions <em>Global Functions</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getPathName <em>Path Name</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getImportedGlobalFunctions <em>Imported Global Functions</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getImportedGlobalVariables <em>Imported Global Variables</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getImportedPackages <em>Imported Packages</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.FileImpl#getIncludedFiles <em>Included Files</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FileImpl extends ModelElementImpl implements File {
	/**
	 * The default value of the '{@link #isSourceFile() <em>Source File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSourceFile()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SOURCE_FILE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isSourceFile() <em>Source File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSourceFile()
	 * @generated
	 * @ordered
	 */
	protected boolean sourceFile = SOURCE_FILE_EDEFAULT;

	/**
	 * The default value of the '{@link #isAssemblyFile() <em>Assembly File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAssemblyFile()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ASSEMBLY_FILE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #getImportedTypes() <em>Imported Types</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImportedTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<GASTType> importedTypes;

	/**
	 * The default value of the '{@link #getLinesOfCode() <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfCode()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_CODE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinesOfCode() <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfCode()
	 * @generated
	 * @ordered
	 */
	protected int linesOfCode = LINES_OF_CODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPathName() <em>Path Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPathName()
	 * @generated
	 * @ordered
	 */
	protected static final String PATH_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPathName() <em>Path Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPathName()
	 * @generated
	 * @ordered
	 */
	protected String pathName = PATH_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getImportedGlobalFunctions() <em>Imported Global Functions</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImportedGlobalFunctions()
	 * @generated
	 * @ordered
	 */
	protected EList<GlobalFunction> importedGlobalFunctions;

	/**
	 * The cached value of the '{@link #getImportedGlobalVariables() <em>Imported Global Variables</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImportedGlobalVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<GlobalVariable> importedGlobalVariables;

	/**
	 * The cached value of the '{@link #getImportedPackages() <em>Imported Packages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImportedPackages()
	 * @generated
	 * @ordered
	 */
	protected EList<de.fzi.gast.core.Package> importedPackages;

	/**
	 * The cached value of the '{@link #getIncludedFiles() <em>Included Files</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIncludedFiles()
	 * @generated
	 * @ordered
	 */
	protected EList<File> includedFiles;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FileImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return corePackage.Literals.FILE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Directory getDirectory() {
		if (eContainerFeatureID() != corePackage.FILE__DIRECTORY) return null;
		return (Directory)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDirectory(Directory newDirectory, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newDirectory, corePackage.FILE__DIRECTORY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDirectory(Directory newDirectory) {
		if (newDirectory != eInternalContainer() || (eContainerFeatureID() != corePackage.FILE__DIRECTORY && newDirectory != null)) {
			if (EcoreUtil.isAncestor(this, newDirectory))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newDirectory != null)
				msgs = ((InternalEObject)newDirectory).eInverseAdd(this, corePackage.DIRECTORY__FILES, Directory.class, msgs);
			msgs = basicSetDirectory(newDirectory, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.FILE__DIRECTORY, newDirectory, newDirectory));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Root getRoot() {
		Root root = basicGetRoot();
		return root != null && root.eIsProxy() ? (Root)eResolveProxy((InternalEObject)root) : root;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Root basicGetRoot() {
		
		return (Root) DerivationHelper.calculateNearestParentOfType(this, Root.class);
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setRoot(Root newRoot) {
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GASTType> getImportedTypes() {
		if (importedTypes == null) {
			importedTypes = new EObjectResolvingEList<GASTType>(GASTType.class, this, corePackage.FILE__IMPORTED_TYPES);
		}
		return importedTypes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTType> getTypes() {
		Root root = this.getRoot();
		if (root != null)
			return DerivationHelper.selectElementsWithFilePosition(DerivationHelper.getAllTypes(this.getRoot()),this);
		else
			return new BasicInternalEList(GASTType.class);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GlobalVariable> getGlobalVariables() {
		return DerivationHelper.selectElementsWithFilePosition(this.getRoot().getGlobalVariables(),this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GlobalFunction> getGlobalFunctions() {
		return DerivationHelper.selectElementsWithFilePosition(this.getRoot().getGlobalFunctions(),this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSourceFile() {
		return sourceFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceFile(boolean newSourceFile) {
		boolean oldSourceFile = sourceFile;
		sourceFile = newSourceFile;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.FILE__SOURCE_FILE, oldSourceFile, sourceFile));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isAssemblyFile() {
		return !this.isSourceFile();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetAssemblyFile() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLinesOfCode() {
		return linesOfCode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLinesOfCode(int newLinesOfCode) {
		int oldLinesOfCode = linesOfCode;
		linesOfCode = newLinesOfCode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.FILE__LINES_OF_CODE, oldLinesOfCode, linesOfCode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPathName() {
		return pathName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPathName(String newPathName) {
		String oldPathName = pathName;
		pathName = newPathName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.FILE__PATH_NAME, oldPathName, pathName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GlobalFunction> getImportedGlobalFunctions() {
		if (importedGlobalFunctions == null) {
			importedGlobalFunctions = new EObjectResolvingEList<GlobalFunction>(GlobalFunction.class, this, corePackage.FILE__IMPORTED_GLOBAL_FUNCTIONS);
		}
		return importedGlobalFunctions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GlobalVariable> getImportedGlobalVariables() {
		if (importedGlobalVariables == null) {
			importedGlobalVariables = new EObjectResolvingEList<GlobalVariable>(GlobalVariable.class, this, corePackage.FILE__IMPORTED_GLOBAL_VARIABLES);
		}
		return importedGlobalVariables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<de.fzi.gast.core.Package> getImportedPackages() {
		if (importedPackages == null) {
			importedPackages = new EObjectResolvingEList<de.fzi.gast.core.Package>(de.fzi.gast.core.Package.class, this, corePackage.FILE__IMPORTED_PACKAGES);
		}
		return importedPackages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<File> getIncludedFiles() {
		if (includedFiles == null) {
			includedFiles = new EObjectResolvingEList<File>(File.class, this, corePackage.FILE__INCLUDED_FILES);
		}
		return includedFiles;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.FILE__DIRECTORY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetDirectory((Directory)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.FILE__DIRECTORY:
				return basicSetDirectory(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case corePackage.FILE__DIRECTORY:
				return eInternalContainer().eInverseRemove(this, corePackage.DIRECTORY__FILES, Directory.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case corePackage.FILE__DIRECTORY:
				return getDirectory();
			case corePackage.FILE__ROOT:
				if (resolve) return getRoot();
				return basicGetRoot();
			case corePackage.FILE__SOURCE_FILE:
				return isSourceFile();
			case corePackage.FILE__ASSEMBLY_FILE:
				return isAssemblyFile();
			case corePackage.FILE__IMPORTED_TYPES:
				return getImportedTypes();
			case corePackage.FILE__TYPES:
				return getTypes();
			case corePackage.FILE__GLOBAL_VARIABLES:
				return getGlobalVariables();
			case corePackage.FILE__GLOBAL_FUNCTIONS:
				return getGlobalFunctions();
			case corePackage.FILE__LINES_OF_CODE:
				return getLinesOfCode();
			case corePackage.FILE__PATH_NAME:
				return getPathName();
			case corePackage.FILE__IMPORTED_GLOBAL_FUNCTIONS:
				return getImportedGlobalFunctions();
			case corePackage.FILE__IMPORTED_GLOBAL_VARIABLES:
				return getImportedGlobalVariables();
			case corePackage.FILE__IMPORTED_PACKAGES:
				return getImportedPackages();
			case corePackage.FILE__INCLUDED_FILES:
				return getIncludedFiles();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case corePackage.FILE__DIRECTORY:
				setDirectory((Directory)newValue);
				return;
			case corePackage.FILE__SOURCE_FILE:
				setSourceFile((Boolean)newValue);
				return;
			case corePackage.FILE__IMPORTED_TYPES:
				getImportedTypes().clear();
				getImportedTypes().addAll((Collection<? extends GASTType>)newValue);
				return;
			case corePackage.FILE__LINES_OF_CODE:
				setLinesOfCode((Integer)newValue);
				return;
			case corePackage.FILE__PATH_NAME:
				setPathName((String)newValue);
				return;
			case corePackage.FILE__IMPORTED_GLOBAL_FUNCTIONS:
				getImportedGlobalFunctions().clear();
				getImportedGlobalFunctions().addAll((Collection<? extends GlobalFunction>)newValue);
				return;
			case corePackage.FILE__IMPORTED_GLOBAL_VARIABLES:
				getImportedGlobalVariables().clear();
				getImportedGlobalVariables().addAll((Collection<? extends GlobalVariable>)newValue);
				return;
			case corePackage.FILE__IMPORTED_PACKAGES:
				getImportedPackages().clear();
				getImportedPackages().addAll((Collection<? extends de.fzi.gast.core.Package>)newValue);
				return;
			case corePackage.FILE__INCLUDED_FILES:
				getIncludedFiles().clear();
				getIncludedFiles().addAll((Collection<? extends File>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case corePackage.FILE__DIRECTORY:
				setDirectory((Directory)null);
				return;
			case corePackage.FILE__SOURCE_FILE:
				setSourceFile(SOURCE_FILE_EDEFAULT);
				return;
			case corePackage.FILE__IMPORTED_TYPES:
				getImportedTypes().clear();
				return;
			case corePackage.FILE__LINES_OF_CODE:
				setLinesOfCode(LINES_OF_CODE_EDEFAULT);
				return;
			case corePackage.FILE__PATH_NAME:
				setPathName(PATH_NAME_EDEFAULT);
				return;
			case corePackage.FILE__IMPORTED_GLOBAL_FUNCTIONS:
				getImportedGlobalFunctions().clear();
				return;
			case corePackage.FILE__IMPORTED_GLOBAL_VARIABLES:
				getImportedGlobalVariables().clear();
				return;
			case corePackage.FILE__IMPORTED_PACKAGES:
				getImportedPackages().clear();
				return;
			case corePackage.FILE__INCLUDED_FILES:
				getIncludedFiles().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case corePackage.FILE__DIRECTORY:
				return getDirectory() != null;
			case corePackage.FILE__ROOT:
				return basicGetRoot() != null;
			case corePackage.FILE__SOURCE_FILE:
				return sourceFile != SOURCE_FILE_EDEFAULT;
			case corePackage.FILE__ASSEMBLY_FILE:
				return isAssemblyFile() != ASSEMBLY_FILE_EDEFAULT;
			case corePackage.FILE__IMPORTED_TYPES:
				return importedTypes != null && !importedTypes.isEmpty();
			case corePackage.FILE__TYPES:
				return !getTypes().isEmpty();
			case corePackage.FILE__GLOBAL_VARIABLES:
				return !getGlobalVariables().isEmpty();
			case corePackage.FILE__GLOBAL_FUNCTIONS:
				return !getGlobalFunctions().isEmpty();
			case corePackage.FILE__LINES_OF_CODE:
				return linesOfCode != LINES_OF_CODE_EDEFAULT;
			case corePackage.FILE__PATH_NAME:
				return PATH_NAME_EDEFAULT == null ? pathName != null : !PATH_NAME_EDEFAULT.equals(pathName);
			case corePackage.FILE__IMPORTED_GLOBAL_FUNCTIONS:
				return importedGlobalFunctions != null && !importedGlobalFunctions.isEmpty();
			case corePackage.FILE__IMPORTED_GLOBAL_VARIABLES:
				return importedGlobalVariables != null && !importedGlobalVariables.isEmpty();
			case corePackage.FILE__IMPORTED_PACKAGES:
				return importedPackages != null && !importedPackages.isEmpty();
			case corePackage.FILE__INCLUDED_FILES:
				return includedFiles != null && !includedFiles.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (sourceFile: ");
		result.append(sourceFile);
		result.append(", linesOfCode: ");
		result.append(linesOfCode);
		result.append(", pathName: ");
		result.append(pathName);
		result.append(')');
		return result.toString();
	}

} //FileImpl
