/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.core.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.core.Directory;
import de.fzi.gast.core.File;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.corePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Directory</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.core.impl.DirectoryImpl#getSubDirectory <em>Sub Directory</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.DirectoryImpl#getParentDirectory <em>Parent Directory</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.DirectoryImpl#getFullqualifiedpath <em>Fullqualifiedpath</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.DirectoryImpl#getFiles <em>Files</em>}</li>
 *   <li>{@link de.fzi.gast.core.impl.DirectoryImpl#getRoot <em>Root</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DirectoryImpl extends NamedModelElementImpl implements Directory {
	/**
	 * The cached value of the '{@link #getSubDirectory() <em>Sub Directory</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubDirectory()
	 * @generated
	 * @ordered
	 */
	protected EList<Directory> subDirectory;

	/**
	 * The default value of the '{@link #getFullqualifiedpath() <em>Fullqualifiedpath</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFullqualifiedpath()
	 * @generated
	 * @ordered
	 */
	protected static final String FULLQUALIFIEDPATH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFiles() <em>Files</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFiles()
	 * @generated
	 * @ordered
	 */
	protected EList<File> files;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DirectoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return corePackage.Literals.DIRECTORY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Directory> getSubDirectory() {
		if (subDirectory == null) {
			subDirectory = new EObjectContainmentWithInverseEList<Directory>(Directory.class, this, corePackage.DIRECTORY__SUB_DIRECTORY, corePackage.DIRECTORY__PARENT_DIRECTORY);
		}
		return subDirectory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Directory getParentDirectory() {
		if (eContainerFeatureID() != corePackage.DIRECTORY__PARENT_DIRECTORY) return null;
		return (Directory)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParentDirectory(Directory newParentDirectory, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newParentDirectory, corePackage.DIRECTORY__PARENT_DIRECTORY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentDirectory(Directory newParentDirectory) {
		if (newParentDirectory != eInternalContainer() || (eContainerFeatureID() != corePackage.DIRECTORY__PARENT_DIRECTORY && newParentDirectory != null)) {
			if (EcoreUtil.isAncestor(this, newParentDirectory))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParentDirectory != null)
				msgs = ((InternalEObject)newParentDirectory).eInverseAdd(this, corePackage.DIRECTORY__SUB_DIRECTORY, Directory.class, msgs);
			msgs = basicSetParentDirectory(newParentDirectory, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.DIRECTORY__PARENT_DIRECTORY, newParentDirectory, newParentDirectory));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<File> getFiles() {
		if (files == null) {
			files = new EObjectContainmentWithInverseEList<File>(File.class, this, corePackage.DIRECTORY__FILES, corePackage.FILE__DIRECTORY);
		}
		return files;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Root getRoot() {
		if (eContainerFeatureID() != corePackage.DIRECTORY__ROOT) return null;
		return (Root)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRoot(Root newRoot, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newRoot, corePackage.DIRECTORY__ROOT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRoot(Root newRoot) {
		if (newRoot != eInternalContainer() || (eContainerFeatureID() != corePackage.DIRECTORY__ROOT && newRoot != null)) {
			if (EcoreUtil.isAncestor(this, newRoot))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newRoot != null)
				msgs = ((InternalEObject)newRoot).eInverseAdd(this, corePackage.ROOT__DIRECTORIES, Root.class, msgs);
			msgs = basicSetRoot(newRoot, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, corePackage.DIRECTORY__ROOT, newRoot, newRoot));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getFullqualifiedpath() {
		// TODO: implement this method to return the 'Fullqualifiedpath' attribute
		// Ensure that you remove @generated or mark it @generated NOT
		String name = this.getSimpleName();
		
		Directory parent = this.getParentDirectory();
		while (parent != null) {
			name = parent.getSimpleName() + "/" + name;
			parent = parent.getParentDirectory();
		}
		
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.DIRECTORY__SUB_DIRECTORY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSubDirectory()).basicAdd(otherEnd, msgs);
			case corePackage.DIRECTORY__PARENT_DIRECTORY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetParentDirectory((Directory)otherEnd, msgs);
			case corePackage.DIRECTORY__FILES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getFiles()).basicAdd(otherEnd, msgs);
			case corePackage.DIRECTORY__ROOT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetRoot((Root)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case corePackage.DIRECTORY__SUB_DIRECTORY:
				return ((InternalEList<?>)getSubDirectory()).basicRemove(otherEnd, msgs);
			case corePackage.DIRECTORY__PARENT_DIRECTORY:
				return basicSetParentDirectory(null, msgs);
			case corePackage.DIRECTORY__FILES:
				return ((InternalEList<?>)getFiles()).basicRemove(otherEnd, msgs);
			case corePackage.DIRECTORY__ROOT:
				return basicSetRoot(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case corePackage.DIRECTORY__PARENT_DIRECTORY:
				return eInternalContainer().eInverseRemove(this, corePackage.DIRECTORY__SUB_DIRECTORY, Directory.class, msgs);
			case corePackage.DIRECTORY__ROOT:
				return eInternalContainer().eInverseRemove(this, corePackage.ROOT__DIRECTORIES, Root.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case corePackage.DIRECTORY__SUB_DIRECTORY:
				return getSubDirectory();
			case corePackage.DIRECTORY__PARENT_DIRECTORY:
				return getParentDirectory();
			case corePackage.DIRECTORY__FULLQUALIFIEDPATH:
				return getFullqualifiedpath();
			case corePackage.DIRECTORY__FILES:
				return getFiles();
			case corePackage.DIRECTORY__ROOT:
				return getRoot();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case corePackage.DIRECTORY__SUB_DIRECTORY:
				getSubDirectory().clear();
				getSubDirectory().addAll((Collection<? extends Directory>)newValue);
				return;
			case corePackage.DIRECTORY__PARENT_DIRECTORY:
				setParentDirectory((Directory)newValue);
				return;
			case corePackage.DIRECTORY__FILES:
				getFiles().clear();
				getFiles().addAll((Collection<? extends File>)newValue);
				return;
			case corePackage.DIRECTORY__ROOT:
				setRoot((Root)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case corePackage.DIRECTORY__SUB_DIRECTORY:
				getSubDirectory().clear();
				return;
			case corePackage.DIRECTORY__PARENT_DIRECTORY:
				setParentDirectory((Directory)null);
				return;
			case corePackage.DIRECTORY__FILES:
				getFiles().clear();
				return;
			case corePackage.DIRECTORY__ROOT:
				setRoot((Root)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case corePackage.DIRECTORY__SUB_DIRECTORY:
				return subDirectory != null && !subDirectory.isEmpty();
			case corePackage.DIRECTORY__PARENT_DIRECTORY:
				return getParentDirectory() != null;
			case corePackage.DIRECTORY__FULLQUALIFIEDPATH:
				return FULLQUALIFIEDPATH_EDEFAULT == null ? getFullqualifiedpath() != null : !FULLQUALIFIEDPATH_EDEFAULT.equals(getFullqualifiedpath());
			case corePackage.DIRECTORY__FILES:
				return files != null && !files.isEmpty();
			case corePackage.DIRECTORY__ROOT:
				return getRoot() != null;
		}
		return super.eIsSet(featureID);
	}

} //DirectoryImpl
