/**
 * <copyright>
 * </copyright>
 *
 * $Id: corePackage.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.core;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.fzi.gast.core.coreFactory
 * @model kind="package"
 * @generated
 */
public interface corePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "core";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.fzi.de/gast/core";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "core";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	corePackage eINSTANCE = de.fzi.gast.core.impl.corePackageImpl.init();

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.PositionImpl <em>Position</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.PositionImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getPosition()
	 * @generated
	 */
	int POSITION = 0;

	/**
	 * The feature id for the '<em><b>End Column</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__END_COLUMN = 0;

	/**
	 * The feature id for the '<em><b>Start Column</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__START_COLUMN = 1;

	/**
	 * The feature id for the '<em><b>End Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__END_LINE = 2;

	/**
	 * The feature id for the '<em><b>Start Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__START_LINE = 3;

	/**
	 * The feature id for the '<em><b>Source File</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__SOURCE_FILE = 4;

	/**
	 * The feature id for the '<em><b>Assembly</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__ASSEMBLY = 5;

	/**
	 * The feature id for the '<em><b>Sourceentity</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__SOURCEENTITY = 6;

	/**
	 * The number of structural features of the '<em>Position</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION_FEATURE_COUNT = 7;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.IdentifierImpl <em>Identifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.IdentifierImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getIdentifier()
	 * @generated
	 */
	int IDENTIFIER = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIER__ID = 0;

	/**
	 * The number of structural features of the '<em>Identifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIER_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.ModelElementImpl <em>Model Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.ModelElementImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getModelElement()
	 * @generated
	 */
	int MODEL_ELEMENT = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_ELEMENT__ID = IDENTIFIER__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_ELEMENT__ANNOTATIONS = IDENTIFIER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_ELEMENT__STATUS = IDENTIFIER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_ELEMENT__SISSY_ID = IDENTIFIER_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Model Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_ELEMENT_FEATURE_COUNT = IDENTIFIER_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.FileImpl <em>File</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.FileImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getFile()
	 * @generated
	 */
	int FILE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__ID = MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__ANNOTATIONS = MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__STATUS = MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__SISSY_ID = MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Directory</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__DIRECTORY = MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Root</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__ROOT = MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__SOURCE_FILE = MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Assembly File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__ASSEMBLY_FILE = MODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Imported Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__IMPORTED_TYPES = MODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__TYPES = MODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Global Variables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__GLOBAL_VARIABLES = MODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Global Functions</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__GLOBAL_FUNCTIONS = MODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__LINES_OF_CODE = MODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Path Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__PATH_NAME = MODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Imported Global Functions</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__IMPORTED_GLOBAL_FUNCTIONS = MODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Imported Global Variables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__IMPORTED_GLOBAL_VARIABLES = MODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Imported Packages</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__IMPORTED_PACKAGES = MODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Included Files</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE__INCLUDED_FILES = MODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_FEATURE_COUNT = MODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.NamedModelElementImpl <em>Named Model Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.NamedModelElementImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getNamedModelElement()
	 * @generated
	 */
	int NAMED_MODEL_ELEMENT = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_MODEL_ELEMENT__ID = MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_MODEL_ELEMENT__ANNOTATIONS = MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_MODEL_ELEMENT__STATUS = MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_MODEL_ELEMENT__SISSY_ID = MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_MODEL_ELEMENT__SIMPLE_NAME = MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Named Model Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_MODEL_ELEMENT_FEATURE_COUNT = MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.PackageImpl <em>Package</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.PackageImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getPackage()
	 * @generated
	 */
	int PACKAGE = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ID = NAMED_MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ANNOTATIONS = NAMED_MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__STATUS = NAMED_MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__SISSY_ID = NAMED_MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__SIMPLE_NAME = NAMED_MODEL_ELEMENT__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>All Local Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ALL_LOCAL_CLASSES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>All Inner Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ALL_INNER_CLASSES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>All Normal Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ALL_NORMAL_CLASSES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>All Interfaces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ALL_INTERFACES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ALL_ACCESSES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__DELEGATES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Global Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__GLOBAL_FUNCTIONS = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Global Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__GLOBAL_VARIABLES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__LINES_OF_COMMENTS = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__LINES_OF_CODE = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__QUALIFIED_NAME = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__CLASSES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Sub Packages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__SUB_PACKAGES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__SURROUNDING_PACKAGE = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Root</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ROOT = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>All Accessed Packages</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__ALL_ACCESSED_PACKAGES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__TYPE_ALIASES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>Package</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_FEATURE_COUNT = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.GenericEntityImpl <em>Generic Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.GenericEntityImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getGenericEntity()
	 * @generated
	 */
	int GENERIC_ENTITY = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_ENTITY__ID = MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_ENTITY__ANNOTATIONS = MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_ENTITY__STATUS = MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_ENTITY__SISSY_ID = MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Type Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_ENTITY__TYPE_PARAMETERS = MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Generic Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_ENTITY_FEATURE_COUNT = MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.RootImpl <em>Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.RootImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getRoot()
	 * @generated
	 */
	int ROOT = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__ID = MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__ANNOTATIONS = MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__STATUS = MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__SISSY_ID = MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__ALL_ACCESSES = MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>All Inner Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__ALL_INNER_CLASSES = MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>All Interfaces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__ALL_INTERFACES = MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>All Local Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__ALL_LOCAL_CLASSES = MODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>All Normal Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__ALL_NORMAL_CLASSES = MODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>All Model Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__ALL_MODEL_ELEMENTS = MODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__LINES_OF_COMMENTS = MODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__LINES_OF_CODE = MODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Global Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__GLOBAL_FUNCTIONS = MODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Global Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__GLOBAL_VARIABLES = MODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Clones</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__CLONES = MODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Structural Abstractions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__STRUCTURAL_ABSTRACTIONS = MODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__TYPES = MODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Dangling Model Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__DANGLING_MODEL_ELEMENTS = MODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Directories</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__DIRECTORIES = MODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Packages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__PACKAGES = MODEL_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The number of structural features of the '<em>Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_FEATURE_COUNT = MODEL_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.DirectoryImpl <em>Directory</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.DirectoryImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getDirectory()
	 * @generated
	 */
	int DIRECTORY = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__ID = NAMED_MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__ANNOTATIONS = NAMED_MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__STATUS = NAMED_MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__SISSY_ID = NAMED_MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__SIMPLE_NAME = NAMED_MODEL_ELEMENT__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Sub Directory</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__SUB_DIRECTORY = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parent Directory</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__PARENT_DIRECTORY = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Fullqualifiedpath</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__FULLQUALIFIEDPATH = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Files</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__FILES = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Root</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY__ROOT = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Directory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTORY_FEATURE_COUNT = NAMED_MODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.PackageAliasImpl <em>Package Alias</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.PackageAliasImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getPackageAlias()
	 * @generated
	 */
	int PACKAGE_ALIAS = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ID = PACKAGE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ANNOTATIONS = PACKAGE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__STATUS = PACKAGE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__SISSY_ID = PACKAGE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__SIMPLE_NAME = PACKAGE__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>All Local Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ALL_LOCAL_CLASSES = PACKAGE__ALL_LOCAL_CLASSES;

	/**
	 * The feature id for the '<em><b>All Inner Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ALL_INNER_CLASSES = PACKAGE__ALL_INNER_CLASSES;

	/**
	 * The feature id for the '<em><b>All Normal Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ALL_NORMAL_CLASSES = PACKAGE__ALL_NORMAL_CLASSES;

	/**
	 * The feature id for the '<em><b>All Interfaces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ALL_INTERFACES = PACKAGE__ALL_INTERFACES;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ALL_ACCESSES = PACKAGE__ALL_ACCESSES;

	/**
	 * The feature id for the '<em><b>Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__DELEGATES = PACKAGE__DELEGATES;

	/**
	 * The feature id for the '<em><b>Global Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__GLOBAL_FUNCTIONS = PACKAGE__GLOBAL_FUNCTIONS;

	/**
	 * The feature id for the '<em><b>Global Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__GLOBAL_VARIABLES = PACKAGE__GLOBAL_VARIABLES;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__LINES_OF_COMMENTS = PACKAGE__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__LINES_OF_CODE = PACKAGE__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__QUALIFIED_NAME = PACKAGE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__CLASSES = PACKAGE__CLASSES;

	/**
	 * The feature id for the '<em><b>Sub Packages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__SUB_PACKAGES = PACKAGE__SUB_PACKAGES;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__SURROUNDING_PACKAGE = PACKAGE__SURROUNDING_PACKAGE;

	/**
	 * The feature id for the '<em><b>Root</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ROOT = PACKAGE__ROOT;

	/**
	 * The feature id for the '<em><b>All Accessed Packages</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ALL_ACCESSED_PACKAGES = PACKAGE__ALL_ACCESSED_PACKAGES;

	/**
	 * The feature id for the '<em><b>Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__TYPE_ALIASES = PACKAGE__TYPE_ALIASES;

	/**
	 * The feature id for the '<em><b>Aliased Package</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS__ALIASED_PACKAGE = PACKAGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Package Alias</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_ALIAS_FEATURE_COUNT = PACKAGE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.impl.SourceEntityImpl <em>Source Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.impl.SourceEntityImpl
	 * @see de.fzi.gast.core.impl.corePackageImpl#getSourceEntity()
	 * @generated
	 */
	int SOURCE_ENTITY = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOURCE_ENTITY__ID = MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOURCE_ENTITY__ANNOTATIONS = MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOURCE_ENTITY__STATUS = MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOURCE_ENTITY__SISSY_ID = MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOURCE_ENTITY__POSITION = MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Source Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOURCE_ENTITY_FEATURE_COUNT = MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.core.Status <em>Status</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.core.Status
	 * @see de.fzi.gast.core.impl.corePackageImpl#getStatus()
	 * @generated
	 */
	int STATUS = 11;


	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.Position <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Position</em>'.
	 * @see de.fzi.gast.core.Position
	 * @generated
	 */
	EClass getPosition();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Position#getEndColumn <em>End Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Column</em>'.
	 * @see de.fzi.gast.core.Position#getEndColumn()
	 * @see #getPosition()
	 * @generated
	 */
	EAttribute getPosition_EndColumn();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Position#getStartColumn <em>Start Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Column</em>'.
	 * @see de.fzi.gast.core.Position#getStartColumn()
	 * @see #getPosition()
	 * @generated
	 */
	EAttribute getPosition_StartColumn();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Position#getEndLine <em>End Line</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Line</em>'.
	 * @see de.fzi.gast.core.Position#getEndLine()
	 * @see #getPosition()
	 * @generated
	 */
	EAttribute getPosition_EndLine();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Position#getStartLine <em>Start Line</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Line</em>'.
	 * @see de.fzi.gast.core.Position#getStartLine()
	 * @see #getPosition()
	 * @generated
	 */
	EAttribute getPosition_StartLine();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.core.Position#getSourceFile <em>Source File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source File</em>'.
	 * @see de.fzi.gast.core.Position#getSourceFile()
	 * @see #getPosition()
	 * @generated
	 */
	EReference getPosition_SourceFile();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.core.Position#getAssembly <em>Assembly</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Assembly</em>'.
	 * @see de.fzi.gast.core.Position#getAssembly()
	 * @see #getPosition()
	 * @generated
	 */
	EReference getPosition_Assembly();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.core.Position#getSourceentity <em>Sourceentity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Sourceentity</em>'.
	 * @see de.fzi.gast.core.Position#getSourceentity()
	 * @see #getPosition()
	 * @generated
	 */
	EReference getPosition_Sourceentity();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.File <em>File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>File</em>'.
	 * @see de.fzi.gast.core.File
	 * @generated
	 */
	EClass getFile();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.core.File#getDirectory <em>Directory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Directory</em>'.
	 * @see de.fzi.gast.core.File#getDirectory()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_Directory();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.core.File#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Root</em>'.
	 * @see de.fzi.gast.core.File#getRoot()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_Root();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.File#getImportedTypes <em>Imported Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Imported Types</em>'.
	 * @see de.fzi.gast.core.File#getImportedTypes()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_ImportedTypes();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.File#getTypes <em>Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Types</em>'.
	 * @see de.fzi.gast.core.File#getTypes()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_Types();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.File#getGlobalVariables <em>Global Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Global Variables</em>'.
	 * @see de.fzi.gast.core.File#getGlobalVariables()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_GlobalVariables();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.File#getGlobalFunctions <em>Global Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Global Functions</em>'.
	 * @see de.fzi.gast.core.File#getGlobalFunctions()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_GlobalFunctions();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.File#isSourceFile <em>Source File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Source File</em>'.
	 * @see de.fzi.gast.core.File#isSourceFile()
	 * @see #getFile()
	 * @generated
	 */
	EAttribute getFile_SourceFile();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.File#isAssemblyFile <em>Assembly File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Assembly File</em>'.
	 * @see de.fzi.gast.core.File#isAssemblyFile()
	 * @see #getFile()
	 * @generated
	 */
	EAttribute getFile_AssemblyFile();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.File#getLinesOfCode <em>Lines Of Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Code</em>'.
	 * @see de.fzi.gast.core.File#getLinesOfCode()
	 * @see #getFile()
	 * @generated
	 */
	EAttribute getFile_LinesOfCode();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.File#getPathName <em>Path Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Path Name</em>'.
	 * @see de.fzi.gast.core.File#getPathName()
	 * @see #getFile()
	 * @generated
	 */
	EAttribute getFile_PathName();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.File#getImportedGlobalFunctions <em>Imported Global Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Imported Global Functions</em>'.
	 * @see de.fzi.gast.core.File#getImportedGlobalFunctions()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_ImportedGlobalFunctions();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.File#getImportedGlobalVariables <em>Imported Global Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Imported Global Variables</em>'.
	 * @see de.fzi.gast.core.File#getImportedGlobalVariables()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_ImportedGlobalVariables();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.File#getImportedPackages <em>Imported Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Imported Packages</em>'.
	 * @see de.fzi.gast.core.File#getImportedPackages()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_ImportedPackages();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.File#getIncludedFiles <em>Included Files</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Included Files</em>'.
	 * @see de.fzi.gast.core.File#getIncludedFiles()
	 * @see #getFile()
	 * @generated
	 */
	EReference getFile_IncludedFiles();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.ModelElement <em>Model Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model Element</em>'.
	 * @see de.fzi.gast.core.ModelElement
	 * @generated
	 */
	EClass getModelElement();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.ModelElement#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see de.fzi.gast.core.ModelElement#getAnnotations()
	 * @see #getModelElement()
	 * @generated
	 */
	EReference getModelElement_Annotations();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.ModelElement#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see de.fzi.gast.core.ModelElement#getStatus()
	 * @see #getModelElement()
	 * @generated
	 */
	EAttribute getModelElement_Status();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.ModelElement#getSissyId <em>Sissy Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sissy Id</em>'.
	 * @see de.fzi.gast.core.ModelElement#getSissyId()
	 * @see #getModelElement()
	 * @generated
	 */
	EAttribute getModelElement_SissyId();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.Identifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Identifier</em>'.
	 * @see de.fzi.gast.core.Identifier
	 * @generated
	 */
	EClass getIdentifier();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Identifier#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see de.fzi.gast.core.Identifier#getId()
	 * @see #getIdentifier()
	 * @generated
	 */
	EAttribute getIdentifier_Id();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.NamedModelElement <em>Named Model Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Named Model Element</em>'.
	 * @see de.fzi.gast.core.NamedModelElement
	 * @generated
	 */
	EClass getNamedModelElement();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.NamedModelElement#getSimpleName <em>Simple Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Simple Name</em>'.
	 * @see de.fzi.gast.core.NamedModelElement#getSimpleName()
	 * @see #getNamedModelElement()
	 * @generated
	 */
	EAttribute getNamedModelElement_SimpleName();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.Package <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Package</em>'.
	 * @see de.fzi.gast.core.Package
	 * @generated
	 */
	EClass getPackage();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Package#getAllLocalClasses <em>All Local Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Local Classes</em>'.
	 * @see de.fzi.gast.core.Package#getAllLocalClasses()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_AllLocalClasses();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Package#getAllInnerClasses <em>All Inner Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Inner Classes</em>'.
	 * @see de.fzi.gast.core.Package#getAllInnerClasses()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_AllInnerClasses();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Package#getAllNormalClasses <em>All Normal Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Normal Classes</em>'.
	 * @see de.fzi.gast.core.Package#getAllNormalClasses()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_AllNormalClasses();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Package#getAllInterfaces <em>All Interfaces</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Interfaces</em>'.
	 * @see de.fzi.gast.core.Package#getAllInterfaces()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_AllInterfaces();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Package#getAllAccesses <em>All Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Accesses</em>'.
	 * @see de.fzi.gast.core.Package#getAllAccesses()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_AllAccesses();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Package#getLinesOfComments <em>Lines Of Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Comments</em>'.
	 * @see de.fzi.gast.core.Package#getLinesOfComments()
	 * @see #getPackage()
	 * @generated
	 */
	EAttribute getPackage_LinesOfComments();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Package#getLinesOfCode <em>Lines Of Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Code</em>'.
	 * @see de.fzi.gast.core.Package#getLinesOfCode()
	 * @see #getPackage()
	 * @generated
	 */
	EAttribute getPackage_LinesOfCode();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Package#getQualifiedName <em>Qualified Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Qualified Name</em>'.
	 * @see de.fzi.gast.core.Package#getQualifiedName()
	 * @see #getPackage()
	 * @generated
	 */
	EAttribute getPackage_QualifiedName();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Package#getDelegates <em>Delegates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Delegates</em>'.
	 * @see de.fzi.gast.core.Package#getDelegates()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_Delegates();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Package#getGlobalVariables <em>Global Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Global Variables</em>'.
	 * @see de.fzi.gast.core.Package#getGlobalVariables()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_GlobalVariables();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Package#getGlobalFunctions <em>Global Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Global Functions</em>'.
	 * @see de.fzi.gast.core.Package#getGlobalFunctions()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_GlobalFunctions();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Package#getClasses <em>Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Classes</em>'.
	 * @see de.fzi.gast.core.Package#getClasses()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_Classes();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Package#getSubPackages <em>Sub Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Sub Packages</em>'.
	 * @see de.fzi.gast.core.Package#getSubPackages()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_SubPackages();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.core.Package#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Package</em>'.
	 * @see de.fzi.gast.core.Package#getSurroundingPackage()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_SurroundingPackage();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.core.Package#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Root</em>'.
	 * @see de.fzi.gast.core.Package#getRoot()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_Root();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Package#getAllAccessedPackages <em>All Accessed Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Accessed Packages</em>'.
	 * @see de.fzi.gast.core.Package#getAllAccessedPackages()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_AllAccessedPackages();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Package#getTypeAliases <em>Type Aliases</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Type Aliases</em>'.
	 * @see de.fzi.gast.core.Package#getTypeAliases()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_TypeAliases();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.GenericEntity <em>Generic Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generic Entity</em>'.
	 * @see de.fzi.gast.core.GenericEntity
	 * @generated
	 */
	EClass getGenericEntity();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.GenericEntity#getTypeParameters <em>Type Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Type Parameters</em>'.
	 * @see de.fzi.gast.core.GenericEntity#getTypeParameters()
	 * @see #getGenericEntity()
	 * @generated
	 */
	EReference getGenericEntity_TypeParameters();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.Root <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Root</em>'.
	 * @see de.fzi.gast.core.Root
	 * @generated
	 */
	EClass getRoot();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Root#getAllAccesses <em>All Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Accesses</em>'.
	 * @see de.fzi.gast.core.Root#getAllAccesses()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_AllAccesses();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Root#getAllInnerClasses <em>All Inner Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Inner Classes</em>'.
	 * @see de.fzi.gast.core.Root#getAllInnerClasses()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_AllInnerClasses();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Root#getAllInterfaces <em>All Interfaces</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Interfaces</em>'.
	 * @see de.fzi.gast.core.Root#getAllInterfaces()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_AllInterfaces();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Root#getAllLocalClasses <em>All Local Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Local Classes</em>'.
	 * @see de.fzi.gast.core.Root#getAllLocalClasses()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_AllLocalClasses();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Root#getAllNormalClasses <em>All Normal Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Normal Classes</em>'.
	 * @see de.fzi.gast.core.Root#getAllNormalClasses()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_AllNormalClasses();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.core.Root#getAllModelElements <em>All Model Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Model Elements</em>'.
	 * @see de.fzi.gast.core.Root#getAllModelElements()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_AllModelElements();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Root#getLinesOfComments <em>Lines Of Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Comments</em>'.
	 * @see de.fzi.gast.core.Root#getLinesOfComments()
	 * @see #getRoot()
	 * @generated
	 */
	EAttribute getRoot_LinesOfComments();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Root#getLinesOfCode <em>Lines Of Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Code</em>'.
	 * @see de.fzi.gast.core.Root#getLinesOfCode()
	 * @see #getRoot()
	 * @generated
	 */
	EAttribute getRoot_LinesOfCode();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Root#getGlobalFunctions <em>Global Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Global Functions</em>'.
	 * @see de.fzi.gast.core.Root#getGlobalFunctions()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_GlobalFunctions();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Root#getGlobalVariables <em>Global Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Global Variables</em>'.
	 * @see de.fzi.gast.core.Root#getGlobalVariables()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_GlobalVariables();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Root#getClones <em>Clones</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Clones</em>'.
	 * @see de.fzi.gast.core.Root#getClones()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_Clones();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Root#getStructuralAbstractions <em>Structural Abstractions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Structural Abstractions</em>'.
	 * @see de.fzi.gast.core.Root#getStructuralAbstractions()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_StructuralAbstractions();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Root#getTypes <em>Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Types</em>'.
	 * @see de.fzi.gast.core.Root#getTypes()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_Types();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Root#getDanglingModelElements <em>Dangling Model Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Dangling Model Elements</em>'.
	 * @see de.fzi.gast.core.Root#getDanglingModelElements()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_DanglingModelElements();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Root#getDirectories <em>Directories</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Directories</em>'.
	 * @see de.fzi.gast.core.Root#getDirectories()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_Directories();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Root#getPackages <em>Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Packages</em>'.
	 * @see de.fzi.gast.core.Root#getPackages()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_Packages();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.Directory <em>Directory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Directory</em>'.
	 * @see de.fzi.gast.core.Directory
	 * @generated
	 */
	EClass getDirectory();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Directory#getSubDirectory <em>Sub Directory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Sub Directory</em>'.
	 * @see de.fzi.gast.core.Directory#getSubDirectory()
	 * @see #getDirectory()
	 * @generated
	 */
	EReference getDirectory_SubDirectory();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.core.Directory#getParentDirectory <em>Parent Directory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Parent Directory</em>'.
	 * @see de.fzi.gast.core.Directory#getParentDirectory()
	 * @see #getDirectory()
	 * @generated
	 */
	EReference getDirectory_ParentDirectory();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.core.Directory#getFullqualifiedpath <em>Fullqualifiedpath</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fullqualifiedpath</em>'.
	 * @see de.fzi.gast.core.Directory#getFullqualifiedpath()
	 * @see #getDirectory()
	 * @generated
	 */
	EAttribute getDirectory_Fullqualifiedpath();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.core.Directory#getFiles <em>Files</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Files</em>'.
	 * @see de.fzi.gast.core.Directory#getFiles()
	 * @see #getDirectory()
	 * @generated
	 */
	EReference getDirectory_Files();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.core.Directory#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Root</em>'.
	 * @see de.fzi.gast.core.Directory#getRoot()
	 * @see #getDirectory()
	 * @generated
	 */
	EReference getDirectory_Root();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.PackageAlias <em>Package Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Package Alias</em>'.
	 * @see de.fzi.gast.core.PackageAlias
	 * @generated
	 */
	EClass getPackageAlias();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.core.PackageAlias#getAliasedPackage <em>Aliased Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Aliased Package</em>'.
	 * @see de.fzi.gast.core.PackageAlias#getAliasedPackage()
	 * @see #getPackageAlias()
	 * @generated
	 */
	EReference getPackageAlias_AliasedPackage();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.core.SourceEntity <em>Source Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Source Entity</em>'.
	 * @see de.fzi.gast.core.SourceEntity
	 * @generated
	 */
	EClass getSourceEntity();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.core.SourceEntity#getPosition <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Position</em>'.
	 * @see de.fzi.gast.core.SourceEntity#getPosition()
	 * @see #getSourceEntity()
	 * @generated
	 */
	EReference getSourceEntity_Position();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.core.Status <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Status</em>'.
	 * @see de.fzi.gast.core.Status
	 * @generated
	 */
	EEnum getStatus();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	coreFactory getcoreFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.PositionImpl <em>Position</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.PositionImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getPosition()
		 * @generated
		 */
		EClass POSITION = eINSTANCE.getPosition();

		/**
		 * The meta object literal for the '<em><b>End Column</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSITION__END_COLUMN = eINSTANCE.getPosition_EndColumn();

		/**
		 * The meta object literal for the '<em><b>Start Column</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSITION__START_COLUMN = eINSTANCE.getPosition_StartColumn();

		/**
		 * The meta object literal for the '<em><b>End Line</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSITION__END_LINE = eINSTANCE.getPosition_EndLine();

		/**
		 * The meta object literal for the '<em><b>Start Line</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSITION__START_LINE = eINSTANCE.getPosition_StartLine();

		/**
		 * The meta object literal for the '<em><b>Source File</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POSITION__SOURCE_FILE = eINSTANCE.getPosition_SourceFile();

		/**
		 * The meta object literal for the '<em><b>Assembly</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POSITION__ASSEMBLY = eINSTANCE.getPosition_Assembly();

		/**
		 * The meta object literal for the '<em><b>Sourceentity</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POSITION__SOURCEENTITY = eINSTANCE.getPosition_Sourceentity();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.FileImpl <em>File</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.FileImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getFile()
		 * @generated
		 */
		EClass FILE = eINSTANCE.getFile();

		/**
		 * The meta object literal for the '<em><b>Directory</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__DIRECTORY = eINSTANCE.getFile_Directory();

		/**
		 * The meta object literal for the '<em><b>Root</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__ROOT = eINSTANCE.getFile_Root();

		/**
		 * The meta object literal for the '<em><b>Imported Types</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__IMPORTED_TYPES = eINSTANCE.getFile_ImportedTypes();

		/**
		 * The meta object literal for the '<em><b>Types</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__TYPES = eINSTANCE.getFile_Types();

		/**
		 * The meta object literal for the '<em><b>Global Variables</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__GLOBAL_VARIABLES = eINSTANCE.getFile_GlobalVariables();

		/**
		 * The meta object literal for the '<em><b>Global Functions</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__GLOBAL_FUNCTIONS = eINSTANCE.getFile_GlobalFunctions();

		/**
		 * The meta object literal for the '<em><b>Source File</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FILE__SOURCE_FILE = eINSTANCE.getFile_SourceFile();

		/**
		 * The meta object literal for the '<em><b>Assembly File</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FILE__ASSEMBLY_FILE = eINSTANCE.getFile_AssemblyFile();

		/**
		 * The meta object literal for the '<em><b>Lines Of Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FILE__LINES_OF_CODE = eINSTANCE.getFile_LinesOfCode();

		/**
		 * The meta object literal for the '<em><b>Path Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FILE__PATH_NAME = eINSTANCE.getFile_PathName();

		/**
		 * The meta object literal for the '<em><b>Imported Global Functions</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__IMPORTED_GLOBAL_FUNCTIONS = eINSTANCE.getFile_ImportedGlobalFunctions();

		/**
		 * The meta object literal for the '<em><b>Imported Global Variables</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__IMPORTED_GLOBAL_VARIABLES = eINSTANCE.getFile_ImportedGlobalVariables();

		/**
		 * The meta object literal for the '<em><b>Imported Packages</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__IMPORTED_PACKAGES = eINSTANCE.getFile_ImportedPackages();

		/**
		 * The meta object literal for the '<em><b>Included Files</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE__INCLUDED_FILES = eINSTANCE.getFile_IncludedFiles();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.ModelElementImpl <em>Model Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.ModelElementImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getModelElement()
		 * @generated
		 */
		EClass MODEL_ELEMENT = eINSTANCE.getModelElement();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MODEL_ELEMENT__ANNOTATIONS = eINSTANCE.getModelElement_Annotations();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MODEL_ELEMENT__STATUS = eINSTANCE.getModelElement_Status();

		/**
		 * The meta object literal for the '<em><b>Sissy Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MODEL_ELEMENT__SISSY_ID = eINSTANCE.getModelElement_SissyId();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.IdentifierImpl <em>Identifier</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.IdentifierImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getIdentifier()
		 * @generated
		 */
		EClass IDENTIFIER = eINSTANCE.getIdentifier();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDENTIFIER__ID = eINSTANCE.getIdentifier_Id();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.NamedModelElementImpl <em>Named Model Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.NamedModelElementImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getNamedModelElement()
		 * @generated
		 */
		EClass NAMED_MODEL_ELEMENT = eINSTANCE.getNamedModelElement();

		/**
		 * The meta object literal for the '<em><b>Simple Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NAMED_MODEL_ELEMENT__SIMPLE_NAME = eINSTANCE.getNamedModelElement_SimpleName();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.PackageImpl <em>Package</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.PackageImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getPackage()
		 * @generated
		 */
		EClass PACKAGE = eINSTANCE.getPackage();

		/**
		 * The meta object literal for the '<em><b>All Local Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__ALL_LOCAL_CLASSES = eINSTANCE.getPackage_AllLocalClasses();

		/**
		 * The meta object literal for the '<em><b>All Inner Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__ALL_INNER_CLASSES = eINSTANCE.getPackage_AllInnerClasses();

		/**
		 * The meta object literal for the '<em><b>All Normal Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__ALL_NORMAL_CLASSES = eINSTANCE.getPackage_AllNormalClasses();

		/**
		 * The meta object literal for the '<em><b>All Interfaces</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__ALL_INTERFACES = eINSTANCE.getPackage_AllInterfaces();

		/**
		 * The meta object literal for the '<em><b>All Accesses</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__ALL_ACCESSES = eINSTANCE.getPackage_AllAccesses();

		/**
		 * The meta object literal for the '<em><b>Lines Of Comments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PACKAGE__LINES_OF_COMMENTS = eINSTANCE.getPackage_LinesOfComments();

		/**
		 * The meta object literal for the '<em><b>Lines Of Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PACKAGE__LINES_OF_CODE = eINSTANCE.getPackage_LinesOfCode();

		/**
		 * The meta object literal for the '<em><b>Qualified Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PACKAGE__QUALIFIED_NAME = eINSTANCE.getPackage_QualifiedName();

		/**
		 * The meta object literal for the '<em><b>Delegates</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__DELEGATES = eINSTANCE.getPackage_Delegates();

		/**
		 * The meta object literal for the '<em><b>Global Variables</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__GLOBAL_VARIABLES = eINSTANCE.getPackage_GlobalVariables();

		/**
		 * The meta object literal for the '<em><b>Global Functions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__GLOBAL_FUNCTIONS = eINSTANCE.getPackage_GlobalFunctions();

		/**
		 * The meta object literal for the '<em><b>Classes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__CLASSES = eINSTANCE.getPackage_Classes();

		/**
		 * The meta object literal for the '<em><b>Sub Packages</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__SUB_PACKAGES = eINSTANCE.getPackage_SubPackages();

		/**
		 * The meta object literal for the '<em><b>Surrounding Package</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__SURROUNDING_PACKAGE = eINSTANCE.getPackage_SurroundingPackage();

		/**
		 * The meta object literal for the '<em><b>Root</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__ROOT = eINSTANCE.getPackage_Root();

		/**
		 * The meta object literal for the '<em><b>All Accessed Packages</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__ALL_ACCESSED_PACKAGES = eINSTANCE.getPackage_AllAccessedPackages();

		/**
		 * The meta object literal for the '<em><b>Type Aliases</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__TYPE_ALIASES = eINSTANCE.getPackage_TypeAliases();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.GenericEntityImpl <em>Generic Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.GenericEntityImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getGenericEntity()
		 * @generated
		 */
		EClass GENERIC_ENTITY = eINSTANCE.getGenericEntity();

		/**
		 * The meta object literal for the '<em><b>Type Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GENERIC_ENTITY__TYPE_PARAMETERS = eINSTANCE.getGenericEntity_TypeParameters();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.RootImpl <em>Root</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.RootImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getRoot()
		 * @generated
		 */
		EClass ROOT = eINSTANCE.getRoot();

		/**
		 * The meta object literal for the '<em><b>All Accesses</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__ALL_ACCESSES = eINSTANCE.getRoot_AllAccesses();

		/**
		 * The meta object literal for the '<em><b>All Inner Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__ALL_INNER_CLASSES = eINSTANCE.getRoot_AllInnerClasses();

		/**
		 * The meta object literal for the '<em><b>All Interfaces</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__ALL_INTERFACES = eINSTANCE.getRoot_AllInterfaces();

		/**
		 * The meta object literal for the '<em><b>All Local Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__ALL_LOCAL_CLASSES = eINSTANCE.getRoot_AllLocalClasses();

		/**
		 * The meta object literal for the '<em><b>All Normal Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__ALL_NORMAL_CLASSES = eINSTANCE.getRoot_AllNormalClasses();

		/**
		 * The meta object literal for the '<em><b>All Model Elements</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__ALL_MODEL_ELEMENTS = eINSTANCE.getRoot_AllModelElements();

		/**
		 * The meta object literal for the '<em><b>Lines Of Comments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROOT__LINES_OF_COMMENTS = eINSTANCE.getRoot_LinesOfComments();

		/**
		 * The meta object literal for the '<em><b>Lines Of Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROOT__LINES_OF_CODE = eINSTANCE.getRoot_LinesOfCode();

		/**
		 * The meta object literal for the '<em><b>Global Functions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__GLOBAL_FUNCTIONS = eINSTANCE.getRoot_GlobalFunctions();

		/**
		 * The meta object literal for the '<em><b>Global Variables</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__GLOBAL_VARIABLES = eINSTANCE.getRoot_GlobalVariables();

		/**
		 * The meta object literal for the '<em><b>Clones</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__CLONES = eINSTANCE.getRoot_Clones();

		/**
		 * The meta object literal for the '<em><b>Structural Abstractions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__STRUCTURAL_ABSTRACTIONS = eINSTANCE.getRoot_StructuralAbstractions();

		/**
		 * The meta object literal for the '<em><b>Types</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__TYPES = eINSTANCE.getRoot_Types();

		/**
		 * The meta object literal for the '<em><b>Dangling Model Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__DANGLING_MODEL_ELEMENTS = eINSTANCE.getRoot_DanglingModelElements();

		/**
		 * The meta object literal for the '<em><b>Directories</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__DIRECTORIES = eINSTANCE.getRoot_Directories();

		/**
		 * The meta object literal for the '<em><b>Packages</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__PACKAGES = eINSTANCE.getRoot_Packages();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.DirectoryImpl <em>Directory</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.DirectoryImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getDirectory()
		 * @generated
		 */
		EClass DIRECTORY = eINSTANCE.getDirectory();

		/**
		 * The meta object literal for the '<em><b>Sub Directory</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DIRECTORY__SUB_DIRECTORY = eINSTANCE.getDirectory_SubDirectory();

		/**
		 * The meta object literal for the '<em><b>Parent Directory</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DIRECTORY__PARENT_DIRECTORY = eINSTANCE.getDirectory_ParentDirectory();

		/**
		 * The meta object literal for the '<em><b>Fullqualifiedpath</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DIRECTORY__FULLQUALIFIEDPATH = eINSTANCE.getDirectory_Fullqualifiedpath();

		/**
		 * The meta object literal for the '<em><b>Files</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DIRECTORY__FILES = eINSTANCE.getDirectory_Files();

		/**
		 * The meta object literal for the '<em><b>Root</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DIRECTORY__ROOT = eINSTANCE.getDirectory_Root();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.PackageAliasImpl <em>Package Alias</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.PackageAliasImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getPackageAlias()
		 * @generated
		 */
		EClass PACKAGE_ALIAS = eINSTANCE.getPackageAlias();

		/**
		 * The meta object literal for the '<em><b>Aliased Package</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE_ALIAS__ALIASED_PACKAGE = eINSTANCE.getPackageAlias_AliasedPackage();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.impl.SourceEntityImpl <em>Source Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.impl.SourceEntityImpl
		 * @see de.fzi.gast.core.impl.corePackageImpl#getSourceEntity()
		 * @generated
		 */
		EClass SOURCE_ENTITY = eINSTANCE.getSourceEntity();

		/**
		 * The meta object literal for the '<em><b>Position</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SOURCE_ENTITY__POSITION = eINSTANCE.getSourceEntity_Position();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.core.Status <em>Status</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.core.Status
		 * @see de.fzi.gast.core.impl.corePackageImpl#getStatus()
		 * @generated
		 */
		EEnum STATUS = eINSTANCE.getStatus();

	}

} //corePackage
