/**
 * <copyright>
 * </copyright>
 *
 * $Id: Root.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.core;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.annotations.Clone;
import de.fzi.gast.annotations.StructuralAbstraction;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.variables.GlobalVariable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Root</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class builds the root of the model. From here the navigation to all model elements is possible.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.core.Root#getAllAccesses <em>All Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getAllInnerClasses <em>All Inner Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getAllInterfaces <em>All Interfaces</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getAllLocalClasses <em>All Local Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getAllNormalClasses <em>All Normal Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getAllModelElements <em>All Model Elements</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getLinesOfComments <em>Lines Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getGlobalFunctions <em>Global Functions</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getGlobalVariables <em>Global Variables</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getClones <em>Clones</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getStructuralAbstractions <em>Structural Abstractions</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getTypes <em>Types</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getDanglingModelElements <em>Dangling Model Elements</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getDirectories <em>Directories</em>}</li>
 *   <li>{@link de.fzi.gast.core.Root#getPackages <em>Packages</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.core.corePackage#getRoot()
 * @model
 * @generated
 */
public interface Root extends ModelElement {
	/**
	 * Returns the value of the '<em><b>All Accesses</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.accesses.Access}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Accesses</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Accesses</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_AllAccesses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<Access> getAllAccesses();

	/**
	 * Returns the value of the '<em><b>All Inner Classes</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Inner Classes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Inner Classes</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_AllInnerClasses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<GASTClass> getAllInnerClasses();

	/**
	 * Returns the value of the '<em><b>All Interfaces</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Interfaces</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Interfaces</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_AllInterfaces()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<GASTClass> getAllInterfaces();

	/**
	 * Returns the value of the '<em><b>All Local Classes</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Local Classes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Local Classes</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_AllLocalClasses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="namespace=''"
	 * @generated
	 */
	EList<GASTClass> getAllLocalClasses();

	/**
	 * Returns the value of the '<em><b>All Normal Classes</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Normal Classes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Normal Classes</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_AllNormalClasses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="namespace=''"
	 * @generated
	 */
	EList<GASTClass> getAllNormalClasses();

	/**
	 * Returns the value of the '<em><b>All Model Elements</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.core.ModelElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a collection which contains all model elements of the model.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>All Model Elements</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_AllModelElements()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	EList<ModelElement> getAllModelElements();

	/**
	 * Returns the value of the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of lines of comments within the system.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Lines Of Comments</em>' attribute.
	 * @see de.fzi.gast.core.corePackage#getRoot_LinesOfComments()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	int getLinesOfComments();

	/**
	 * Returns the value of the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of lines of code within the system.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Lines Of Code</em>' attribute.
	 * @see de.fzi.gast.core.corePackage#getRoot_LinesOfCode()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	int getLinesOfCode();

	/**
	 * Returns the value of the '<em><b>Global Functions</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.GlobalFunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all global functions in the system.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Global Functions</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_GlobalFunctions()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<GlobalFunction> getGlobalFunctions();

	/**
	 * Returns the value of the '<em><b>Global Variables</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.variables.GlobalVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all global variables.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Global Variables</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_GlobalVariables()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<GlobalVariable> getGlobalVariables();

	/**
	 * Returns the value of the '<em><b>Clones</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.annotations.Clone}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.annotations.Clone#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all clones in the system.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Clones</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_Clones()
	 * @see de.fzi.gast.annotations.Clone#getRoot
	 * @model opposite="root" containment="true" ordered="false"
	 * @generated
	 */
	EList<Clone> getClones();

	/**
	 * Returns the value of the '<em><b>Structural Abstractions</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.annotations.StructuralAbstraction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all structural abstractions.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Structural Abstractions</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_StructuralAbstractions()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<StructuralAbstraction> getStructuralAbstractions();

	/**
	 * Returns the value of the '<em><b>Types</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all types defined or used in the system.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Types</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_Types()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<GASTType> getTypes();

	/**
	 * Returns the value of the '<em><b>Dangling Model Elements</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.core.ModelElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Dangling Model Elements</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_DanglingModelElements()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<ModelElement> getDanglingModelElements();

	/**
	 * Returns the value of the '<em><b>Directories</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.core.Directory}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Directory#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of directories.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Directories</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_Directories()
	 * @see de.fzi.gast.core.Directory#getRoot
	 * @model opposite="root" containment="true" ordered="false"
	 * @generated
	 */
	EList<Directory> getDirectories();

	/**
	 * Returns the value of the '<em><b>Packages</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.core.Package}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Package#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all packages in the system. Packages which are contained in other packages are also listed here.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Packages</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getRoot_Packages()
	 * @see de.fzi.gast.core.Package#getRoot
	 * @model opposite="root" containment="true" ordered="false"
	 * @generated
	 */
	EList<de.fzi.gast.core.Package> getPackages();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" ordered="false" nameRequired="true" nameOrdered="false"
	 * @generated
	 */
	de.fzi.gast.core.Package getPackageByName(String name);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" ordered="false" qualifiedNameRequired="true" qualifiedNameOrdered="false"
	 * @generated
	 */
	de.fzi.gast.core.Package getPackageByQualifiedName(String qualifiedName);

} // Root
