/**
 * <copyright>
 * </copyright>
 *
 * $Id: Position.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.core;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Position</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class contains information about the position of a model element within the source code.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.core.Position#getEndColumn <em>End Column</em>}</li>
 *   <li>{@link de.fzi.gast.core.Position#getStartColumn <em>Start Column</em>}</li>
 *   <li>{@link de.fzi.gast.core.Position#getEndLine <em>End Line</em>}</li>
 *   <li>{@link de.fzi.gast.core.Position#getStartLine <em>Start Line</em>}</li>
 *   <li>{@link de.fzi.gast.core.Position#getSourceFile <em>Source File</em>}</li>
 *   <li>{@link de.fzi.gast.core.Position#getAssembly <em>Assembly</em>}</li>
 *   <li>{@link de.fzi.gast.core.Position#getSourceentity <em>Sourceentity</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.core.corePackage#getPosition()
 * @model
 * @generated
 */
public interface Position extends EObject {
	/**
	 * Returns the value of the '<em><b>End Column</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the end column of the model element in source code.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>End Column</em>' attribute.
	 * @see #setEndColumn(int)
	 * @see de.fzi.gast.core.corePackage#getPosition_EndColumn()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getEndColumn();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Position#getEndColumn <em>End Column</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>End Column</em>' attribute.
	 * @see #getEndColumn()
	 * @generated
	 */
	void setEndColumn(int value);

	/**
	 * Returns the value of the '<em><b>Start Column</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the start column of the model element in source code.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start Column</em>' attribute.
	 * @see #setStartColumn(int)
	 * @see de.fzi.gast.core.corePackage#getPosition_StartColumn()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getStartColumn();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Position#getStartColumn <em>Start Column</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Column</em>' attribute.
	 * @see #getStartColumn()
	 * @generated
	 */
	void setStartColumn(int value);

	/**
	 * Returns the value of the '<em><b>End Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the end line of the model element in source code.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>End Line</em>' attribute.
	 * @see #setEndLine(int)
	 * @see de.fzi.gast.core.corePackage#getPosition_EndLine()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getEndLine();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Position#getEndLine <em>End Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>End Line</em>' attribute.
	 * @see #getEndLine()
	 * @generated
	 */
	void setEndLine(int value);

	/**
	 * Returns the value of the '<em><b>Start Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the start line of the model element in source code.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start Line</em>' attribute.
	 * @see #setStartLine(int)
	 * @see de.fzi.gast.core.corePackage#getPosition_StartLine()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getStartLine();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Position#getStartLine <em>Start Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Line</em>' attribute.
	 * @see #getStartLine()
	 * @generated
	 */
	void setStartLine(int value);

	/**
	 * Returns the value of the '<em><b>Source File</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the object which represents the file in which the model element is declared.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Source File</em>' reference.
	 * @see #setSourceFile(File)
	 * @see de.fzi.gast.core.corePackage#getPosition_SourceFile()
	 * @model ordered="false"
	 * @generated
	 */
	File getSourceFile();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Position#getSourceFile <em>Source File</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source File</em>' reference.
	 * @see #getSourceFile()
	 * @generated
	 */
	void setSourceFile(File value);

	/**
	 * Returns the value of the '<em><b>Assembly</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the object which represents the compiled file in which the model element is declared.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Assembly</em>' reference.
	 * @see #setAssembly(File)
	 * @see de.fzi.gast.core.corePackage#getPosition_Assembly()
	 * @model ordered="false"
	 * @generated
	 */
	File getAssembly();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Position#getAssembly <em>Assembly</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Assembly</em>' reference.
	 * @see #getAssembly()
	 * @generated
	 */
	void setAssembly(File value);

	/**
	 * Returns the value of the '<em><b>Sourceentity</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.SourceEntity#getPosition <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sourceentity</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sourceentity</em>' container reference.
	 * @see #setSourceentity(SourceEntity)
	 * @see de.fzi.gast.core.corePackage#getPosition_Sourceentity()
	 * @see de.fzi.gast.core.SourceEntity#getPosition
	 * @model opposite="position" required="true" transient="false" ordered="false"
	 * @generated
	 */
	SourceEntity getSourceentity();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Position#getSourceentity <em>Sourceentity</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sourceentity</em>' container reference.
	 * @see #getSourceentity()
	 * @generated
	 */
	void setSourceentity(SourceEntity value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This OCL constraint ensures that either the assembly attribute or the sourceFile attribute is set.
	 * (self.assembly = null) xor (self.sourceFile = null)
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model
	 * @generated
	 */
	boolean EitherAssemblyFileOrSourceFileSet(DiagnosticChain diagnostics, Map<Object, Object> context);

} // Position
