/**
 * <copyright>
 * </copyright>
 *
 * $Id: Package.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.core;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.functions.Delegate;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.TypeAlias;
import de.fzi.gast.variables.GlobalVariable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Package</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a package or a namespace.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.core.Package#getAllLocalClasses <em>All Local Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getAllInnerClasses <em>All Inner Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getAllNormalClasses <em>All Normal Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getAllInterfaces <em>All Interfaces</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getAllAccesses <em>All Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getDelegates <em>Delegates</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getGlobalFunctions <em>Global Functions</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getGlobalVariables <em>Global Variables</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getLinesOfComments <em>Lines Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getQualifiedName <em>Qualified Name</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getClasses <em>Classes</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getSubPackages <em>Sub Packages</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getSurroundingPackage <em>Surrounding Package</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getRoot <em>Root</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getAllAccessedPackages <em>All Accessed Packages</em>}</li>
 *   <li>{@link de.fzi.gast.core.Package#getTypeAliases <em>Type Aliases</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.core.corePackage#getPackage()
 * @model
 * @generated
 */
public interface Package extends NamedModelElement {
	/**
	 * Returns the value of the '<em><b>All Local Classes</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Local Classes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Local Classes</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_AllLocalClasses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<GASTClass> getAllLocalClasses();

	/**
	 * Returns the value of the '<em><b>All Inner Classes</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Inner Classes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Inner Classes</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_AllInnerClasses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<GASTClass> getAllInnerClasses();

	/**
	 * Returns the value of the '<em><b>All Normal Classes</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Normal Classes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Normal Classes</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_AllNormalClasses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<GASTClass> getAllNormalClasses();

	/**
	 * Returns the value of the '<em><b>All Interfaces</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Interfaces</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Interfaces</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_AllInterfaces()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	EList<GASTClass> getAllInterfaces();

	/**
	 * Returns the value of the '<em><b>All Accesses</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.accesses.Access}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Accesses</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Accesses</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_AllAccesses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<Access> getAllAccesses();

	/**
	 * Returns the value of the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lines Of Comments</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lines Of Comments</em>' attribute.
	 * @see de.fzi.gast.core.corePackage#getPackage_LinesOfComments()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	int getLinesOfComments();

	/**
	 * Returns the value of the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lines Of Code</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lines Of Code</em>' attribute.
	 * @see de.fzi.gast.core.corePackage#getPackage_LinesOfCode()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	int getLinesOfCode();

	/**
	 * Returns the value of the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the fully qualified name of this package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Qualified Name</em>' attribute.
	 * @see de.fzi.gast.core.corePackage#getPackage_QualifiedName()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	String getQualifiedName();

	/**
	 * Returns the value of the '<em><b>Delegates</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.Delegate}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Delegate#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all delegates which are directly defined in this package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Delegates</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_Delegates()
	 * @see de.fzi.gast.functions.Delegate#getSurroundingPackage
	 * @model opposite="surroundingPackage" containment="true" ordered="false"
	 * @generated
	 */
	EList<Delegate> getDelegates();

	/**
	 * Returns the value of the '<em><b>Global Variables</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.variables.GlobalVariable}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.variables.GlobalVariable#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all global variables which are directly defined in this package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Global Variables</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_GlobalVariables()
	 * @see de.fzi.gast.variables.GlobalVariable#getSurroundingPackage
	 * @model opposite="surroundingPackage" containment="true" ordered="false"
	 * @generated
	 */
	EList<GlobalVariable> getGlobalVariables();

	/**
	 * Returns the value of the '<em><b>Global Functions</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.GlobalFunction}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.GlobalFunction#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all global functions which are directly defined in this package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Global Functions</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_GlobalFunctions()
	 * @see de.fzi.gast.functions.GlobalFunction#getSurroundingPackage
	 * @model opposite="surroundingPackage" containment="true" ordered="false"
	 * @generated
	 */
	EList<GlobalFunction> getGlobalFunctions();

	/**
	 * Returns the value of the '<em><b>Classes</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all classes contained in this package. Does not contain classes which are located in subpackages.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Classes</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_Classes()
	 * @see de.fzi.gast.types.GASTClass#getSurroundingPackage
	 * @model opposite="surroundingPackage" containment="true" ordered="false"
	 * @generated
	 */
	EList<GASTClass> getClasses();

	/**
	 * Returns the value of the '<em><b>Sub Packages</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.core.Package}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Package#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all packages which are contained in this package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Sub Packages</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_SubPackages()
	 * @see de.fzi.gast.core.Package#getSurroundingPackage
	 * @model opposite="surroundingPackage" containment="true" ordered="false"
	 * @generated
	 */
	EList<Package> getSubPackages();

	/**
	 * Returns the value of the '<em><b>Surrounding Package</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Package#getSubPackages <em>Sub Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the surrounding package of this package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Package</em>' container reference.
	 * @see #setSurroundingPackage(Package)
	 * @see de.fzi.gast.core.corePackage#getPackage_SurroundingPackage()
	 * @see de.fzi.gast.core.Package#getSubPackages
	 * @model opposite="subPackages" transient="false" ordered="false"
	 * @generated
	 */
	Package getSurroundingPackage();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Package#getSurroundingPackage <em>Surrounding Package</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Package</em>' container reference.
	 * @see #getSurroundingPackage()
	 * @generated
	 */
	void setSurroundingPackage(Package value);

	/**
	 * Returns the value of the '<em><b>Root</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Root#getPackages <em>Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Root</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Root</em>' container reference.
	 * @see #setRoot(Root)
	 * @see de.fzi.gast.core.corePackage#getPackage_Root()
	 * @see de.fzi.gast.core.Root#getPackages
	 * @model opposite="packages" transient="false" ordered="false"
	 * @generated
	 */
	Root getRoot();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Package#getRoot <em>Root</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Root</em>' container reference.
	 * @see #getRoot()
	 * @generated
	 */
	void setRoot(Root value);

	/**
	 * Returns the value of the '<em><b>All Accessed Packages</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.core.Package}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Accessed Packages</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Accessed Packages</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_AllAccessedPackages()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<Package> getAllAccessedPackages();

	/**
	 * Returns the value of the '<em><b>Type Aliases</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.types.TypeAlias}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.TypeAlias#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all type aliases which are directly defined in this package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type Aliases</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getPackage_TypeAliases()
	 * @see de.fzi.gast.types.TypeAlias#getSurroundingPackage
	 * @model opposite="surroundingPackage" containment="true" ordered="false"
	 * @generated
	 */
	EList<TypeAlias> getTypeAliases();

} // Package
