/**
 * <copyright>
 * </copyright>
 *
 * $Id: ModelElement.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.core;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.annotations.ModelAnnotation;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Model Element</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This entity is a super class for all classes which are part of the model. It helps to ensure that each model element can be identified by a unique identifier.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.core.ModelElement#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link de.fzi.gast.core.ModelElement#getStatus <em>Status</em>}</li>
 *   <li>{@link de.fzi.gast.core.ModelElement#getSissyId <em>Sissy Id</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.core.corePackage#getModelElement()
 * @model abstract="true"
 * @generated
 */
public interface ModelElement extends Identifier {
	/**
	 * Returns the value of the '<em><b>Annotations</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.annotations.ModelAnnotation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collection with references to the model annotations annotating this model element.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Annotations</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getModelElement_Annotations()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<ModelAnnotation> getAnnotations();

	/**
	 * Returns the value of the '<em><b>Status</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.core.Status}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Contains the status of the model element. It can contain the following values: "normal" for model elements which are extracted from source code, "library" for model elements which are extracted from a library, "implicit" for model elements which are implicitly specified in source code and "failed dependency" for model elements which have no definition either in source code nor in a library.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Status</em>' attribute.
	 * @see de.fzi.gast.core.Status
	 * @see #setStatus(Status)
	 * @see de.fzi.gast.core.corePackage#getModelElement_Status()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Status getStatus();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.ModelElement#getStatus <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Status</em>' attribute.
	 * @see de.fzi.gast.core.Status
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(Status value);

	/**
	 * Returns the value of the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Contains the unique identifier of a model element which is set by SISSy. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Sissy Id</em>' attribute.
	 * @see #setSissyId(int)
	 * @see de.fzi.gast.core.corePackage#getModelElement_SissyId()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getSissyId();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.ModelElement#getSissyId <em>Sissy Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sissy Id</em>' attribute.
	 * @see #getSissyId()
	 * @generated
	 */
	void setSissyId(int value);

} // ModelElement
