/**
 * <copyright>
 * </copyright>
 *
 * $Id: GenericEntity.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.core;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.types.TypeParameterClass;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Generic Entity</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class is the common base for generic function and generic class. Generic entities can have a set of type parameters.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.core.GenericEntity#getTypeParameters <em>Type Parameters</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.core.corePackage#getGenericEntity()
 * @model abstract="true"
 * @generated
 */
public interface GenericEntity extends ModelElement {
	/**
	 * Returns the value of the '<em><b>Type Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.types.TypeParameterClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the type parameters of this generic entity.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type Parameters</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getGenericEntity_TypeParameters()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<TypeParameterClass> getTypeParameters();

} // GenericEntity
