/**
 * <copyright>
 * </copyright>
 *
 * $Id: File.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.core;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.variables.GlobalVariable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>File</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents an analysed source file or an assembly file.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.core.File#getDirectory <em>Directory</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getRoot <em>Root</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#isSourceFile <em>Source File</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#isAssemblyFile <em>Assembly File</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getImportedTypes <em>Imported Types</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getTypes <em>Types</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getGlobalVariables <em>Global Variables</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getGlobalFunctions <em>Global Functions</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getPathName <em>Path Name</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getImportedGlobalFunctions <em>Imported Global Functions</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getImportedGlobalVariables <em>Imported Global Variables</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getImportedPackages <em>Imported Packages</em>}</li>
 *   <li>{@link de.fzi.gast.core.File#getIncludedFiles <em>Included Files</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.core.corePackage#getFile()
 * @model
 * @generated
 */
public interface File extends ModelElement {
	/**
	 * Returns the value of the '<em><b>Directory</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Directory#getFiles <em>Files</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the directory in which the given file is contained.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Directory</em>' container reference.
	 * @see #setDirectory(Directory)
	 * @see de.fzi.gast.core.corePackage#getFile_Directory()
	 * @see de.fzi.gast.core.Directory#getFiles
	 * @model opposite="files" required="true" transient="false" ordered="false"
	 * @generated
	 */
	Directory getDirectory();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.File#getDirectory <em>Directory</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Directory</em>' container reference.
	 * @see #getDirectory()
	 * @generated
	 */
	void setDirectory(Directory value);

	/**
	 * Returns the value of the '<em><b>Root</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Root</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Root</em>' reference.
	 * @see de.fzi.gast.core.corePackage#getFile_Root()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	Root getRoot();

	/**
	 * Returns the value of the '<em><b>Imported Types</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of types which are directly imported by this file.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Imported Types</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getFile_ImportedTypes()
	 * @model ordered="false"
	 * @generated
	 */
	EList<GASTType> getImportedTypes();

	/**
	 * Returns the value of the '<em><b>Types</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all types which are directly defined in this file.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Types</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getFile_Types()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<GASTType> getTypes();

	/**
	 * Returns the value of the '<em><b>Global Variables</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.variables.GlobalVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all global variables which are directly defined in this file.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Global Variables</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getFile_GlobalVariables()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<GlobalVariable> getGlobalVariables();

	/**
	 * Returns the value of the '<em><b>Global Functions</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.GlobalFunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all global functions which are directly defined in this file.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Global Functions</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getFile_GlobalFunctions()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<GlobalFunction> getGlobalFunctions();

	/**
	 * Returns the value of the '<em><b>Source File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this is source file.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Source File</em>' attribute.
	 * @see #setSourceFile(boolean)
	 * @see de.fzi.gast.core.corePackage#getFile_SourceFile()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isSourceFile();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.File#isSourceFile <em>Source File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source File</em>' attribute.
	 * @see #isSourceFile()
	 * @generated
	 */
	void setSourceFile(boolean value);

	/**
	 * Returns the value of the '<em><b>Assembly File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if it is a compiled unit (compiled assembly, JAR file or delphi package).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Assembly File</em>' attribute.
	 * @see de.fzi.gast.core.corePackage#getFile_AssemblyFile()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	boolean isAssemblyFile();

	/**
	 * Returns the value of the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the Number of code lines. (What definiton of the lines of code metric actually is used depends on the extraction tools, for details please refer to the documentation of the extraction tools)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Lines Of Code</em>' attribute.
	 * @see #setLinesOfCode(int)
	 * @see de.fzi.gast.core.corePackage#getFile_LinesOfCode()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getLinesOfCode();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.File#getLinesOfCode <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Lines Of Code</em>' attribute.
	 * @see #getLinesOfCode()
	 * @generated
	 */
	void setLinesOfCode(int value);

	/**
	 * Returns the value of the '<em><b>Path Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the file name of this file in the file system, if possible with a file path.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Path Name</em>' attribute.
	 * @see #setPathName(String)
	 * @see de.fzi.gast.core.corePackage#getFile_PathName()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getPathName();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.File#getPathName <em>Path Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Path Name</em>' attribute.
	 * @see #getPathName()
	 * @generated
	 */
	void setPathName(String value);

	/**
	 * Returns the value of the '<em><b>Imported Global Functions</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.GlobalFunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of global functions which are directly imported by this file.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Imported Global Functions</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getFile_ImportedGlobalFunctions()
	 * @model ordered="false"
	 * @generated
	 */
	EList<GlobalFunction> getImportedGlobalFunctions();

	/**
	 * Returns the value of the '<em><b>Imported Global Variables</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.variables.GlobalVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of global variables which are directly imported by this file. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Imported Global Variables</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getFile_ImportedGlobalVariables()
	 * @model ordered="false"
	 * @generated
	 */
	EList<GlobalVariable> getImportedGlobalVariables();

	/**
	 * Returns the value of the '<em><b>Imported Packages</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.core.Package}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of packages which are directly imported by this file.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Imported Packages</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getFile_ImportedPackages()
	 * @model ordered="false"
	 * @generated
	 */
	EList<de.fzi.gast.core.Package> getImportedPackages();

	/**
	 * Returns the value of the '<em><b>Included Files</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.core.File}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of files which are directly imported by this file.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Included Files</em>' reference list.
	 * @see de.fzi.gast.core.corePackage#getFile_IncludedFiles()
	 * @model ordered="false"
	 * @generated
	 */
	EList<File> getIncludedFiles();

} // File
