/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.core;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Directory</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a directory in file system.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.core.Directory#getSubDirectory <em>Sub Directory</em>}</li>
 *   <li>{@link de.fzi.gast.core.Directory#getParentDirectory <em>Parent Directory</em>}</li>
 *   <li>{@link de.fzi.gast.core.Directory#getFullqualifiedpath <em>Fullqualifiedpath</em>}</li>
 *   <li>{@link de.fzi.gast.core.Directory#getFiles <em>Files</em>}</li>
 *   <li>{@link de.fzi.gast.core.Directory#getRoot <em>Root</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.core.corePackage#getDirectory()
 * @model
 * @generated
 */
public interface Directory extends NamedModelElement {
	/**
	 * Returns the value of the '<em><b>Sub Directory</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.core.Directory}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Directory#getParentDirectory <em>Parent Directory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents subdirectories of this directory.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Sub Directory</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getDirectory_SubDirectory()
	 * @see de.fzi.gast.core.Directory#getParentDirectory
	 * @model opposite="parentDirectory" containment="true" ordered="false"
	 * @generated
	 */
	EList<Directory> getSubDirectory();

	/**
	 * Returns the value of the '<em><b>Parent Directory</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Directory#getSubDirectory <em>Sub Directory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the parent directory.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Parent Directory</em>' container reference.
	 * @see #setParentDirectory(Directory)
	 * @see de.fzi.gast.core.corePackage#getDirectory_ParentDirectory()
	 * @see de.fzi.gast.core.Directory#getSubDirectory
	 * @model opposite="subDirectory" transient="false" ordered="false"
	 * @generated
	 */
	Directory getParentDirectory();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Directory#getParentDirectory <em>Parent Directory</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent Directory</em>' container reference.
	 * @see #getParentDirectory()
	 * @generated
	 */
	void setParentDirectory(Directory value);

	/**
	 * Returns the value of the '<em><b>Fullqualifiedpath</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Fullqualifiedpath</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Fullqualifiedpath</em>' attribute.
	 * @see de.fzi.gast.core.corePackage#getDirectory_Fullqualifiedpath()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	String getFullqualifiedpath();

	/**
	 * Returns the value of the '<em><b>Files</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.core.File}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.File#getDirectory <em>Directory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of files which are contained in a directory.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Files</em>' containment reference list.
	 * @see de.fzi.gast.core.corePackage#getDirectory_Files()
	 * @see de.fzi.gast.core.File#getDirectory
	 * @model opposite="directory" containment="true" ordered="false"
	 * @generated
	 */
	EList<File> getFiles();

	/**
	 * Returns the value of the '<em><b>Root</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Root#getDirectories <em>Directories</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Root</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Root</em>' container reference.
	 * @see #setRoot(Root)
	 * @see de.fzi.gast.core.corePackage#getDirectory_Root()
	 * @see de.fzi.gast.core.Root#getDirectories
	 * @model opposite="directories" required="true" transient="false" ordered="false"
	 * @generated
	 */
	Root getRoot();

	/**
	 * Sets the value of the '{@link de.fzi.gast.core.Directory#getRoot <em>Root</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Root</em>' container reference.
	 * @see #getRoot()
	 * @generated
	 */
	void setRoot(Root value);

} // Directory
