/**
 * <copyright>
 * </copyright>
 *
 * $Id: annotationsValidator.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.annotations.util;

import de.fzi.gast.annotations.*;
import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

import de.fzi.gast.annotations.Attribute;
import de.fzi.gast.annotations.Clone;
import de.fzi.gast.annotations.CloneInstance;
import de.fzi.gast.annotations.Comment;
import de.fzi.gast.annotations.Layer;
import de.fzi.gast.annotations.ModelAnnotation;
import de.fzi.gast.annotations.StructuralAbstraction;
import de.fzi.gast.annotations.Subsystem;
import de.fzi.gast.annotations.annotationsPackage;
import de.fzi.gast.core.util.coreValidator;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see de.fzi.gast.annotations.annotationsPackage
 * @generated
 */
public class annotationsValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final annotationsValidator INSTANCE = new annotationsValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "de.fzi.gast.annotations";

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'OC Ltodo' of 'Comment'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int COMMENT__OC_LTODO = 1;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected coreValidator _coreValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public annotationsValidator() {
		super();
		_coreValidator = coreValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return annotationsPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case annotationsPackage.ATTRIBUTE:
				return validateAttribute((Attribute)value, diagnostics, context);
			case annotationsPackage.CLONE:
				return validateClone((Clone)value, diagnostics, context);
			case annotationsPackage.CLONE_INSTANCE:
				return validateCloneInstance((CloneInstance)value, diagnostics, context);
			case annotationsPackage.STRUCTURAL_ABSTRACTION:
				return validateStructuralAbstraction((StructuralAbstraction)value, diagnostics, context);
			case annotationsPackage.COMMENT:
				return validateComment((Comment)value, diagnostics, context);
			case annotationsPackage.SUBSYSTEM:
				return validateSubsystem((Subsystem)value, diagnostics, context);
			case annotationsPackage.LAYER:
				return validateLayer((Layer)value, diagnostics, context);
			case annotationsPackage.MODEL_ANNOTATION:
				return validateModelAnnotation((ModelAnnotation)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAttribute(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(attribute, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(attribute, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(attribute, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(attribute, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(attribute, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(attribute, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(attribute, diagnostics, context);
		if (result || diagnostics != null) result &= _coreValidator.validateIdentifier_idHasToBeUnique(attribute, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateClone(Clone clone, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(clone, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(clone, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(clone, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(clone, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(clone, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(clone, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(clone, diagnostics, context);
		if (result || diagnostics != null) result &= _coreValidator.validateIdentifier_idHasToBeUnique(clone, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCloneInstance(CloneInstance cloneInstance, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(cloneInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(cloneInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(cloneInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(cloneInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(cloneInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(cloneInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(cloneInstance, diagnostics, context);
		if (result || diagnostics != null) result &= _coreValidator.validateIdentifier_idHasToBeUnique(cloneInstance, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateStructuralAbstraction(StructuralAbstraction structuralAbstraction, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(structuralAbstraction, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(structuralAbstraction, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(structuralAbstraction, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(structuralAbstraction, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(structuralAbstraction, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(structuralAbstraction, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(structuralAbstraction, diagnostics, context);
		if (result || diagnostics != null) result &= _coreValidator.validateIdentifier_idHasToBeUnique(structuralAbstraction, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateComment(Comment comment, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(comment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(comment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(comment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(comment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(comment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(comment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(comment, diagnostics, context);
		if (result || diagnostics != null) result &= _coreValidator.validateIdentifier_idHasToBeUnique(comment, diagnostics, context);
		if (result || diagnostics != null) result &= validateComment_OCLtodo(comment, diagnostics, context);
		return result;
	}

	/**
	 * Validates the OCLtodo constraint of '<em>Comment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateComment_OCLtodo(Comment comment, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return comment.OCLtodo(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSubsystem(Subsystem subsystem, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(subsystem, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(subsystem, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(subsystem, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(subsystem, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(subsystem, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(subsystem, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(subsystem, diagnostics, context);
		if (result || diagnostics != null) result &= _coreValidator.validateIdentifier_idHasToBeUnique(subsystem, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLayer(Layer layer, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(layer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(layer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(layer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(layer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(layer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(layer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(layer, diagnostics, context);
		if (result || diagnostics != null) result &= _coreValidator.validateIdentifier_idHasToBeUnique(layer, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateModelAnnotation(ModelAnnotation modelAnnotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(modelAnnotation, diagnostics, context);
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //annotationsValidator
