/**
 * <copyright>
 * </copyright>
 *
 * $Id: CommentImpl.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.annotations.impl;

import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectValidator;

import de.fzi.gast.annotations.Comment;
import de.fzi.gast.annotations.annotationsPackage;
import de.fzi.gast.annotations.util.annotationsValidator;
import de.fzi.gast.core.impl.SourceEntityImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Comment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.annotations.impl.CommentImpl#isTodo <em>Todo</em>}</li>
 *   <li>{@link de.fzi.gast.annotations.impl.CommentImpl#isFormal <em>Formal</em>}</li>
 *   <li>{@link de.fzi.gast.annotations.impl.CommentImpl#getTodoCount <em>Todo Count</em>}</li>
 *   <li>{@link de.fzi.gast.annotations.impl.CommentImpl#getTexts <em>Texts</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CommentImpl extends SourceEntityImpl implements Comment {
	/**
	 * The default value of the '{@link #isTodo() <em>Todo</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isTodo()
	 * @generated
	 * @ordered
	 */
	protected static final boolean TODO_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isFormal() <em>Formal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFormal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FORMAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFormal() <em>Formal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFormal()
	 * @generated
	 * @ordered
	 */
	protected boolean formal = FORMAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getTodoCount() <em>Todo Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTodoCount()
	 * @generated
	 * @ordered
	 */
	protected static final int TODO_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTodoCount() <em>Todo Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTodoCount()
	 * @generated
	 * @ordered
	 */
	protected int todoCount = TODO_COUNT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTexts() <em>Texts</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTexts()
	 * @generated
	 * @ordered
	 */
	protected EList<String> texts;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return annotationsPackage.Literals.COMMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isTodo() {
		return todoCount > 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetTodo() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFormal() {
		return formal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFormal(boolean newFormal) {
		boolean oldFormal = formal;
		formal = newFormal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, annotationsPackage.COMMENT__FORMAL, oldFormal, formal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTodoCount() {
		return todoCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTodoCount(int newTodoCount) {
		int oldTodoCount = todoCount;
		todoCount = newTodoCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, annotationsPackage.COMMENT__TODO_COUNT, oldTodoCount, todoCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getTexts() {
		if (texts == null) {
			texts = new EDataTypeUniqueEList<String>(String.class, this, annotationsPackage.COMMENT__TEXTS);
		}
		return texts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean OCLtodo(DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO: implement this method
		// -> specify the condition that violates the invariant
		// -> verify the details of the diagnostic, including severity and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 annotationsValidator.DIAGNOSTIC_SOURCE,
						 annotationsValidator.COMMENT__OC_LTODO,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "OCLtodo", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case annotationsPackage.COMMENT__TODO:
				return isTodo();
			case annotationsPackage.COMMENT__FORMAL:
				return isFormal();
			case annotationsPackage.COMMENT__TODO_COUNT:
				return getTodoCount();
			case annotationsPackage.COMMENT__TEXTS:
				return getTexts();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case annotationsPackage.COMMENT__FORMAL:
				setFormal((Boolean)newValue);
				return;
			case annotationsPackage.COMMENT__TODO_COUNT:
				setTodoCount((Integer)newValue);
				return;
			case annotationsPackage.COMMENT__TEXTS:
				getTexts().clear();
				getTexts().addAll((Collection<? extends String>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case annotationsPackage.COMMENT__FORMAL:
				setFormal(FORMAL_EDEFAULT);
				return;
			case annotationsPackage.COMMENT__TODO_COUNT:
				setTodoCount(TODO_COUNT_EDEFAULT);
				return;
			case annotationsPackage.COMMENT__TEXTS:
				getTexts().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case annotationsPackage.COMMENT__TODO:
				return isSetTodo();
			case annotationsPackage.COMMENT__FORMAL:
				return formal != FORMAL_EDEFAULT;
			case annotationsPackage.COMMENT__TODO_COUNT:
				return todoCount != TODO_COUNT_EDEFAULT;
			case annotationsPackage.COMMENT__TEXTS:
				return texts != null && !texts.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (formal: ");
		result.append(formal);
		result.append(", todoCount: ");
		result.append(todoCount);
		result.append(", texts: ");
		result.append(texts);
		result.append(')');
		return result.toString();
	}

} //CommentImpl
