/**
 * <copyright>
 * </copyright>
 *
 * $Id: annotationsPackage.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.annotations;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.gast.core.corePackage;
import de.fzi.gast.types.typesPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This packages is for model annotations. By implementing the model annotation interfaces arbitrary information can be attached to model elements. Some special kinds of annotations are already provided in this package.
 * <!-- end-model-doc -->
 * @see de.fzi.gast.annotations.annotationsFactory
 * @model kind="package"
 * @generated
 */
public interface annotationsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "annotations";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.fzi.de/gast/annotations";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "annotations";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	annotationsPackage eINSTANCE = de.fzi.gast.annotations.impl.annotationsPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.fzi.gast.annotations.impl.AttributeImpl <em>Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.annotations.impl.AttributeImpl
	 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getAttribute()
	 * @generated
	 */
	int ATTRIBUTE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ID = typesPackage.GAST_CLASS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ANNOTATIONS = typesPackage.GAST_CLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__STATUS = typesPackage.GAST_CLASS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SISSY_ID = typesPackage.GAST_CLASS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__POSITION = typesPackage.GAST_CLASS__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__VISIBILITY = typesPackage.GAST_CLASS__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__OVERRIDDEN_MEMBER = typesPackage.GAST_CLASS__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ABSTRACT = typesPackage.GAST_CLASS__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__EXTERN = typesPackage.GAST_CLASS__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__FINAL = typesPackage.GAST_CLASS__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INTERNAL = typesPackage.GAST_CLASS__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INTROSPECTABLE = typesPackage.GAST_CLASS__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__OVERRIDE = typesPackage.GAST_CLASS__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__STATIC = typesPackage.GAST_CLASS__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__TYPE_PARAMETER_CLASS_MEMBER = typesPackage.GAST_CLASS__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__VIRTUAL = typesPackage.GAST_CLASS__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SIMPLE_NAME = typesPackage.GAST_CLASS__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__QUALIFIED_NAME = typesPackage.GAST_CLASS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__REFERENCE_TYPE = typesPackage.GAST_CLASS__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Inner Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INNER_TYPE_ALIASES = typesPackage.GAST_CLASS__INNER_TYPE_ALIASES;

	/**
	 * The feature id for the '<em><b>Inner Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INNER_DELEGATES = typesPackage.GAST_CLASS__INNER_DELEGATES;

	/**
	 * The feature id for the '<em><b>Constructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__CONSTRUCTORS = typesPackage.GAST_CLASS__CONSTRUCTORS;

	/**
	 * The feature id for the '<em><b>Destructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__DESTRUCTORS = typesPackage.GAST_CLASS__DESTRUCTORS;

	/**
	 * The feature id for the '<em><b>Fields</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__FIELDS = typesPackage.GAST_CLASS__FIELDS;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__METHODS = typesPackage.GAST_CLASS__METHODS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SURROUNDING_FUNCTION = typesPackage.GAST_CLASS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SURROUNDING_PACKAGE = typesPackage.GAST_CLASS__SURROUNDING_PACKAGE;

	/**
	 * The feature id for the '<em><b>Super Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SUPER_TYPES = typesPackage.GAST_CLASS__SUPER_TYPES;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__LINES_OF_COMMENTS = typesPackage.GAST_CLASS__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__LOCAL = typesPackage.GAST_CLASS__LOCAL;

	/**
	 * The feature id for the '<em><b>Primitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__PRIMITIVE = typesPackage.GAST_CLASS__PRIMITIVE;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INTERFACE = typesPackage.GAST_CLASS__INTERFACE;

	/**
	 * The feature id for the '<em><b>Anonymous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ANONYMOUS = typesPackage.GAST_CLASS__ANONYMOUS;

	/**
	 * The feature id for the '<em><b>Inner Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INNER_CLASSES = typesPackage.GAST_CLASS__INNER_CLASSES;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SURROUNDING_CLASS = typesPackage.GAST_CLASS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Inheritance Type Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INHERITANCE_TYPE_ACCESSES = typesPackage.GAST_CLASS__INHERITANCE_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SELF = typesPackage.GAST_CLASS__SELF;

	/**
	 * The feature id for the '<em><b>Friend Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__FRIEND_CLASSES = typesPackage.GAST_CLASS__FRIEND_CLASSES;

	/**
	 * The feature id for the '<em><b>Friend Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__FRIEND_FUNCTIONS = typesPackage.GAST_CLASS__FRIEND_FUNCTIONS;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__PROPERTY = typesPackage.GAST_CLASS__PROPERTY;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ALL_ACCESSES = typesPackage.GAST_CLASS__ALL_ACCESSES;

	/**
	 * The feature id for the '<em><b>All Accessed Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ALL_ACCESSED_CLASSES = typesPackage.GAST_CLASS__ALL_ACCESSED_CLASSES;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INNER = typesPackage.GAST_CLASS__INNER;

	/**
	 * The number of structural features of the '<em>Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_FEATURE_COUNT = typesPackage.GAST_CLASS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.annotations.impl.CloneImpl <em>Clone</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.annotations.impl.CloneImpl
	 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getClone()
	 * @generated
	 */
	int CLONE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE__ID = corePackage.MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE__ANNOTATIONS = corePackage.MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE__STATUS = corePackage.MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE__SISSY_ID = corePackage.MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Clone Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE__CLONE_INSTANCES = corePackage.MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Root</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE__ROOT = corePackage.MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Clone</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE_FEATURE_COUNT = corePackage.MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.annotations.impl.CloneInstanceImpl <em>Clone Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.annotations.impl.CloneInstanceImpl
	 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getCloneInstance()
	 * @generated
	 */
	int CLONE_INSTANCE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE_INSTANCE__ID = corePackage.MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE_INSTANCE__ANNOTATIONS = corePackage.MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE_INSTANCE__STATUS = corePackage.MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE_INSTANCE__SISSY_ID = corePackage.MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Statements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE_INSTANCE__STATEMENTS = corePackage.MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clone</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE_INSTANCE__CLONE = corePackage.MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Clone Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLONE_INSTANCE_FEATURE_COUNT = corePackage.MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.annotations.impl.StructuralAbstractionImpl <em>Structural Abstraction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.annotations.impl.StructuralAbstractionImpl
	 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getStructuralAbstraction()
	 * @generated
	 */
	int STRUCTURAL_ABSTRACTION = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURAL_ABSTRACTION__ID = corePackage.NAMED_MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURAL_ABSTRACTION__ANNOTATIONS = corePackage.NAMED_MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURAL_ABSTRACTION__STATUS = corePackage.NAMED_MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURAL_ABSTRACTION__SISSY_ID = corePackage.NAMED_MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURAL_ABSTRACTION__SIMPLE_NAME = corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME;

	/**
	 * The number of structural features of the '<em>Structural Abstraction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURAL_ABSTRACTION_FEATURE_COUNT = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.annotations.impl.CommentImpl <em>Comment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.annotations.impl.CommentImpl
	 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getComment()
	 * @generated
	 */
	int COMMENT = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__ID = corePackage.SOURCE_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__ANNOTATIONS = corePackage.SOURCE_ENTITY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__STATUS = corePackage.SOURCE_ENTITY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__SISSY_ID = corePackage.SOURCE_ENTITY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__POSITION = corePackage.SOURCE_ENTITY__POSITION;

	/**
	 * The feature id for the '<em><b>Todo</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__TODO = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Formal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__FORMAL = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Todo Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__TODO_COUNT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Texts</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__TEXTS = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Comment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT_FEATURE_COUNT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.fzi.gast.annotations.impl.SubsystemImpl <em>Subsystem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.annotations.impl.SubsystemImpl
	 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getSubsystem()
	 * @generated
	 */
	int SUBSYSTEM = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBSYSTEM__ID = STRUCTURAL_ABSTRACTION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBSYSTEM__ANNOTATIONS = STRUCTURAL_ABSTRACTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBSYSTEM__STATUS = STRUCTURAL_ABSTRACTION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBSYSTEM__SISSY_ID = STRUCTURAL_ABSTRACTION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBSYSTEM__SIMPLE_NAME = STRUCTURAL_ABSTRACTION__SIMPLE_NAME;

	/**
	 * The number of structural features of the '<em>Subsystem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBSYSTEM_FEATURE_COUNT = STRUCTURAL_ABSTRACTION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.annotations.impl.LayerImpl <em>Layer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.annotations.impl.LayerImpl
	 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getLayer()
	 * @generated
	 */
	int LAYER = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAYER__ID = STRUCTURAL_ABSTRACTION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAYER__ANNOTATIONS = STRUCTURAL_ABSTRACTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAYER__STATUS = STRUCTURAL_ABSTRACTION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAYER__SISSY_ID = STRUCTURAL_ABSTRACTION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAYER__SIMPLE_NAME = STRUCTURAL_ABSTRACTION__SIMPLE_NAME;

	/**
	 * The number of structural features of the '<em>Layer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAYER_FEATURE_COUNT = STRUCTURAL_ABSTRACTION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.annotations.impl.ModelAnnotationImpl <em>Model Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.annotations.impl.ModelAnnotationImpl
	 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getModelAnnotation()
	 * @generated
	 */
	int MODEL_ANNOTATION = 7;

	/**
	 * The number of structural features of the '<em>Model Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_ANNOTATION_FEATURE_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link de.fzi.gast.annotations.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute</em>'.
	 * @see de.fzi.gast.annotations.Attribute
	 * @generated
	 */
	EClass getAttribute();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.annotations.Clone <em>Clone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clone</em>'.
	 * @see de.fzi.gast.annotations.Clone
	 * @generated
	 */
	EClass getClone();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.annotations.Clone#getCloneInstances <em>Clone Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Clone Instances</em>'.
	 * @see de.fzi.gast.annotations.Clone#getCloneInstances()
	 * @see #getClone()
	 * @generated
	 */
	EReference getClone_CloneInstances();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.annotations.Clone#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Root</em>'.
	 * @see de.fzi.gast.annotations.Clone#getRoot()
	 * @see #getClone()
	 * @generated
	 */
	EReference getClone_Root();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.annotations.CloneInstance <em>Clone Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clone Instance</em>'.
	 * @see de.fzi.gast.annotations.CloneInstance
	 * @generated
	 */
	EClass getCloneInstance();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.annotations.CloneInstance#getStatements <em>Statements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Statements</em>'.
	 * @see de.fzi.gast.annotations.CloneInstance#getStatements()
	 * @see #getCloneInstance()
	 * @generated
	 */
	EReference getCloneInstance_Statements();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.annotations.CloneInstance#getClone <em>Clone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Clone</em>'.
	 * @see de.fzi.gast.annotations.CloneInstance#getClone()
	 * @see #getCloneInstance()
	 * @generated
	 */
	EReference getCloneInstance_Clone();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.annotations.StructuralAbstraction <em>Structural Abstraction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Structural Abstraction</em>'.
	 * @see de.fzi.gast.annotations.StructuralAbstraction
	 * @generated
	 */
	EClass getStructuralAbstraction();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.annotations.Comment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Comment</em>'.
	 * @see de.fzi.gast.annotations.Comment
	 * @generated
	 */
	EClass getComment();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.annotations.Comment#isTodo <em>Todo</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Todo</em>'.
	 * @see de.fzi.gast.annotations.Comment#isTodo()
	 * @see #getComment()
	 * @generated
	 */
	EAttribute getComment_Todo();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.annotations.Comment#isFormal <em>Formal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Formal</em>'.
	 * @see de.fzi.gast.annotations.Comment#isFormal()
	 * @see #getComment()
	 * @generated
	 */
	EAttribute getComment_Formal();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.annotations.Comment#getTodoCount <em>Todo Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Todo Count</em>'.
	 * @see de.fzi.gast.annotations.Comment#getTodoCount()
	 * @see #getComment()
	 * @generated
	 */
	EAttribute getComment_TodoCount();

	/**
	 * Returns the meta object for the attribute list '{@link de.fzi.gast.annotations.Comment#getTexts <em>Texts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Texts</em>'.
	 * @see de.fzi.gast.annotations.Comment#getTexts()
	 * @see #getComment()
	 * @generated
	 */
	EAttribute getComment_Texts();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.annotations.Subsystem <em>Subsystem</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Subsystem</em>'.
	 * @see de.fzi.gast.annotations.Subsystem
	 * @generated
	 */
	EClass getSubsystem();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.annotations.Layer <em>Layer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Layer</em>'.
	 * @see de.fzi.gast.annotations.Layer
	 * @generated
	 */
	EClass getLayer();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.annotations.ModelAnnotation <em>Model Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model Annotation</em>'.
	 * @see de.fzi.gast.annotations.ModelAnnotation
	 * @generated
	 */
	EClass getModelAnnotation();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	annotationsFactory getannotationsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.fzi.gast.annotations.impl.AttributeImpl <em>Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.annotations.impl.AttributeImpl
		 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getAttribute()
		 * @generated
		 */
		EClass ATTRIBUTE = eINSTANCE.getAttribute();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.annotations.impl.CloneImpl <em>Clone</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.annotations.impl.CloneImpl
		 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getClone()
		 * @generated
		 */
		EClass CLONE = eINSTANCE.getClone();

		/**
		 * The meta object literal for the '<em><b>Clone Instances</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLONE__CLONE_INSTANCES = eINSTANCE.getClone_CloneInstances();

		/**
		 * The meta object literal for the '<em><b>Root</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLONE__ROOT = eINSTANCE.getClone_Root();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.annotations.impl.CloneInstanceImpl <em>Clone Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.annotations.impl.CloneInstanceImpl
		 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getCloneInstance()
		 * @generated
		 */
		EClass CLONE_INSTANCE = eINSTANCE.getCloneInstance();

		/**
		 * The meta object literal for the '<em><b>Statements</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLONE_INSTANCE__STATEMENTS = eINSTANCE.getCloneInstance_Statements();

		/**
		 * The meta object literal for the '<em><b>Clone</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLONE_INSTANCE__CLONE = eINSTANCE.getCloneInstance_Clone();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.annotations.impl.StructuralAbstractionImpl <em>Structural Abstraction</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.annotations.impl.StructuralAbstractionImpl
		 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getStructuralAbstraction()
		 * @generated
		 */
		EClass STRUCTURAL_ABSTRACTION = eINSTANCE.getStructuralAbstraction();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.annotations.impl.CommentImpl <em>Comment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.annotations.impl.CommentImpl
		 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getComment()
		 * @generated
		 */
		EClass COMMENT = eINSTANCE.getComment();

		/**
		 * The meta object literal for the '<em><b>Todo</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMENT__TODO = eINSTANCE.getComment_Todo();

		/**
		 * The meta object literal for the '<em><b>Formal</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMENT__FORMAL = eINSTANCE.getComment_Formal();

		/**
		 * The meta object literal for the '<em><b>Todo Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMENT__TODO_COUNT = eINSTANCE.getComment_TodoCount();

		/**
		 * The meta object literal for the '<em><b>Texts</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMENT__TEXTS = eINSTANCE.getComment_Texts();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.annotations.impl.SubsystemImpl <em>Subsystem</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.annotations.impl.SubsystemImpl
		 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getSubsystem()
		 * @generated
		 */
		EClass SUBSYSTEM = eINSTANCE.getSubsystem();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.annotations.impl.LayerImpl <em>Layer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.annotations.impl.LayerImpl
		 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getLayer()
		 * @generated
		 */
		EClass LAYER = eINSTANCE.getLayer();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.annotations.impl.ModelAnnotationImpl <em>Model Annotation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.annotations.impl.ModelAnnotationImpl
		 * @see de.fzi.gast.annotations.impl.annotationsPackageImpl#getModelAnnotation()
		 * @generated
		 */
		EClass MODEL_ANNOTATION = eINSTANCE.getModelAnnotation();

	}

} //annotationsPackage
