/**
 * <copyright>
 * </copyright>
 *
 * $Id: Comment.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.annotations;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;

import de.fzi.gast.core.SourceEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Comment</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents comments in the program code.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.annotations.Comment#isTodo <em>Todo</em>}</li>
 *   <li>{@link de.fzi.gast.annotations.Comment#isFormal <em>Formal</em>}</li>
 *   <li>{@link de.fzi.gast.annotations.Comment#getTodoCount <em>Todo Count</em>}</li>
 *   <li>{@link de.fzi.gast.annotations.Comment#getTexts <em>Texts</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.annotations.annotationsPackage#getComment()
 * @model
 * @generated
 */
public interface Comment extends SourceEntity, ModelAnnotation {
	/**
	 * Returns the value of the '<em><b>Todo</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if the comment contains TODO tags.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Todo</em>' attribute.
	 * @see de.fzi.gast.annotations.annotationsPackage#getComment_Todo()
	 * @model unsettable="true" required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false" suppressedIsSetVisibility="true"
	 * @generated
	 */
	boolean isTodo();

	/**
	 * Returns the value of the '<em><b>Formal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this is a formal comment.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Formal</em>' attribute.
	 * @see #setFormal(boolean)
	 * @see de.fzi.gast.annotations.annotationsPackage#getComment_Formal()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isFormal();

	/**
	 * Sets the value of the '{@link de.fzi.gast.annotations.Comment#isFormal <em>Formal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Formal</em>' attribute.
	 * @see #isFormal()
	 * @generated
	 */
	void setFormal(boolean value);

	/**
	 * Returns the value of the '<em><b>Todo Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of TODO, HACK or FIXME tags in this comment.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Todo Count</em>' attribute.
	 * @see #setTodoCount(int)
	 * @see de.fzi.gast.annotations.annotationsPackage#getComment_TodoCount()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getTodoCount();

	/**
	 * Sets the value of the '{@link de.fzi.gast.annotations.Comment#getTodoCount <em>Todo Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Todo Count</em>' attribute.
	 * @see #getTodoCount()
	 * @generated
	 */
	void setTodoCount(int value);

	/**
	 * Returns the value of the '<em><b>Texts</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of contains comment lines.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Texts</em>' attribute list.
	 * @see de.fzi.gast.annotations.annotationsPackage#getComment_Texts()
	 * @model ordered="false"
	 * @generated
	 */
	EList<String> getTexts();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * self.todo == (self.todoCount > 0)
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model
	 * @generated
	 */
	boolean OCLtodo(DiagnosticChain diagnostics, Map<Object, Object> context);

} // Comment
