/**
 * <copyright>
 * </copyright>
 *
 * $Id: CloneInstance.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.annotations;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.core.ModelElement;
import de.fzi.gast.statements.Statement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Clone Instance</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a clone instance.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.annotations.CloneInstance#getStatements <em>Statements</em>}</li>
 *   <li>{@link de.fzi.gast.annotations.CloneInstance#getClone <em>Clone</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.annotations.annotationsPackage#getCloneInstance()
 * @model
 * @generated
 */
public interface CloneInstance extends ModelElement, ModelAnnotation {
	/**
	 * Returns the value of the '<em><b>Statements</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.statements.Statement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a collection with references to the statements involved in this clone instance.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Statements</em>' reference list.
	 * @see de.fzi.gast.annotations.annotationsPackage#getCloneInstance_Statements()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	EList<Statement> getStatements();

	/**
	 * Returns the value of the '<em><b>Clone</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.annotations.Clone#getCloneInstances <em>Clone Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is a reference to the related clone.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Clone</em>' container reference.
	 * @see #setClone(Clone)
	 * @see de.fzi.gast.annotations.annotationsPackage#getCloneInstance_Clone()
	 * @see de.fzi.gast.annotations.Clone#getCloneInstances
	 * @model opposite="cloneInstances" required="true" transient="false" ordered="false"
	 * @generated
	 */
	Clone getClone();

	/**
	 * Sets the value of the '{@link de.fzi.gast.annotations.CloneInstance#getClone <em>Clone</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Clone</em>' container reference.
	 * @see #getClone()
	 * @generated
	 */
	void setClone(Clone value);

} // CloneInstance
