/**
 * <copyright>
 * </copyright>
 *
 * $Id: Clone.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.annotations;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Root;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Clone</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a cloned statement sequence. It implements the ModelAnnotation interface, thus it can be attached to arbitrary model elements.
 * Clones are repeated section in source code. Clone analyses tools can be used to detect clones in source code. Analyses results can be represented in a model instance by instances of this model element.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.annotations.Clone#getCloneInstances <em>Clone Instances</em>}</li>
 *   <li>{@link de.fzi.gast.annotations.Clone#getRoot <em>Root</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.annotations.annotationsPackage#getClone()
 * @model
 * @generated
 */
public interface Clone extends ModelElement, ModelAnnotation {
	/**
	 * Returns the value of the '<em><b>Clone Instances</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.annotations.CloneInstance}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.annotations.CloneInstance#getClone <em>Clone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list with references to the clone instances belonging to this clone.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Clone Instances</em>' containment reference list.
	 * @see de.fzi.gast.annotations.annotationsPackage#getClone_CloneInstances()
	 * @see de.fzi.gast.annotations.CloneInstance#getClone
	 * @model opposite="clone" containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<CloneInstance> getCloneInstances();

	/**
	 * Returns the value of the '<em><b>Root</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Root#getClones <em>Clones</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is a reference to the model root.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Root</em>' container reference.
	 * @see #setRoot(Root)
	 * @see de.fzi.gast.annotations.annotationsPackage#getClone_Root()
	 * @see de.fzi.gast.core.Root#getClones
	 * @model opposite="clones" required="true" transient="false" ordered="false"
	 * @generated
	 */
	Root getRoot();

	/**
	 * Sets the value of the '{@link de.fzi.gast.annotations.Clone#getRoot <em>Root</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Root</em>' container reference.
	 * @see #getRoot()
	 * @generated
	 */
	void setRoot(Root value);

} // Clone
