/**
 * <copyright>
 * </copyright>
 *
 * $Id: accessesSwitch.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.accesses.util;

import de.fzi.gast.accesses.*;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.CastTypeAccess;
import de.fzi.gast.accesses.CompositeAccess;
import de.fzi.gast.accesses.DeclarationTypeAccess;
import de.fzi.gast.accesses.DelegateAccess;
import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.accesses.InheritanceTypeAccess;
import de.fzi.gast.accesses.ParameterInstantiationTypeAccess;
import de.fzi.gast.accesses.PropertyAccess;
import de.fzi.gast.accesses.RunTimeTypeAccess;
import de.fzi.gast.accesses.SelfAccess;
import de.fzi.gast.accesses.StaticTypeAccess;
import de.fzi.gast.accesses.ThrowTypeAccess;
import de.fzi.gast.accesses.TypeAccess;
import de.fzi.gast.accesses.VariableAccess;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.core.Identifier;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.SourceEntity;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.gast.accesses.accessesPackage
 * @generated
 */
public class accessesSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static accessesPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public accessesSwitch() {
		if (modelPackage == null) {
			modelPackage = accessesPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case accessesPackage.PARAMETER_INSTANTIATION_TYPE_ACCESS: {
				ParameterInstantiationTypeAccess parameterInstantiationTypeAccess = (ParameterInstantiationTypeAccess)theEObject;
				T result = caseParameterInstantiationTypeAccess(parameterInstantiationTypeAccess);
				if (result == null) result = caseTypeAccess(parameterInstantiationTypeAccess);
				if (result == null) result = caseAccess(parameterInstantiationTypeAccess);
				if (result == null) result = caseBaseAccess(parameterInstantiationTypeAccess);
				if (result == null) result = caseSourceEntity(parameterInstantiationTypeAccess);
				if (result == null) result = caseModelElement(parameterInstantiationTypeAccess);
				if (result == null) result = caseIdentifier(parameterInstantiationTypeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.TYPE_ACCESS: {
				TypeAccess typeAccess = (TypeAccess)theEObject;
				T result = caseTypeAccess(typeAccess);
				if (result == null) result = caseAccess(typeAccess);
				if (result == null) result = caseBaseAccess(typeAccess);
				if (result == null) result = caseSourceEntity(typeAccess);
				if (result == null) result = caseModelElement(typeAccess);
				if (result == null) result = caseIdentifier(typeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.CAST_TYPE_ACCESS: {
				CastTypeAccess castTypeAccess = (CastTypeAccess)theEObject;
				T result = caseCastTypeAccess(castTypeAccess);
				if (result == null) result = caseTypeAccess(castTypeAccess);
				if (result == null) result = caseAccess(castTypeAccess);
				if (result == null) result = caseBaseAccess(castTypeAccess);
				if (result == null) result = caseSourceEntity(castTypeAccess);
				if (result == null) result = caseModelElement(castTypeAccess);
				if (result == null) result = caseIdentifier(castTypeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.COMPOSITE_ACCESS: {
				CompositeAccess compositeAccess = (CompositeAccess)theEObject;
				T result = caseCompositeAccess(compositeAccess);
				if (result == null) result = caseBaseAccess(compositeAccess);
				if (result == null) result = caseSourceEntity(compositeAccess);
				if (result == null) result = caseModelElement(compositeAccess);
				if (result == null) result = caseIdentifier(compositeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.BASE_ACCESS: {
				BaseAccess baseAccess = (BaseAccess)theEObject;
				T result = caseBaseAccess(baseAccess);
				if (result == null) result = caseSourceEntity(baseAccess);
				if (result == null) result = caseModelElement(baseAccess);
				if (result == null) result = caseIdentifier(baseAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.DECLARATION_TYPE_ACCESS: {
				DeclarationTypeAccess declarationTypeAccess = (DeclarationTypeAccess)theEObject;
				T result = caseDeclarationTypeAccess(declarationTypeAccess);
				if (result == null) result = caseTypeAccess(declarationTypeAccess);
				if (result == null) result = caseAccess(declarationTypeAccess);
				if (result == null) result = caseBaseAccess(declarationTypeAccess);
				if (result == null) result = caseSourceEntity(declarationTypeAccess);
				if (result == null) result = caseModelElement(declarationTypeAccess);
				if (result == null) result = caseIdentifier(declarationTypeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.THROW_TYPE_ACCESS: {
				ThrowTypeAccess throwTypeAccess = (ThrowTypeAccess)theEObject;
				T result = caseThrowTypeAccess(throwTypeAccess);
				if (result == null) result = caseTypeAccess(throwTypeAccess);
				if (result == null) result = caseAccess(throwTypeAccess);
				if (result == null) result = caseBaseAccess(throwTypeAccess);
				if (result == null) result = caseSourceEntity(throwTypeAccess);
				if (result == null) result = caseModelElement(throwTypeAccess);
				if (result == null) result = caseIdentifier(throwTypeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.DELEGATE_ACCESS: {
				DelegateAccess delegateAccess = (DelegateAccess)theEObject;
				T result = caseDelegateAccess(delegateAccess);
				if (result == null) result = caseFunctionAccess(delegateAccess);
				if (result == null) result = caseAccess(delegateAccess);
				if (result == null) result = caseBaseAccess(delegateAccess);
				if (result == null) result = caseSourceEntity(delegateAccess);
				if (result == null) result = caseModelElement(delegateAccess);
				if (result == null) result = caseIdentifier(delegateAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.FUNCTION_ACCESS: {
				FunctionAccess functionAccess = (FunctionAccess)theEObject;
				T result = caseFunctionAccess(functionAccess);
				if (result == null) result = caseAccess(functionAccess);
				if (result == null) result = caseBaseAccess(functionAccess);
				if (result == null) result = caseSourceEntity(functionAccess);
				if (result == null) result = caseModelElement(functionAccess);
				if (result == null) result = caseIdentifier(functionAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.INHERITANCE_TYPE_ACCESS: {
				InheritanceTypeAccess inheritanceTypeAccess = (InheritanceTypeAccess)theEObject;
				T result = caseInheritanceTypeAccess(inheritanceTypeAccess);
				if (result == null) result = caseTypeAccess(inheritanceTypeAccess);
				if (result == null) result = caseAccess(inheritanceTypeAccess);
				if (result == null) result = caseBaseAccess(inheritanceTypeAccess);
				if (result == null) result = caseSourceEntity(inheritanceTypeAccess);
				if (result == null) result = caseModelElement(inheritanceTypeAccess);
				if (result == null) result = caseIdentifier(inheritanceTypeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.VARIABLE_ACCESS: {
				VariableAccess variableAccess = (VariableAccess)theEObject;
				T result = caseVariableAccess(variableAccess);
				if (result == null) result = caseAccess(variableAccess);
				if (result == null) result = caseBaseAccess(variableAccess);
				if (result == null) result = caseSourceEntity(variableAccess);
				if (result == null) result = caseModelElement(variableAccess);
				if (result == null) result = caseIdentifier(variableAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.RUN_TIME_TYPE_ACCESS: {
				RunTimeTypeAccess runTimeTypeAccess = (RunTimeTypeAccess)theEObject;
				T result = caseRunTimeTypeAccess(runTimeTypeAccess);
				if (result == null) result = caseTypeAccess(runTimeTypeAccess);
				if (result == null) result = caseAccess(runTimeTypeAccess);
				if (result == null) result = caseBaseAccess(runTimeTypeAccess);
				if (result == null) result = caseSourceEntity(runTimeTypeAccess);
				if (result == null) result = caseModelElement(runTimeTypeAccess);
				if (result == null) result = caseIdentifier(runTimeTypeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.SELF_ACCESS: {
				SelfAccess selfAccess = (SelfAccess)theEObject;
				T result = caseSelfAccess(selfAccess);
				if (result == null) result = caseVariableAccess(selfAccess);
				if (result == null) result = caseAccess(selfAccess);
				if (result == null) result = caseBaseAccess(selfAccess);
				if (result == null) result = caseSourceEntity(selfAccess);
				if (result == null) result = caseModelElement(selfAccess);
				if (result == null) result = caseIdentifier(selfAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.STATIC_TYPE_ACCESS: {
				StaticTypeAccess staticTypeAccess = (StaticTypeAccess)theEObject;
				T result = caseStaticTypeAccess(staticTypeAccess);
				if (result == null) result = caseTypeAccess(staticTypeAccess);
				if (result == null) result = caseAccess(staticTypeAccess);
				if (result == null) result = caseBaseAccess(staticTypeAccess);
				if (result == null) result = caseSourceEntity(staticTypeAccess);
				if (result == null) result = caseModelElement(staticTypeAccess);
				if (result == null) result = caseIdentifier(staticTypeAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.PROPERTY_ACCESS: {
				PropertyAccess propertyAccess = (PropertyAccess)theEObject;
				T result = casePropertyAccess(propertyAccess);
				if (result == null) result = caseVariableAccess(propertyAccess);
				if (result == null) result = caseAccess(propertyAccess);
				if (result == null) result = caseBaseAccess(propertyAccess);
				if (result == null) result = caseSourceEntity(propertyAccess);
				if (result == null) result = caseModelElement(propertyAccess);
				if (result == null) result = caseIdentifier(propertyAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case accessesPackage.ACCESS: {
				Access access = (Access)theEObject;
				T result = caseAccess(access);
				if (result == null) result = caseBaseAccess(access);
				if (result == null) result = caseSourceEntity(access);
				if (result == null) result = caseModelElement(access);
				if (result == null) result = caseIdentifier(access);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter Instantiation Type Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter Instantiation Type Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParameterInstantiationTypeAccess(ParameterInstantiationTypeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeAccess(TypeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAccess(Access object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Composite Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Composite Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompositeAccess(CompositeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Base Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Base Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBaseAccess(BaseAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cast Type Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cast Type Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCastTypeAccess(CastTypeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Declaration Type Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Declaration Type Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeclarationTypeAccess(DeclarationTypeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Delegate Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Delegate Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDelegateAccess(DelegateAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunctionAccess(FunctionAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Inheritance Type Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Inheritance Type Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInheritanceTypeAccess(InheritanceTypeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variable Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variable Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariableAccess(VariableAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Run Time Type Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Run Time Type Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRunTimeTypeAccess(RunTimeTypeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Self Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Self Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSelfAccess(SelfAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Static Type Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Static Type Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStaticTypeAccess(StaticTypeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertyAccess(PropertyAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Throw Type Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Throw Type Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseThrowTypeAccess(ThrowTypeAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelElement(ModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Source Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Source Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSourceEntity(SourceEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //accessesSwitch
