/**
 * <copyright>
 * </copyright>
 *
 * $Id: VariableAccessImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.accesses.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.fzi.gast.accesses.VariableAccess;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.variables.Variable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Variable Access</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.impl.VariableAccessImpl#isWrite <em>Write</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.impl.VariableAccessImpl#getTargetVariable <em>Target Variable</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class VariableAccessImpl extends AccessImpl implements VariableAccess {
	/**
	 * The default value of the '{@link #isWrite() <em>Write</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isWrite()
	 * @generated
	 * @ordered
	 */
	protected static final boolean WRITE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isWrite() <em>Write</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isWrite()
	 * @generated
	 * @ordered
	 */
	protected boolean write = WRITE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableAccessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return accessesPackage.Literals.VARIABLE_ACCESS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isWrite() {
		return write;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWrite(boolean newWrite) {
		boolean oldWrite = write;
		write = newWrite;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, accessesPackage.VARIABLE_ACCESS__WRITE, oldWrite, write));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Variable getTargetVariable() {
		Variable targetVariable = basicGetTargetVariable();
		return targetVariable != null && targetVariable.eIsProxy() ? (Variable)eResolveProxy((InternalEObject)targetVariable) : targetVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Variable basicGetTargetVariable() {
		return (Variable) this.getAccessedTarget();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setTargetVariable(Variable newTargetVariable) {
		this.setAccessedTarget(newTargetVariable);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case accessesPackage.VARIABLE_ACCESS__WRITE:
				return isWrite();
			case accessesPackage.VARIABLE_ACCESS__TARGET_VARIABLE:
				if (resolve) return getTargetVariable();
				return basicGetTargetVariable();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case accessesPackage.VARIABLE_ACCESS__WRITE:
				setWrite((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case accessesPackage.VARIABLE_ACCESS__WRITE:
				setWrite(WRITE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case accessesPackage.VARIABLE_ACCESS__WRITE:
				return write != WRITE_EDEFAULT;
			case accessesPackage.VARIABLE_ACCESS__TARGET_VARIABLE:
				return basicGetTargetVariable() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (write: ");
		result.append(write);
		result.append(')');
		return result.toString();
	}

} //VariableAccessImpl
