/**
 * <copyright>
 * </copyright>
 *
 * $Id: FunctionAccessImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.accesses.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.functions.Function;
import de.fzi.gast.types.GASTType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Function Access</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.impl.FunctionAccessImpl#getTypeArguments <em>Type Arguments</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.impl.FunctionAccessImpl#getTargetFunction <em>Target Function</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FunctionAccessImpl extends AccessImpl implements FunctionAccess {
	/**
	 * The cached value of the '{@link #getTypeArguments() <em>Type Arguments</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeArguments()
	 * @generated
	 * @ordered
	 */
	protected EList<GASTType> typeArguments;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionAccessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return accessesPackage.Literals.FUNCTION_ACCESS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GASTType> getTypeArguments() {
		if (typeArguments == null) {
			typeArguments = new EObjectResolvingEList<GASTType>(GASTType.class, this, accessesPackage.FUNCTION_ACCESS__TYPE_ARGUMENTS);
		}
		return typeArguments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Function getTargetFunction() {
		Function targetFunction = basicGetTargetFunction();
		return targetFunction != null && targetFunction.eIsProxy() ? (Function)eResolveProxy((InternalEObject)targetFunction) : targetFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Function basicGetTargetFunction() {
		return (Function) this.getAccessedTarget();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setTargetFunction(Function newTargetFunction) {
		this.setAccessedTarget(newTargetFunction);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case accessesPackage.FUNCTION_ACCESS__TYPE_ARGUMENTS:
				return getTypeArguments();
			case accessesPackage.FUNCTION_ACCESS__TARGET_FUNCTION:
				if (resolve) return getTargetFunction();
				return basicGetTargetFunction();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case accessesPackage.FUNCTION_ACCESS__TYPE_ARGUMENTS:
				getTypeArguments().clear();
				getTypeArguments().addAll((Collection<? extends GASTType>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case accessesPackage.FUNCTION_ACCESS__TYPE_ARGUMENTS:
				getTypeArguments().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case accessesPackage.FUNCTION_ACCESS__TYPE_ARGUMENTS:
				return typeArguments != null && !typeArguments.isEmpty();
			case accessesPackage.FUNCTION_ACCESS__TARGET_FUNCTION:
				return basicGetTargetFunction() != null;
		}
		return super.eIsSet(featureID);
	}

} //FunctionAccessImpl
