/**
 * <copyright>
 * </copyright>
 *
 * $Id: DelegateAccessImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.accesses.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;

import de.fzi.gast.accesses.DelegateAccess;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.functions.Delegate;
import de.fzi.gast.functions.Function;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Delegate Access</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.impl.DelegateAccessImpl#getAccessedFunctions <em>Accessed Functions</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.impl.DelegateAccessImpl#getAccessedDelegate <em>Accessed Delegate</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DelegateAccessImpl extends FunctionAccessImpl implements DelegateAccess {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DelegateAccessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return accessesPackage.Literals.DELEGATE_ACCESS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Function> getAccessedFunctions() {
		if (this.getAccessedDelegate() ==  null) {
			return new BasicInternalEList<Function>(Function.class);
		} else {
			return this.getAccessedDelegate().getInvocations();
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Delegate getAccessedDelegate() {
		Delegate accessedDelegate = basicGetAccessedDelegate();
		return accessedDelegate != null && accessedDelegate.eIsProxy() ? (Delegate)eResolveProxy((InternalEObject)accessedDelegate) : accessedDelegate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Delegate basicGetAccessedDelegate() {
		return (Delegate)this.getAccessedTarget();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setAccessedDelegate(Delegate newAccessedDelegate) {
		this.setAccessedTarget(newAccessedDelegate);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case accessesPackage.DELEGATE_ACCESS__ACCESSED_FUNCTIONS:
				return getAccessedFunctions();
			case accessesPackage.DELEGATE_ACCESS__ACCESSED_DELEGATE:
				if (resolve) return getAccessedDelegate();
				return basicGetAccessedDelegate();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case accessesPackage.DELEGATE_ACCESS__ACCESSED_FUNCTIONS:
				return !getAccessedFunctions().isEmpty();
			case accessesPackage.DELEGATE_ACCESS__ACCESSED_DELEGATE:
				return basicGetAccessedDelegate() != null;
		}
		return super.eIsSet(featureID);
	}

} //DelegateAccessImpl
