/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.accesses.impl;

import de.fzi.gast.accesses.BaseAccess;
import de.fzi.gast.accesses.CompositeAccess;
import de.fzi.gast.accesses.accessesPackage;

import de.fzi.gast.core.Package;
import de.fzi.gast.core.impl.SourceEntityImpl;

import de.fzi.gast.functions.Function;
import de.fzi.gast.helpers.DerivationHelper;

import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsPackage;

import de.fzi.gast.types.GASTClass;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Base Access</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.impl.BaseAccessImpl#getParentStatement <em>Parent Statement</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.impl.BaseAccessImpl#getSurroundingStatement <em>Surrounding Statement</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.impl.BaseAccessImpl#getSurroundingClass <em>Surrounding Class</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.impl.BaseAccessImpl#getSurroundingFunction <em>Surrounding Function</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.impl.BaseAccessImpl#getSurroundingCompositeAccess <em>Surrounding Composite Access</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class BaseAccessImpl extends SourceEntityImpl implements BaseAccess {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BaseAccessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return accessesPackage.Literals.BASE_ACCESS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Statement getParentStatement() {
		if (eContainerFeatureID() != accessesPackage.BASE_ACCESS__PARENT_STATEMENT) return null;
		return (Statement)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParentStatement(Statement newParentStatement, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newParentStatement, accessesPackage.BASE_ACCESS__PARENT_STATEMENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentStatement(Statement newParentStatement) {
		if (newParentStatement != eInternalContainer() || (eContainerFeatureID() != accessesPackage.BASE_ACCESS__PARENT_STATEMENT && newParentStatement != null)) {
			if (EcoreUtil.isAncestor(this, newParentStatement))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParentStatement != null)
				msgs = ((InternalEObject)newParentStatement).eInverseAdd(this, statementsPackage.STATEMENT__ACCESSES, Statement.class, msgs);
			msgs = basicSetParentStatement(newParentStatement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, accessesPackage.BASE_ACCESS__PARENT_STATEMENT, newParentStatement, newParentStatement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Statement getSurroundingStatement() {
		Statement surroundingStatement = basicGetSurroundingStatement();
		return surroundingStatement != null && surroundingStatement.eIsProxy() ? (Statement)eResolveProxy((InternalEObject)surroundingStatement) : surroundingStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Statement basicGetSurroundingStatement() {
		return (Statement)DerivationHelper.calculateNearestParentOfType(this, Statement.class, Function.class);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Function basicGetSurroundingFunction() {
		return (Function) DerivationHelper.calculateNearestParentOfType(this, Function.class, GASTClass.class);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompositeAccess getSurroundingCompositeAccess() {
		if (eContainerFeatureID() != accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS) return null;
		return (CompositeAccess)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingCompositeAccess(CompositeAccess newSurroundingCompositeAccess, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingCompositeAccess, accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingCompositeAccess(CompositeAccess newSurroundingCompositeAccess) {
		if (newSurroundingCompositeAccess != eInternalContainer() || (eContainerFeatureID() != accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS && newSurroundingCompositeAccess != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingCompositeAccess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingCompositeAccess != null)
				msgs = ((InternalEObject)newSurroundingCompositeAccess).eInverseAdd(this, accessesPackage.COMPOSITE_ACCESS__ACCESSES, CompositeAccess.class, msgs);
			msgs = basicSetSurroundingCompositeAccess(newSurroundingCompositeAccess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS, newSurroundingCompositeAccess, newSurroundingCompositeAccess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GASTClass basicGetSurroundingClass() {
		return (GASTClass) DerivationHelper.calculateNearestParentOfType(this, GASTClass.class, Package.class);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass getSurroundingClass() {
		GASTClass surroundingClass = basicGetSurroundingClass();
		return surroundingClass != null && surroundingClass.eIsProxy() ? (GASTClass)eResolveProxy((InternalEObject)surroundingClass) : surroundingClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Function getSurroundingFunction() {
		Function surroundingFunction = basicGetSurroundingFunction();
		return surroundingFunction != null && surroundingFunction.eIsProxy() ? (Function)eResolveProxy((InternalEObject)surroundingFunction) : surroundingFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case accessesPackage.BASE_ACCESS__PARENT_STATEMENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetParentStatement((Statement)otherEnd, msgs);
			case accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingCompositeAccess((CompositeAccess)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case accessesPackage.BASE_ACCESS__PARENT_STATEMENT:
				return basicSetParentStatement(null, msgs);
			case accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS:
				return basicSetSurroundingCompositeAccess(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case accessesPackage.BASE_ACCESS__PARENT_STATEMENT:
				return eInternalContainer().eInverseRemove(this, statementsPackage.STATEMENT__ACCESSES, Statement.class, msgs);
			case accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS:
				return eInternalContainer().eInverseRemove(this, accessesPackage.COMPOSITE_ACCESS__ACCESSES, CompositeAccess.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case accessesPackage.BASE_ACCESS__PARENT_STATEMENT:
				return getParentStatement();
			case accessesPackage.BASE_ACCESS__SURROUNDING_STATEMENT:
				if (resolve) return getSurroundingStatement();
				return basicGetSurroundingStatement();
			case accessesPackage.BASE_ACCESS__SURROUNDING_CLASS:
				if (resolve) return getSurroundingClass();
				return basicGetSurroundingClass();
			case accessesPackage.BASE_ACCESS__SURROUNDING_FUNCTION:
				if (resolve) return getSurroundingFunction();
				return basicGetSurroundingFunction();
			case accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS:
				return getSurroundingCompositeAccess();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case accessesPackage.BASE_ACCESS__PARENT_STATEMENT:
				setParentStatement((Statement)newValue);
				return;
			case accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS:
				setSurroundingCompositeAccess((CompositeAccess)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case accessesPackage.BASE_ACCESS__PARENT_STATEMENT:
				setParentStatement((Statement)null);
				return;
			case accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS:
				setSurroundingCompositeAccess((CompositeAccess)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case accessesPackage.BASE_ACCESS__PARENT_STATEMENT:
				return getParentStatement() != null;
			case accessesPackage.BASE_ACCESS__SURROUNDING_STATEMENT:
				return basicGetSurroundingStatement() != null;
			case accessesPackage.BASE_ACCESS__SURROUNDING_CLASS:
				return basicGetSurroundingClass() != null;
			case accessesPackage.BASE_ACCESS__SURROUNDING_FUNCTION:
				return basicGetSurroundingFunction() != null;
			case accessesPackage.BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS:
				return getSurroundingCompositeAccess() != null;
		}
		return super.eIsSet(featureID);
	}

} //BaseAccessImpl
