/**
 * <copyright>
 * </copyright>
 *
 * $Id: AccessImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.accesses.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.CompositeAccess;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Package;
import de.fzi.gast.helpers.DerivationHelper;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.TypeDecorator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Access</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.impl.AccessImpl#getAccessedClass <em>Accessed Class</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.impl.AccessImpl#getAccessedTarget <em>Accessed Target</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class AccessImpl extends BaseAccessImpl implements Access {
	/**
	 * The cached value of the '{@link #getAccessedTarget() <em>Accessed Target</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessedTarget()
	 * @generated
	 * @ordered
	 */
	protected ModelElement accessedTarget;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AccessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return accessesPackage.Literals.ACCESS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass getAccessedClass() {
		GASTClass accessedClass = basicGetAccessedClass();
		return accessedClass != null && accessedClass.eIsProxy() ? (GASTClass)eResolveProxy((InternalEObject)accessedClass) : accessedClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GASTClass basicGetAccessedClass() {

		if(accessedTarget == null) {
			accessedTarget = this.getAccessedTarget();
		}
		if (accessedTarget != null) {
			if (accessedTarget instanceof GASTClass) {
				return (GASTClass) accessedTarget;
			} else if (accessedTarget instanceof TypeDecorator) {
				GASTType baseType = ((TypeDecorator)accessedTarget).getUndecoratedType();
				if (baseType instanceof GASTClass) {
					return (GASTClass) baseType;
				} else {
					return null;
				}
			} else {
				return (GASTClass)DerivationHelper.calculateNearestParentOfType(accessedTarget, GASTClass.class, Package.class);
			} 
		} else {
			return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelElement getAccessedTarget() {
		if (accessedTarget != null && accessedTarget.eIsProxy()) {
			InternalEObject oldAccessedTarget = (InternalEObject)accessedTarget;
			accessedTarget = (ModelElement)eResolveProxy(oldAccessedTarget);
			if (accessedTarget != oldAccessedTarget) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, accessesPackage.ACCESS__ACCESSED_TARGET, oldAccessedTarget, accessedTarget));
			}
		}
		return accessedTarget;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelElement basicGetAccessedTarget() {
		return accessedTarget;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessedTarget(ModelElement newAccessedTarget) {
		ModelElement oldAccessedTarget = accessedTarget;
		accessedTarget = newAccessedTarget;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, accessesPackage.ACCESS__ACCESSED_TARGET, oldAccessedTarget, accessedTarget));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case accessesPackage.ACCESS__ACCESSED_CLASS:
				if (resolve) return getAccessedClass();
				return basicGetAccessedClass();
			case accessesPackage.ACCESS__ACCESSED_TARGET:
				if (resolve) return getAccessedTarget();
				return basicGetAccessedTarget();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case accessesPackage.ACCESS__ACCESSED_TARGET:
				setAccessedTarget((ModelElement)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case accessesPackage.ACCESS__ACCESSED_TARGET:
				setAccessedTarget((ModelElement)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case accessesPackage.ACCESS__ACCESSED_CLASS:
				return basicGetAccessedClass() != null;
			case accessesPackage.ACCESS__ACCESSED_TARGET:
				return accessedTarget != null;
		}
		return super.eIsSet(featureID);
	}

} //AccessImpl
