/**
 * <copyright>
 * </copyright>
 *
 * $Id: accessesPackage.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.accesses;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.gast.core.corePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This package contains all access types. Accesses represent relations between program elements like variable accesses, function calls, and type accesses. 
 * <!-- end-model-doc -->
 * @see de.fzi.gast.accesses.accessesFactory
 * @model kind="package"
 * @generated
 */
public interface accessesPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "accesses";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.fzi.de/gast/accesses";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "accesses";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	accessesPackage eINSTANCE = de.fzi.gast.accesses.impl.accessesPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.BaseAccessImpl <em>Base Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.BaseAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getBaseAccess()
	 * @generated
	 */
	int BASE_ACCESS = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__ID = corePackage.SOURCE_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__ANNOTATIONS = corePackage.SOURCE_ENTITY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__STATUS = corePackage.SOURCE_ENTITY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__SISSY_ID = corePackage.SOURCE_ENTITY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__POSITION = corePackage.SOURCE_ENTITY__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__PARENT_STATEMENT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__SURROUNDING_STATEMENT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__SURROUNDING_CLASS = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__SURROUNDING_FUNCTION = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Base Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ACCESS_FEATURE_COUNT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.AccessImpl <em>Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.AccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getAccess()
	 * @generated
	 */
	int ACCESS = 15;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__ID = BASE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__ANNOTATIONS = BASE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__STATUS = BASE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__SISSY_ID = BASE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__POSITION = BASE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__PARENT_STATEMENT = BASE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__SURROUNDING_STATEMENT = BASE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__SURROUNDING_CLASS = BASE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__SURROUNDING_FUNCTION = BASE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__SURROUNDING_COMPOSITE_ACCESS = BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__ACCESSED_CLASS = BASE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS__ACCESSED_TARGET = BASE_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_FEATURE_COUNT = BASE_ACCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.TypeAccessImpl <em>Type Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.TypeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getTypeAccess()
	 * @generated
	 */
	int TYPE_ACCESS = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__ID = ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__ANNOTATIONS = ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__STATUS = ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__SISSY_ID = ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__POSITION = ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__PARENT_STATEMENT = ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__SURROUNDING_STATEMENT = ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__SURROUNDING_CLASS = ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__SURROUNDING_FUNCTION = ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__ACCESSED_CLASS = ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__ACCESSED_TARGET = ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__TARGET_TYPE = ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS__TYPE_ARGUMENTS = ACCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Type Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ACCESS_FEATURE_COUNT = ACCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.ParameterInstantiationTypeAccessImpl <em>Parameter Instantiation Type Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.ParameterInstantiationTypeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getParameterInstantiationTypeAccess()
	 * @generated
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__ID = TYPE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__ANNOTATIONS = TYPE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__STATUS = TYPE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__SISSY_ID = TYPE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__POSITION = TYPE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__PARENT_STATEMENT = TYPE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__SURROUNDING_STATEMENT = TYPE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__SURROUNDING_CLASS = TYPE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__SURROUNDING_FUNCTION = TYPE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__ACCESSED_CLASS = TYPE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__ACCESSED_TARGET = TYPE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__TARGET_TYPE = TYPE_ACCESS__TARGET_TYPE;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS__TYPE_ARGUMENTS = TYPE_ACCESS__TYPE_ARGUMENTS;

	/**
	 * The number of structural features of the '<em>Parameter Instantiation Type Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_INSTANTIATION_TYPE_ACCESS_FEATURE_COUNT = TYPE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.CompositeAccessImpl <em>Composite Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.CompositeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getCompositeAccess()
	 * @generated
	 */
	int COMPOSITE_ACCESS = 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.CastTypeAccessImpl <em>Cast Type Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.CastTypeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getCastTypeAccess()
	 * @generated
	 */
	int CAST_TYPE_ACCESS = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__ID = TYPE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__ANNOTATIONS = TYPE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__STATUS = TYPE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__SISSY_ID = TYPE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__POSITION = TYPE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__PARENT_STATEMENT = TYPE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__SURROUNDING_STATEMENT = TYPE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__SURROUNDING_CLASS = TYPE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__SURROUNDING_FUNCTION = TYPE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__ACCESSED_CLASS = TYPE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__ACCESSED_TARGET = TYPE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__TARGET_TYPE = TYPE_ACCESS__TARGET_TYPE;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS__TYPE_ARGUMENTS = TYPE_ACCESS__TYPE_ARGUMENTS;

	/**
	 * The number of structural features of the '<em>Cast Type Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_TYPE_ACCESS_FEATURE_COUNT = TYPE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__ID = BASE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__ANNOTATIONS = BASE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__STATUS = BASE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__SISSY_ID = BASE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__POSITION = BASE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__PARENT_STATEMENT = BASE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__SURROUNDING_STATEMENT = BASE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__SURROUNDING_CLASS = BASE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__SURROUNDING_FUNCTION = BASE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS__ACCESSES = BASE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Composite Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ACCESS_FEATURE_COUNT = BASE_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.DeclarationTypeAccessImpl <em>Declaration Type Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.DeclarationTypeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getDeclarationTypeAccess()
	 * @generated
	 */
	int DECLARATION_TYPE_ACCESS = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__ID = TYPE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__ANNOTATIONS = TYPE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__STATUS = TYPE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__SISSY_ID = TYPE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__POSITION = TYPE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__PARENT_STATEMENT = TYPE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__SURROUNDING_STATEMENT = TYPE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__SURROUNDING_CLASS = TYPE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__SURROUNDING_FUNCTION = TYPE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__ACCESSED_CLASS = TYPE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__ACCESSED_TARGET = TYPE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__TARGET_TYPE = TYPE_ACCESS__TARGET_TYPE;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__TYPE_ARGUMENTS = TYPE_ACCESS__TYPE_ARGUMENTS;

	/**
	 * The feature id for the '<em><b>Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__FUNCTION = TYPE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Surrounding Variable</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS__SURROUNDING_VARIABLE = TYPE_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Declaration Type Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_TYPE_ACCESS_FEATURE_COUNT = TYPE_ACCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.FunctionAccessImpl <em>Function Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.FunctionAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getFunctionAccess()
	 * @generated
	 */
	int FUNCTION_ACCESS = 8;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.DelegateAccessImpl <em>Delegate Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.DelegateAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getDelegateAccess()
	 * @generated
	 */
	int DELEGATE_ACCESS = 7;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.InheritanceTypeAccessImpl <em>Inheritance Type Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.InheritanceTypeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getInheritanceTypeAccess()
	 * @generated
	 */
	int INHERITANCE_TYPE_ACCESS = 9;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.VariableAccessImpl <em>Variable Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.VariableAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getVariableAccess()
	 * @generated
	 */
	int VARIABLE_ACCESS = 10;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.RunTimeTypeAccessImpl <em>Run Time Type Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.RunTimeTypeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getRunTimeTypeAccess()
	 * @generated
	 */
	int RUN_TIME_TYPE_ACCESS = 11;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.SelfAccessImpl <em>Self Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.SelfAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getSelfAccess()
	 * @generated
	 */
	int SELF_ACCESS = 12;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.StaticTypeAccessImpl <em>Static Type Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.StaticTypeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getStaticTypeAccess()
	 * @generated
	 */
	int STATIC_TYPE_ACCESS = 13;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.PropertyAccessImpl <em>Property Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.PropertyAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getPropertyAccess()
	 * @generated
	 */
	int PROPERTY_ACCESS = 14;

	/**
	 * The meta object id for the '{@link de.fzi.gast.accesses.impl.ThrowTypeAccessImpl <em>Throw Type Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.accesses.impl.ThrowTypeAccessImpl
	 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getThrowTypeAccess()
	 * @generated
	 */
	int THROW_TYPE_ACCESS = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__ID = TYPE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__ANNOTATIONS = TYPE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__STATUS = TYPE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__SISSY_ID = TYPE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__POSITION = TYPE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__PARENT_STATEMENT = TYPE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__SURROUNDING_STATEMENT = TYPE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__SURROUNDING_CLASS = TYPE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__SURROUNDING_FUNCTION = TYPE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__ACCESSED_CLASS = TYPE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__ACCESSED_TARGET = TYPE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__TARGET_TYPE = TYPE_ACCESS__TARGET_TYPE;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__TYPE_ARGUMENTS = TYPE_ACCESS__TYPE_ARGUMENTS;

	/**
	 * The feature id for the '<em><b>Declared</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS__DECLARED = TYPE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Throw Type Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW_TYPE_ACCESS_FEATURE_COUNT = TYPE_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__ID = ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__ANNOTATIONS = ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__STATUS = ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__SISSY_ID = ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__POSITION = ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__PARENT_STATEMENT = ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__SURROUNDING_STATEMENT = ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__SURROUNDING_CLASS = ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__SURROUNDING_FUNCTION = ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__SURROUNDING_COMPOSITE_ACCESS = ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__ACCESSED_CLASS = ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__ACCESSED_TARGET = ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__TYPE_ARGUMENTS = ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS__TARGET_FUNCTION = ACCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Function Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_ACCESS_FEATURE_COUNT = ACCESS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__ID = FUNCTION_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__ANNOTATIONS = FUNCTION_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__STATUS = FUNCTION_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__SISSY_ID = FUNCTION_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__POSITION = FUNCTION_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__PARENT_STATEMENT = FUNCTION_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__SURROUNDING_STATEMENT = FUNCTION_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__SURROUNDING_CLASS = FUNCTION_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__SURROUNDING_FUNCTION = FUNCTION_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = FUNCTION_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__ACCESSED_CLASS = FUNCTION_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__ACCESSED_TARGET = FUNCTION_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__TYPE_ARGUMENTS = FUNCTION_ACCESS__TYPE_ARGUMENTS;

	/**
	 * The feature id for the '<em><b>Target Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__TARGET_FUNCTION = FUNCTION_ACCESS__TARGET_FUNCTION;

	/**
	 * The feature id for the '<em><b>Accessed Functions</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__ACCESSED_FUNCTIONS = FUNCTION_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Accessed Delegate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS__ACCESSED_DELEGATE = FUNCTION_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Delegate Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_ACCESS_FEATURE_COUNT = FUNCTION_ACCESS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__ID = TYPE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__ANNOTATIONS = TYPE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__STATUS = TYPE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__SISSY_ID = TYPE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__POSITION = TYPE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__PARENT_STATEMENT = TYPE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__SURROUNDING_STATEMENT = TYPE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__SURROUNDING_CLASS = TYPE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__SURROUNDING_FUNCTION = TYPE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__ACCESSED_CLASS = TYPE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__ACCESSED_TARGET = TYPE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__TARGET_TYPE = TYPE_ACCESS__TARGET_TYPE;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__TYPE_ARGUMENTS = TYPE_ACCESS__TYPE_ARGUMENTS;

	/**
	 * The feature id for the '<em><b>Implementation Inheritance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS__IMPLEMENTATION_INHERITANCE = TYPE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Inheritance Type Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_TYPE_ACCESS_FEATURE_COUNT = TYPE_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__ID = ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__ANNOTATIONS = ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__STATUS = ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__SISSY_ID = ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__POSITION = ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__PARENT_STATEMENT = ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__SURROUNDING_STATEMENT = ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__SURROUNDING_CLASS = ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__SURROUNDING_FUNCTION = ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__ACCESSED_CLASS = ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__ACCESSED_TARGET = ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Write</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__WRITE = ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS__TARGET_VARIABLE = ACCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variable Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_ACCESS_FEATURE_COUNT = ACCESS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__ID = TYPE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__ANNOTATIONS = TYPE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__STATUS = TYPE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__SISSY_ID = TYPE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__POSITION = TYPE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__PARENT_STATEMENT = TYPE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__SURROUNDING_STATEMENT = TYPE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__SURROUNDING_CLASS = TYPE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__SURROUNDING_FUNCTION = TYPE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__ACCESSED_CLASS = TYPE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__ACCESSED_TARGET = TYPE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__TARGET_TYPE = TYPE_ACCESS__TARGET_TYPE;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS__TYPE_ARGUMENTS = TYPE_ACCESS__TYPE_ARGUMENTS;

	/**
	 * The number of structural features of the '<em>Run Time Type Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_TIME_TYPE_ACCESS_FEATURE_COUNT = TYPE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__ID = VARIABLE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__ANNOTATIONS = VARIABLE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__STATUS = VARIABLE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__SISSY_ID = VARIABLE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__POSITION = VARIABLE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__PARENT_STATEMENT = VARIABLE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__SURROUNDING_STATEMENT = VARIABLE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__SURROUNDING_CLASS = VARIABLE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__SURROUNDING_FUNCTION = VARIABLE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__SURROUNDING_COMPOSITE_ACCESS = VARIABLE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__ACCESSED_CLASS = VARIABLE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__ACCESSED_TARGET = VARIABLE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Write</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__WRITE = VARIABLE_ACCESS__WRITE;

	/**
	 * The feature id for the '<em><b>Target Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__TARGET_VARIABLE = VARIABLE_ACCESS__TARGET_VARIABLE;

	/**
	 * The feature id for the '<em><b>Super</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS__SUPER = VARIABLE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Self Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_ACCESS_FEATURE_COUNT = VARIABLE_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__ID = TYPE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__ANNOTATIONS = TYPE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__STATUS = TYPE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__SISSY_ID = TYPE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__POSITION = TYPE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__PARENT_STATEMENT = TYPE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__SURROUNDING_STATEMENT = TYPE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__SURROUNDING_CLASS = TYPE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__SURROUNDING_FUNCTION = TYPE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = TYPE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__ACCESSED_CLASS = TYPE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__ACCESSED_TARGET = TYPE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__TARGET_TYPE = TYPE_ACCESS__TARGET_TYPE;

	/**
	 * The feature id for the '<em><b>Type Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS__TYPE_ARGUMENTS = TYPE_ACCESS__TYPE_ARGUMENTS;

	/**
	 * The number of structural features of the '<em>Static Type Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_TYPE_ACCESS_FEATURE_COUNT = TYPE_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__ID = VARIABLE_ACCESS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__ANNOTATIONS = VARIABLE_ACCESS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__STATUS = VARIABLE_ACCESS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__SISSY_ID = VARIABLE_ACCESS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__POSITION = VARIABLE_ACCESS__POSITION;

	/**
	 * The feature id for the '<em><b>Parent Statement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__PARENT_STATEMENT = VARIABLE_ACCESS__PARENT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__SURROUNDING_STATEMENT = VARIABLE_ACCESS__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__SURROUNDING_CLASS = VARIABLE_ACCESS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__SURROUNDING_FUNCTION = VARIABLE_ACCESS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__SURROUNDING_COMPOSITE_ACCESS = VARIABLE_ACCESS__SURROUNDING_COMPOSITE_ACCESS;

	/**
	 * The feature id for the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__ACCESSED_CLASS = VARIABLE_ACCESS__ACCESSED_CLASS;

	/**
	 * The feature id for the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__ACCESSED_TARGET = VARIABLE_ACCESS__ACCESSED_TARGET;

	/**
	 * The feature id for the '<em><b>Write</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__WRITE = VARIABLE_ACCESS__WRITE;

	/**
	 * The feature id for the '<em><b>Target Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__TARGET_VARIABLE = VARIABLE_ACCESS__TARGET_VARIABLE;

	/**
	 * The number of structural features of the '<em>Property Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS_FEATURE_COUNT = VARIABLE_ACCESS_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.ParameterInstantiationTypeAccess <em>Parameter Instantiation Type Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter Instantiation Type Access</em>'.
	 * @see de.fzi.gast.accesses.ParameterInstantiationTypeAccess
	 * @generated
	 */
	EClass getParameterInstantiationTypeAccess();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.TypeAccess <em>Type Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Access</em>'.
	 * @see de.fzi.gast.accesses.TypeAccess
	 * @generated
	 */
	EClass getTypeAccess();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.TypeAccess#getTargetType <em>Target Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target Type</em>'.
	 * @see de.fzi.gast.accesses.TypeAccess#getTargetType()
	 * @see #getTypeAccess()
	 * @generated
	 */
	EReference getTypeAccess_TargetType();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.accesses.TypeAccess#getTypeArguments <em>Type Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Type Arguments</em>'.
	 * @see de.fzi.gast.accesses.TypeAccess#getTypeArguments()
	 * @see #getTypeAccess()
	 * @generated
	 */
	EReference getTypeAccess_TypeArguments();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.Access <em>Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Access</em>'.
	 * @see de.fzi.gast.accesses.Access
	 * @generated
	 */
	EClass getAccess();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.Access#getAccessedClass <em>Accessed Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Accessed Class</em>'.
	 * @see de.fzi.gast.accesses.Access#getAccessedClass()
	 * @see #getAccess()
	 * @generated
	 */
	EReference getAccess_AccessedClass();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.Access#getAccessedTarget <em>Accessed Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Accessed Target</em>'.
	 * @see de.fzi.gast.accesses.Access#getAccessedTarget()
	 * @see #getAccess()
	 * @generated
	 */
	EReference getAccess_AccessedTarget();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.CompositeAccess <em>Composite Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Composite Access</em>'.
	 * @see de.fzi.gast.accesses.CompositeAccess
	 * @generated
	 */
	EClass getCompositeAccess();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.accesses.CompositeAccess#getAccesses <em>Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Accesses</em>'.
	 * @see de.fzi.gast.accesses.CompositeAccess#getAccesses()
	 * @see #getCompositeAccess()
	 * @generated
	 */
	EReference getCompositeAccess_Accesses();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.BaseAccess <em>Base Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Base Access</em>'.
	 * @see de.fzi.gast.accesses.BaseAccess
	 * @generated
	 */
	EClass getBaseAccess();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.accesses.BaseAccess#getParentStatement <em>Parent Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Parent Statement</em>'.
	 * @see de.fzi.gast.accesses.BaseAccess#getParentStatement()
	 * @see #getBaseAccess()
	 * @generated
	 */
	EReference getBaseAccess_ParentStatement();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.BaseAccess#getSurroundingStatement <em>Surrounding Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Surrounding Statement</em>'.
	 * @see de.fzi.gast.accesses.BaseAccess#getSurroundingStatement()
	 * @see #getBaseAccess()
	 * @generated
	 */
	EReference getBaseAccess_SurroundingStatement();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.BaseAccess#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Surrounding Class</em>'.
	 * @see de.fzi.gast.accesses.BaseAccess#getSurroundingClass()
	 * @see #getBaseAccess()
	 * @generated
	 */
	EReference getBaseAccess_SurroundingClass();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.BaseAccess#getSurroundingFunction <em>Surrounding Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Surrounding Function</em>'.
	 * @see de.fzi.gast.accesses.BaseAccess#getSurroundingFunction()
	 * @see #getBaseAccess()
	 * @generated
	 */
	EReference getBaseAccess_SurroundingFunction();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.accesses.BaseAccess#getSurroundingCompositeAccess <em>Surrounding Composite Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Composite Access</em>'.
	 * @see de.fzi.gast.accesses.BaseAccess#getSurroundingCompositeAccess()
	 * @see #getBaseAccess()
	 * @generated
	 */
	EReference getBaseAccess_SurroundingCompositeAccess();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.CastTypeAccess <em>Cast Type Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cast Type Access</em>'.
	 * @see de.fzi.gast.accesses.CastTypeAccess
	 * @generated
	 */
	EClass getCastTypeAccess();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.DeclarationTypeAccess <em>Declaration Type Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Declaration Type Access</em>'.
	 * @see de.fzi.gast.accesses.DeclarationTypeAccess
	 * @generated
	 */
	EClass getDeclarationTypeAccess();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.accesses.DeclarationTypeAccess#getSurroundingVariable <em>Surrounding Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Variable</em>'.
	 * @see de.fzi.gast.accesses.DeclarationTypeAccess#getSurroundingVariable()
	 * @see #getDeclarationTypeAccess()
	 * @generated
	 */
	EReference getDeclarationTypeAccess_SurroundingVariable();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.accesses.DeclarationTypeAccess#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Function</em>'.
	 * @see de.fzi.gast.accesses.DeclarationTypeAccess#getFunction()
	 * @see #getDeclarationTypeAccess()
	 * @generated
	 */
	EReference getDeclarationTypeAccess_Function();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.DelegateAccess <em>Delegate Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Delegate Access</em>'.
	 * @see de.fzi.gast.accesses.DelegateAccess
	 * @generated
	 */
	EClass getDelegateAccess();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.accesses.DelegateAccess#getAccessedFunctions <em>Accessed Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Accessed Functions</em>'.
	 * @see de.fzi.gast.accesses.DelegateAccess#getAccessedFunctions()
	 * @see #getDelegateAccess()
	 * @generated
	 */
	EReference getDelegateAccess_AccessedFunctions();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.DelegateAccess#getAccessedDelegate <em>Accessed Delegate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Accessed Delegate</em>'.
	 * @see de.fzi.gast.accesses.DelegateAccess#getAccessedDelegate()
	 * @see #getDelegateAccess()
	 * @generated
	 */
	EReference getDelegateAccess_AccessedDelegate();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.FunctionAccess <em>Function Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function Access</em>'.
	 * @see de.fzi.gast.accesses.FunctionAccess
	 * @generated
	 */
	EClass getFunctionAccess();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.accesses.FunctionAccess#getTypeArguments <em>Type Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Type Arguments</em>'.
	 * @see de.fzi.gast.accesses.FunctionAccess#getTypeArguments()
	 * @see #getFunctionAccess()
	 * @generated
	 */
	EReference getFunctionAccess_TypeArguments();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.FunctionAccess#getTargetFunction <em>Target Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target Function</em>'.
	 * @see de.fzi.gast.accesses.FunctionAccess#getTargetFunction()
	 * @see #getFunctionAccess()
	 * @generated
	 */
	EReference getFunctionAccess_TargetFunction();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.InheritanceTypeAccess <em>Inheritance Type Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Inheritance Type Access</em>'.
	 * @see de.fzi.gast.accesses.InheritanceTypeAccess
	 * @generated
	 */
	EClass getInheritanceTypeAccess();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.accesses.InheritanceTypeAccess#isImplementationInheritance <em>Implementation Inheritance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Implementation Inheritance</em>'.
	 * @see de.fzi.gast.accesses.InheritanceTypeAccess#isImplementationInheritance()
	 * @see #getInheritanceTypeAccess()
	 * @generated
	 */
	EAttribute getInheritanceTypeAccess_ImplementationInheritance();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.VariableAccess <em>Variable Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable Access</em>'.
	 * @see de.fzi.gast.accesses.VariableAccess
	 * @generated
	 */
	EClass getVariableAccess();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.accesses.VariableAccess#isWrite <em>Write</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Write</em>'.
	 * @see de.fzi.gast.accesses.VariableAccess#isWrite()
	 * @see #getVariableAccess()
	 * @generated
	 */
	EAttribute getVariableAccess_Write();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.accesses.VariableAccess#getTargetVariable <em>Target Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target Variable</em>'.
	 * @see de.fzi.gast.accesses.VariableAccess#getTargetVariable()
	 * @see #getVariableAccess()
	 * @generated
	 */
	EReference getVariableAccess_TargetVariable();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.RunTimeTypeAccess <em>Run Time Type Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Run Time Type Access</em>'.
	 * @see de.fzi.gast.accesses.RunTimeTypeAccess
	 * @generated
	 */
	EClass getRunTimeTypeAccess();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.SelfAccess <em>Self Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Self Access</em>'.
	 * @see de.fzi.gast.accesses.SelfAccess
	 * @generated
	 */
	EClass getSelfAccess();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.accesses.SelfAccess#isSuper <em>Super</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Super</em>'.
	 * @see de.fzi.gast.accesses.SelfAccess#isSuper()
	 * @see #getSelfAccess()
	 * @generated
	 */
	EAttribute getSelfAccess_Super();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.StaticTypeAccess <em>Static Type Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Static Type Access</em>'.
	 * @see de.fzi.gast.accesses.StaticTypeAccess
	 * @generated
	 */
	EClass getStaticTypeAccess();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.PropertyAccess <em>Property Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property Access</em>'.
	 * @see de.fzi.gast.accesses.PropertyAccess
	 * @generated
	 */
	EClass getPropertyAccess();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.accesses.ThrowTypeAccess <em>Throw Type Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Throw Type Access</em>'.
	 * @see de.fzi.gast.accesses.ThrowTypeAccess
	 * @generated
	 */
	EClass getThrowTypeAccess();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.accesses.ThrowTypeAccess#isDeclared <em>Declared</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Declared</em>'.
	 * @see de.fzi.gast.accesses.ThrowTypeAccess#isDeclared()
	 * @see #getThrowTypeAccess()
	 * @generated
	 */
	EAttribute getThrowTypeAccess_Declared();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	accessesFactory getaccessesFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.ParameterInstantiationTypeAccessImpl <em>Parameter Instantiation Type Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.ParameterInstantiationTypeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getParameterInstantiationTypeAccess()
		 * @generated
		 */
		EClass PARAMETER_INSTANTIATION_TYPE_ACCESS = eINSTANCE.getParameterInstantiationTypeAccess();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.TypeAccessImpl <em>Type Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.TypeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getTypeAccess()
		 * @generated
		 */
		EClass TYPE_ACCESS = eINSTANCE.getTypeAccess();

		/**
		 * The meta object literal for the '<em><b>Target Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_ACCESS__TARGET_TYPE = eINSTANCE.getTypeAccess_TargetType();

		/**
		 * The meta object literal for the '<em><b>Type Arguments</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_ACCESS__TYPE_ARGUMENTS = eINSTANCE.getTypeAccess_TypeArguments();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.AccessImpl <em>Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.AccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getAccess()
		 * @generated
		 */
		EClass ACCESS = eINSTANCE.getAccess();

		/**
		 * The meta object literal for the '<em><b>Accessed Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACCESS__ACCESSED_CLASS = eINSTANCE.getAccess_AccessedClass();

		/**
		 * The meta object literal for the '<em><b>Accessed Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACCESS__ACCESSED_TARGET = eINSTANCE.getAccess_AccessedTarget();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.CompositeAccessImpl <em>Composite Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.CompositeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getCompositeAccess()
		 * @generated
		 */
		EClass COMPOSITE_ACCESS = eINSTANCE.getCompositeAccess();

		/**
		 * The meta object literal for the '<em><b>Accesses</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPOSITE_ACCESS__ACCESSES = eINSTANCE.getCompositeAccess_Accesses();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.BaseAccessImpl <em>Base Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.BaseAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getBaseAccess()
		 * @generated
		 */
		EClass BASE_ACCESS = eINSTANCE.getBaseAccess();

		/**
		 * The meta object literal for the '<em><b>Parent Statement</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BASE_ACCESS__PARENT_STATEMENT = eINSTANCE.getBaseAccess_ParentStatement();

		/**
		 * The meta object literal for the '<em><b>Surrounding Statement</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BASE_ACCESS__SURROUNDING_STATEMENT = eINSTANCE.getBaseAccess_SurroundingStatement();

		/**
		 * The meta object literal for the '<em><b>Surrounding Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BASE_ACCESS__SURROUNDING_CLASS = eINSTANCE.getBaseAccess_SurroundingClass();

		/**
		 * The meta object literal for the '<em><b>Surrounding Function</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BASE_ACCESS__SURROUNDING_FUNCTION = eINSTANCE.getBaseAccess_SurroundingFunction();

		/**
		 * The meta object literal for the '<em><b>Surrounding Composite Access</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BASE_ACCESS__SURROUNDING_COMPOSITE_ACCESS = eINSTANCE.getBaseAccess_SurroundingCompositeAccess();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.CastTypeAccessImpl <em>Cast Type Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.CastTypeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getCastTypeAccess()
		 * @generated
		 */
		EClass CAST_TYPE_ACCESS = eINSTANCE.getCastTypeAccess();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.DeclarationTypeAccessImpl <em>Declaration Type Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.DeclarationTypeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getDeclarationTypeAccess()
		 * @generated
		 */
		EClass DECLARATION_TYPE_ACCESS = eINSTANCE.getDeclarationTypeAccess();

		/**
		 * The meta object literal for the '<em><b>Surrounding Variable</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DECLARATION_TYPE_ACCESS__SURROUNDING_VARIABLE = eINSTANCE.getDeclarationTypeAccess_SurroundingVariable();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DECLARATION_TYPE_ACCESS__FUNCTION = eINSTANCE.getDeclarationTypeAccess_Function();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.DelegateAccessImpl <em>Delegate Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.DelegateAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getDelegateAccess()
		 * @generated
		 */
		EClass DELEGATE_ACCESS = eINSTANCE.getDelegateAccess();

		/**
		 * The meta object literal for the '<em><b>Accessed Functions</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE_ACCESS__ACCESSED_FUNCTIONS = eINSTANCE.getDelegateAccess_AccessedFunctions();

		/**
		 * The meta object literal for the '<em><b>Accessed Delegate</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE_ACCESS__ACCESSED_DELEGATE = eINSTANCE.getDelegateAccess_AccessedDelegate();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.FunctionAccessImpl <em>Function Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.FunctionAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getFunctionAccess()
		 * @generated
		 */
		EClass FUNCTION_ACCESS = eINSTANCE.getFunctionAccess();

		/**
		 * The meta object literal for the '<em><b>Type Arguments</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_ACCESS__TYPE_ARGUMENTS = eINSTANCE.getFunctionAccess_TypeArguments();

		/**
		 * The meta object literal for the '<em><b>Target Function</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_ACCESS__TARGET_FUNCTION = eINSTANCE.getFunctionAccess_TargetFunction();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.InheritanceTypeAccessImpl <em>Inheritance Type Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.InheritanceTypeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getInheritanceTypeAccess()
		 * @generated
		 */
		EClass INHERITANCE_TYPE_ACCESS = eINSTANCE.getInheritanceTypeAccess();

		/**
		 * The meta object literal for the '<em><b>Implementation Inheritance</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INHERITANCE_TYPE_ACCESS__IMPLEMENTATION_INHERITANCE = eINSTANCE.getInheritanceTypeAccess_ImplementationInheritance();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.VariableAccessImpl <em>Variable Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.VariableAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getVariableAccess()
		 * @generated
		 */
		EClass VARIABLE_ACCESS = eINSTANCE.getVariableAccess();

		/**
		 * The meta object literal for the '<em><b>Write</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VARIABLE_ACCESS__WRITE = eINSTANCE.getVariableAccess_Write();

		/**
		 * The meta object literal for the '<em><b>Target Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE_ACCESS__TARGET_VARIABLE = eINSTANCE.getVariableAccess_TargetVariable();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.RunTimeTypeAccessImpl <em>Run Time Type Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.RunTimeTypeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getRunTimeTypeAccess()
		 * @generated
		 */
		EClass RUN_TIME_TYPE_ACCESS = eINSTANCE.getRunTimeTypeAccess();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.SelfAccessImpl <em>Self Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.SelfAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getSelfAccess()
		 * @generated
		 */
		EClass SELF_ACCESS = eINSTANCE.getSelfAccess();

		/**
		 * The meta object literal for the '<em><b>Super</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SELF_ACCESS__SUPER = eINSTANCE.getSelfAccess_Super();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.StaticTypeAccessImpl <em>Static Type Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.StaticTypeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getStaticTypeAccess()
		 * @generated
		 */
		EClass STATIC_TYPE_ACCESS = eINSTANCE.getStaticTypeAccess();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.PropertyAccessImpl <em>Property Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.PropertyAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getPropertyAccess()
		 * @generated
		 */
		EClass PROPERTY_ACCESS = eINSTANCE.getPropertyAccess();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.accesses.impl.ThrowTypeAccessImpl <em>Throw Type Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.accesses.impl.ThrowTypeAccessImpl
		 * @see de.fzi.gast.accesses.impl.accessesPackageImpl#getThrowTypeAccess()
		 * @generated
		 */
		EClass THROW_TYPE_ACCESS = eINSTANCE.getThrowTypeAccess();

		/**
		 * The meta object literal for the '<em><b>Declared</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute THROW_TYPE_ACCESS__DECLARED = eINSTANCE.getThrowTypeAccess_Declared();

	}

} //accessesPackage
